/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.platform.http;

import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Service;
import org.apache.camel.Suspendable;
import org.apache.camel.SuspendableService;
import org.apache.camel.component.platform.http.PlatformHttpComponent;
import org.apache.camel.component.platform.http.PlatformHttpEndpoint;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.support.service.ServiceHelper;

public class PlatformHttpConsumer
extends DefaultConsumer
implements Suspendable,
SuspendableService {
    private Consumer delegatedConsumer;

    public PlatformHttpConsumer(Endpoint endpoint, Processor processor) {
        super(endpoint, processor);
    }

    public PlatformHttpEndpoint getEndpoint() {
        return (PlatformHttpEndpoint)super.getEndpoint();
    }

    public PlatformHttpComponent getComponent() {
        return this.getEndpoint().getComponent();
    }

    protected void doInit() throws Exception {
        super.doInit();
        this.delegatedConsumer = this.getEndpoint().createDelegateConsumer(this.getProcessor());
    }

    protected void doStart() throws Exception {
        super.doStart();
        ServiceHelper.startService((Service)this.delegatedConsumer);
        this.getComponent().addHttpEndpoint(this.getEndpoint().getPath(), this.getEndpoint().getHttpMethodRestrict(), this.getEndpoint().getConsumes(), this.getEndpoint().getProduces(), this.delegatedConsumer);
    }

    protected void doStop() throws Exception {
        super.doStop();
        this.getComponent().removeHttpEndpoint(this.getEndpoint().getPath());
        ServiceHelper.stopAndShutdownServices((Object[])new Object[]{this.delegatedConsumer});
    }

    protected void doResume() throws Exception {
        ServiceHelper.resumeService((Object)this.delegatedConsumer);
        super.doResume();
    }

    protected void doSuspend() throws Exception {
        ServiceHelper.suspendService((Object)this.delegatedConsumer);
        super.doSuspend();
    }
}

