/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.plc4x;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.slf4j.LoggerFactory;

public class TagData {
    private String tagName;
    private String query;
    private Object value;
    private Map<Class<?>, Predicate<String>> canParse = new HashMap();

    public TagData(String alias, String query, Object value) {
        this.canParse.put(Integer.TYPE, s -> {
            try {
                Integer.parseInt(s);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        });
        this.canParse.put(Long.TYPE, s -> {
            try {
                Long.parseLong(s);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        });
        this.canParse.put(Short.TYPE, s -> {
            try {
                Short.parseShort(s);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        });
        this.canParse.put(Boolean.TYPE, s -> {
            try {
                Boolean.parseBoolean(s);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        });
        this.canParse.put(Double.TYPE, s -> {
            try {
                Double.parseDouble(s);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        });
        this.canParse.put(Float.TYPE, s -> {
            try {
                Float.parseFloat(s);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        });
        this.tagName = alias;
        this.query = query;
        this.value = value;
        this.setType();
    }

    public TagData(String tagName, String query) {
        this.canParse.put(Integer.TYPE, s -> {
            try {
                Integer.parseInt(s);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        });
        this.canParse.put(Long.TYPE, s -> {
            try {
                Long.parseLong(s);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        });
        this.canParse.put(Short.TYPE, s -> {
            try {
                Short.parseShort(s);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        });
        this.canParse.put(Boolean.TYPE, s -> {
            try {
                Boolean.parseBoolean(s);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        });
        this.canParse.put(Double.TYPE, s -> {
            try {
                Double.parseDouble(s);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        });
        this.canParse.put(Float.TYPE, s -> {
            try {
                Float.parseFloat(s);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        });
        this.tagName = tagName;
        this.query = query;
    }

    public String getTagName() {
        return this.tagName;
    }

    public void setTagName(String tagName) {
        this.tagName = tagName;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    private void setType() {
        if (this.value != null && this.value instanceof String) {
            String val = (String)this.value;
            if (this.canParse.get(Boolean.TYPE).test(val)) {
                this.value = Boolean.parseBoolean(val);
            }
            if (this.canParse.get(Short.TYPE).test(val)) {
                this.value = Short.parseShort(val);
            } else if (this.canParse.get(Integer.TYPE).test(val)) {
                this.value = Integer.parseInt(val);
            } else if (this.canParse.get(Long.TYPE).test(val)) {
                this.value = Long.parseLong(val);
            } else if (this.canParse.get(Double.TYPE).test(val)) {
                this.value = Double.parseDouble(val);
            } else if (this.canParse.get(Float.TYPE).test(val)) {
                this.value = Float.valueOf(Float.parseFloat(val));
            }
        }
    }

    public String toString() {
        return "(" + this.tagName + ") : " + this.value;
    }

    public boolean equals(Object tag) {
        if (!(tag instanceof TagData)) {
            return false;
        }
        return this.value != null ? ((TagData)tag).getValue().equals(this.value) && ((TagData)tag).getTagName().equals(this.tagName) && ((TagData)tag).getQuery().equals(this.query) : ((TagData)tag).getTagName().equals(this.tagName) && ((TagData)tag).getQuery().equals(this.query);
    }

    public int hashCode() {
        return Objects.hash(this.tagName, this.query, this.value, this.canParse);
    }

    public static Map<String, String> toMap(List<TagData> tags) {
        HashMap<String, String> map = new HashMap<String, String>();
        LoggerFactory.getLogger(TagData.class).info("Classloader {} ", (Object)Thread.currentThread().getContextClassLoader());
        for (TagData tag : tags) {
            map.put(tag.getTagName(), tag.getQuery());
        }
        return map;
    }
}

