/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.pubnub;

import com.pubnub.api.PubNubException;
import com.pubnub.api.models.consumer.PNErrorData;
import com.pubnub.api.models.consumer.PNStatus;
import java.util.Arrays;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.pubnub.PubNubConfiguration;
import org.apache.camel.component.pubnub.PubNubEndpoint;
import org.apache.camel.support.DefaultAsyncProducer;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PubNubProducer
extends DefaultAsyncProducer {
    private static final Logger LOG = LoggerFactory.getLogger(PubNubProducer.class);
    private final PubNubEndpoint endpoint;
    private final PubNubConfiguration pubnubConfiguration;

    public PubNubProducer(PubNubEndpoint endpoint, PubNubConfiguration pubNubConfiguration) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
        this.pubnubConfiguration = pubNubConfiguration;
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        Operation operation = this.getOperation(exchange);
        LOG.debug("Executing {} operation", (Object)operation);
        try {
            switch (operation.ordinal()) {
                case 5: {
                    this.doPublish(exchange, callback);
                    break;
                }
                case 6: {
                    this.doFire(exchange, callback);
                    break;
                }
                case 4: {
                    this.doGetHistory(exchange, callback);
                    break;
                }
                case 2: {
                    this.doGetState(exchange, callback);
                    break;
                }
                case 0: {
                    this.doHereNow(exchange, callback);
                    break;
                }
                case 3: {
                    this.doSetState(exchange, callback);
                    break;
                }
                case 1: {
                    this.doWhereNow(exchange, callback);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(operation.toString());
                }
            }
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
            callback.done(true);
            return true;
        }
        return false;
    }

    private void doPublish(Exchange exchange, AsyncCallback callback) {
        Object body = exchange.getIn().getBody();
        if (ObjectHelper.isEmpty((Object)body)) {
            throw new RuntimeCamelException("Can not publish empty message");
        }
        LOG.debug("Sending message [{}] to channel [{}]", body, (Object)this.getChannel(exchange));
        this.endpoint.getPubnub().publish().message(body).channel(this.getChannel(exchange)).usePOST(Boolean.valueOf(true)).async((result, status) -> {
            if (!status.isError()) {
                exchange.getIn().setHeader("CamelPubNubTimeToken", (Object)result.getTimetoken());
            }
            this.processMessage(exchange, callback, status, null);
        });
    }

    private void doFire(Exchange exchange, AsyncCallback callback) {
        Object body = exchange.getIn().getBody();
        if (ObjectHelper.isEmpty((Object)body)) {
            exchange.setException((Throwable)new CamelException("Can not fire empty message"));
            callback.done(true);
        }
        LOG.debug("Sending message [{}] to channel [{}]", body, (Object)this.getChannel(exchange));
        this.endpoint.getPubnub().fire().message(body).channel(this.getChannel(exchange)).async((result, status) -> {
            if (!status.isError()) {
                exchange.getIn().setHeader("CamelPubNubTimeToken", (Object)result.getTimetoken());
            }
            this.processMessage(exchange, callback, status, null);
        });
    }

    private void doGetHistory(Exchange exchange, AsyncCallback callback) {
        this.endpoint.getPubnub().history().channel(this.getChannel(exchange)).async((result, status) -> {
            LOG.debug("Got history message [{}]", result);
            this.processMessage(exchange, callback, status, result.getMessages());
        });
    }

    private void doSetState(Exchange exchange, AsyncCallback callback) {
        Object body = exchange.getIn().getBody();
        if (ObjectHelper.isEmpty((Object)body)) {
            exchange.setException((Throwable)new CamelException("Can not publish empty message"));
            callback.done(true);
        }
        LOG.debug("Sending setState [{}] to channel [{}]", body, (Object)this.getChannel(exchange));
        this.endpoint.getPubnub().setPresenceState().channels(Arrays.asList(this.getChannel(exchange))).state(body).uuid(this.getUUID(exchange)).async((result, status) -> {
            LOG.debug("Got setState responsee [{}]", result);
            this.processMessage(exchange, callback, status, result);
        });
    }

    private void doGetState(Exchange exchange, AsyncCallback callback) {
        this.endpoint.getPubnub().getPresenceState().channels(Arrays.asList(this.getChannel(exchange))).uuid(this.getUUID(exchange)).async((result, status) -> {
            LOG.debug("Got state [{}]", (Object)result.getStateByUUID());
            this.processMessage(exchange, callback, status, result);
        });
    }

    private void doHereNow(Exchange exchange, AsyncCallback callback) {
        this.endpoint.getPubnub().hereNow().channels(Arrays.asList(this.getChannel(exchange))).includeState(Boolean.valueOf(true)).includeUUIDs(Boolean.valueOf(true)).async((result, status) -> {
            LOG.debug("Got herNow message [{}]", result);
            this.processMessage(exchange, callback, status, result);
        });
    }

    private void doWhereNow(Exchange exchange, AsyncCallback callback) {
        this.endpoint.getPubnub().whereNow().uuid(this.getUUID(exchange)).async((result, status) -> {
            LOG.debug("Got whereNow message [{}]", (Object)result.getChannels());
            this.processMessage(exchange, callback, status, result.getChannels());
        });
    }

    private void processMessage(Exchange exchange, AsyncCallback callback, PNStatus status, Object body) {
        if (status.isError()) {
            PNErrorData errorData = status.getErrorData();
            exchange.setException((Throwable)errorData.getThrowable());
            if (errorData != null && errorData.getThrowable() instanceof PubNubException) {
                PubNubException pubNubException = (PubNubException)errorData.getThrowable();
                throw new RuntimeCamelException(pubNubException.getPubnubError().getMessage(), (Throwable)errorData.getThrowable());
            }
            throw new RuntimeCamelException((Throwable)status.getErrorData().getThrowable());
        }
        ExchangeHelper.setInOutBodyPatternAware((Exchange)exchange, (Object)body);
        callback.done(false);
    }

    private Operation getOperation(Exchange exchange) {
        String operation = (String)exchange.getIn().getHeader("CamelPubNubOperation", String.class);
        if (operation == null) {
            operation = this.pubnubConfiguration.getOperation();
        }
        return operation != null ? Operation.valueOf(operation.toUpperCase()) : Operation.PUBLISH;
    }

    private String getChannel(Exchange exchange) {
        String channel = (String)exchange.getIn().getHeader("CamelPubNubChannel", String.class);
        return channel != null ? channel : this.pubnubConfiguration.getChannel();
    }

    private String getUUID(Exchange exchange) {
        String uuid = (String)exchange.getIn().getHeader("CamelPubNubUUID", String.class);
        return uuid != null ? uuid : this.pubnubConfiguration.getUuid();
    }

    private static enum Operation {
        HERENOW,
        WHERENOW,
        GETSTATE,
        SETSTATE,
        GETHISTORY,
        PUBLISH,
        FIRE;

    }
}

