/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.pulsar;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.TypeConversionException;
import org.apache.camel.component.pulsar.PulsarConfiguration;
import org.apache.camel.component.pulsar.PulsarEndpoint;
import org.apache.camel.component.pulsar.utils.message.PulsarMessageUtils;
import org.apache.camel.support.DefaultAsyncProducer;
import org.apache.camel.util.CastUtils;
import org.apache.camel.util.ObjectHelper;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.ProducerBuilder;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.TypedMessageBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PulsarProducer
extends DefaultAsyncProducer {
    private static final Logger LOG = LoggerFactory.getLogger(PulsarProducer.class);
    private final Object mutex = new Object();
    private final PulsarEndpoint pulsarEndpoint;
    private volatile Producer<byte[]> producer;

    public PulsarProducer(PulsarEndpoint pulsarEndpoint) {
        super((Endpoint)pulsarEndpoint);
        this.pulsarEndpoint = pulsarEndpoint;
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            Long eventTime;
            Map properties;
            Message message = exchange.getIn();
            byte[] body = PulsarProducer.serialize(exchange, message.getBody());
            TypedMessageBuilder messageBuilder = this.producer.newMessage();
            messageBuilder.value((Object)body);
            String key = (String)exchange.getIn().getHeader("CamelPulsarProducerMessageKey", String.class);
            if (ObjectHelper.isNotEmpty((String)key)) {
                messageBuilder.key(key);
            }
            if (ObjectHelper.isNotEmpty((Map)(properties = CastUtils.cast((Map)((Map)exchange.getIn().getHeader("CamelPulsarProducerMessageProperties", Map.class)))))) {
                messageBuilder.properties(properties);
            }
            if ((eventTime = (Long)exchange.getIn().getHeader("CamelPulsarProducerMessageEventTime", Long.class)) != null) {
                messageBuilder.eventTime(eventTime.longValue());
            }
            ((CompletableFuture)messageBuilder.sendAsync().thenAccept(r -> exchange.getIn().setBody(r))).whenComplete((r, e) -> {
                try {
                    if (e != null) {
                        exchange.setException((Throwable)new CamelExchangeException("An error occurred while sending a message to pulsar", exchange, e));
                    }
                }
                finally {
                    callback.done(false);
                }
            });
        }
        catch (Exception e2) {
            exchange.setException((Throwable)e2);
            callback.done(true);
            return true;
        }
        return false;
    }

    private static byte[] serialize(Exchange exchange, Object content) throws IOException {
        byte[] result;
        try {
            result = (byte[])exchange.getContext().getTypeConverter().mandatoryConvertTo(byte[].class, exchange, content);
        }
        catch (NoTypeConversionAvailableException | TypeConversionException exception) {
            result = PulsarMessageUtils.serialize(content);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createProducer() throws PulsarClientException {
        Object object = this.mutex;
        synchronized (object) {
            if (this.producer == null) {
                String topicUri = this.pulsarEndpoint.getUri();
                PulsarConfiguration configuration = this.pulsarEndpoint.getPulsarConfiguration();
                String producerName = configuration.getProducerName();
                ProducerBuilder producerBuilder = this.pulsarEndpoint.getPulsarClient().newProducer().topic(topicUri).sendTimeout(configuration.getSendTimeoutMs(), TimeUnit.MILLISECONDS).blockIfQueueFull(configuration.isBlockIfQueueFull()).maxPendingMessages(configuration.getMaxPendingMessages()).maxPendingMessagesAcrossPartitions(configuration.getMaxPendingMessagesAcrossPartitions()).batchingMaxPublishDelay(configuration.getBatchingMaxPublishDelayMicros(), TimeUnit.MICROSECONDS).batchingMaxMessages(configuration.getMaxPendingMessages()).enableBatching(configuration.isBatchingEnabled()).batcherBuilder(configuration.getBatcherBuilder()).initialSequenceId(configuration.getInitialSequenceId()).compressionType(configuration.getCompressionType());
                if (ObjectHelper.isNotEmpty((Object)configuration.getMessageRouter())) {
                    producerBuilder.messageRouter(configuration.getMessageRouter());
                } else {
                    producerBuilder.messageRoutingMode(configuration.getMessageRoutingMode());
                }
                if (producerName != null) {
                    producerBuilder.producerName(producerName);
                }
                this.producer = producerBuilder.create();
            }
        }
    }

    protected void doStart() throws Exception {
        LOG.debug("Starting the pulsar producer: {}", (Object)this);
        if (this.producer == null) {
            this.createProducer();
        }
    }

    protected void doStop() throws Exception {
        LOG.debug("Stopping the pulsar producer: {}", (Object)this);
        if (this.producer != null) {
            this.producer.close();
            this.producer = null;
        }
    }
}

