/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.python;

import org.apache.camel.Exchange;
import org.apache.camel.ExpressionIllegalSyntaxException;
import org.apache.camel.support.ExpressionSupport;
import org.python.core.PyCode;
import org.python.core.PyObject;
import org.python.util.PythonInterpreter;

public class PythonExpression
extends ExpressionSupport {
    private final String expressionString;
    private final Class<?> type;
    private final PythonInterpreter compiler;
    private final PyCode compiledExpression;

    public PythonExpression(String expressionString, Class<?> type) {
        this.expressionString = expressionString;
        this.type = type;
        this.compiler = new PythonInterpreter();
        try {
            this.compiledExpression = this.compiler.compile(expressionString);
        }
        catch (Exception e) {
            throw new ExpressionIllegalSyntaxException(expressionString, (Throwable)e);
        }
    }

    public static PythonExpression python(String expression) {
        return new PythonExpression(expression, Object.class);
    }

    public <T> T evaluate(Exchange exchange, Class<T> type) {
        try {
            this.compiler.set("exchange", (Object)exchange);
            this.compiler.set("context", (Object)exchange.getContext());
            this.compiler.set("exchangeId", (Object)exchange.getExchangeId());
            this.compiler.set("message", (Object)exchange.getMessage());
            this.compiler.set("headers", (Object)exchange.getMessage().getHeaders());
            this.compiler.set("properties", (Object)exchange.getAllProperties());
            this.compiler.set("body", exchange.getMessage().getBody());
            PyObject out = this.compiler.eval((PyObject)this.compiledExpression);
            if (out != null) {
                String value = out.toString();
                Object object = exchange.getContext().getTypeConverter().convertTo(type, (Object)value);
                return (T)object;
            }
        }
        catch (Exception e) {
            throw new ExpressionIllegalSyntaxException(this.expressionString, (Throwable)e);
        }
        finally {
            this.compiler.cleanup();
        }
        return null;
    }

    public Class<?> getType() {
        return this.type;
    }

    protected String assertionFailureMessage(Exchange exchange) {
        return this.expressionString;
    }

    public String toString() {
        return "Python[" + this.expressionString + "]";
    }
}

