/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.qdrant;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.qdrant.client.QdrantClient;
import io.qdrant.client.WithPayloadSelectorFactory;
import io.qdrant.client.WithVectorsSelectorFactory;
import io.qdrant.client.grpc.Collections;
import io.qdrant.client.grpc.Points;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.function.BiConsumer;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.NoSuchHeaderException;
import org.apache.camel.component.qdrant.QdrantAction;
import org.apache.camel.component.qdrant.QdrantActionException;
import org.apache.camel.component.qdrant.QdrantEndpoint;
import org.apache.camel.support.DefaultAsyncProducer;

public class QdrantProducer
extends DefaultAsyncProducer {
    private QdrantClient client;
    private ExecutorService executor;

    public QdrantProducer(QdrantEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public QdrantEndpoint getEndpoint() {
        return (QdrantEndpoint)super.getEndpoint();
    }

    public void doStart() throws Exception {
        super.doStart();
        this.client = this.getEndpoint().getClient();
        this.executor = this.getCamelContext().getExecutorServiceManager().newSingleThreadExecutor((Object)this, "producer:" + this.getEndpoint().getId());
    }

    public void doStop() throws Exception {
        super.doStop();
        if (this.executor != null) {
            this.getCamelContext().getExecutorServiceManager().shutdownNow(this.executor);
            this.executor = null;
        }
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        Message in = exchange.getMessage();
        QdrantAction action = (QdrantAction)((Object)in.getHeader("CamelQdrantAction", QdrantAction.class));
        try {
            if (action == null) {
                throw new NoSuchHeaderException("The action is a required header", exchange, "CamelQdrantAction");
            }
            switch (action) {
                case CREATE_COLLECTION: {
                    return this.createCollection(exchange, callback);
                }
                case UPSERT: {
                    return this.upsert(exchange, callback);
                }
                case RETRIEVE: {
                    return this.retrieve(exchange, callback);
                }
                case DELETE: {
                    return this.delete(exchange, callback);
                }
                case COLLECTION_INFO: {
                    return this.collectionInfo(exchange, callback);
                }
            }
            throw new UnsupportedOperationException("Unsupported action: " + action.name());
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
            callback.done(true);
            return true;
        }
    }

    private boolean upsert(Exchange exchange, AsyncCallback callback) throws Exception {
        String collection = this.getEndpoint().getCollection();
        Message in = exchange.getMessage();
        List points = (List)in.getMandatoryBody(List.class);
        Points.UpsertPoints value = Points.UpsertPoints.newBuilder().setCollectionName(collection).addAllPoints((Iterable)points).setWait(true).build();
        this.call(this.client.upsertAsync(value), (r, t) -> {
            if (t != null) {
                exchange.setException((Throwable)new QdrantActionException(QdrantAction.UPSERT, (Throwable)t));
            } else {
                in.setHeader("CamelQdrantOperationID", (Object)r.getOperationId());
                in.setHeader("CamelQdrantOperationStatus", (Object)r.getStatus().name());
                in.setHeader("CamelQdrantOperationStatusValue", (Object)r.getStatus().getNumber());
            }
            callback.done(false);
        });
        return false;
    }

    private boolean retrieve(Exchange exchange, AsyncCallback callback) throws Exception {
        String collection = this.getEndpoint().getCollection();
        Message in = exchange.getMessage();
        List ids = (List)in.getMandatoryBody(List.class);
        this.call(this.client.retrieveAsync(collection, ids, WithPayloadSelectorFactory.enable((boolean)((Boolean)in.getHeader("CamelQdrantWithPayload", (Object)true, Boolean.TYPE))), WithVectorsSelectorFactory.enable((boolean)((Boolean)in.getHeader("CamelQdrantWithVectors", (Object)false, Boolean.TYPE))), (Points.ReadConsistency)in.getHeader("CamelQdrantReadConsistency", Points.ReadConsistency.class)), (r, t) -> {
            if (t != null) {
                exchange.setException((Throwable)new QdrantActionException(QdrantAction.RETRIEVE, (Throwable)t));
            } else {
                in.setBody(new ArrayList(r));
                in.setHeader("CamelQdrantSize", (Object)r.size());
            }
            callback.done(false);
        });
        return false;
    }

    private boolean collectionInfo(Exchange exchange, AsyncCallback callback) throws Exception {
        String collection = this.getEndpoint().getCollection();
        Message in = exchange.getMessage();
        this.call(this.client.getCollectionInfoAsync(collection), (r, t) -> {
            if (t != null) {
                exchange.setException((Throwable)new QdrantActionException(QdrantAction.COLLECTION_INFO, (Throwable)t));
            } else {
                in.setBody(r);
            }
            callback.done(false);
        });
        return false;
    }

    private boolean delete(Exchange exchange, AsyncCallback callback) throws Exception {
        String collection = this.getEndpoint().getCollection();
        Message in = exchange.getMessage();
        Points.PointsSelector selector = (Points.PointsSelector)in.getMandatoryBody(Points.PointsSelector.class);
        Points.DeletePoints value = Points.DeletePoints.newBuilder().setCollectionName(collection).setPoints(selector).setWait(true).build();
        this.call(this.client.deleteAsync(value), (r, t) -> {
            if (t != null) {
                exchange.setException((Throwable)new QdrantActionException(QdrantAction.DELETE, (Throwable)t));
            } else {
                in.setHeader("CamelQdrantOperationID", (Object)r.getOperationId());
                in.setHeader("CamelQdrantOperationStatus", (Object)r.getStatus().name());
                in.setHeader("CamelQdrantOperationStatusValue", (Object)r.getStatus().getNumber());
            }
            callback.done(false);
        });
        return false;
    }

    private boolean createCollection(Exchange exchange, AsyncCallback callback) throws Exception {
        Message in = exchange.getMessage();
        Collections.VectorParams body = (Collections.VectorParams)in.getMandatoryBody(Collections.VectorParams.class);
        String collection = this.getEndpoint().getCollection();
        this.call(this.client.createCollectionAsync(collection, body), (r, t) -> {
            if (t != null) {
                exchange.setException((Throwable)new QdrantActionException(QdrantAction.CREATE_COLLECTION, (Throwable)t));
            }
            callback.done(false);
        });
        return false;
    }

    private CamelContext getCamelContext() {
        return this.getEndpoint().getCamelContext();
    }

    private <T> void call(ListenableFuture<T> future, final BiConsumer<T, Throwable> consumer) {
        Futures.addCallback(future, (FutureCallback)new FutureCallback<T>(){

            public void onSuccess(T result) {
                consumer.accept(result, null);
            }

            public void onFailure(Throwable t) {
                consumer.accept(null, t);
            }
        }, (Executor)this.executor);
    }
}

