/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.reactive.streams;

import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.component.reactive.streams.ReactiveStreamsBackpressureStrategy;
import org.apache.camel.component.reactive.streams.ReactiveStreamsComponent;
import org.apache.camel.component.reactive.streams.ReactiveStreamsConstants;
import org.apache.camel.component.reactive.streams.ReactiveStreamsConsumer;
import org.apache.camel.component.reactive.streams.ReactiveStreamsProducer;
import org.apache.camel.component.reactive.streams.api.CamelReactiveStreamsService;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;

@UriEndpoint(firstVersion="2.19.0", scheme="reactive-streams", title="Reactive Streams", syntax="reactive-streams:stream", category={Category.MESSAGING}, headersClass=ReactiveStreamsConstants.class)
@ManagedResource(description="Managed ReactiveStreamsEndpoint")
public class ReactiveStreamsEndpoint
extends DefaultEndpoint {
    @UriPath
    private String stream;
    @UriParam(label="consumer", defaultValue="128")
    private Integer maxInflightExchanges = 128;
    @UriParam(label="consumer", defaultValue="0.25")
    private double exchangesRefillLowWatermark = 0.25;
    @UriParam(label="consumer", defaultValue="1")
    private int concurrentConsumers = 1;
    @UriParam(label="consumer", defaultValue="false")
    private boolean forwardOnComplete;
    @UriParam(label="consumer", defaultValue="false")
    private boolean forwardOnError;
    @UriParam(label="producer")
    private ReactiveStreamsBackpressureStrategy backpressureStrategy;

    public ReactiveStreamsEndpoint(String endpointUri, ReactiveStreamsComponent component) {
        super(endpointUri, (Component)component);
    }

    public Producer createProducer() throws Exception {
        return new ReactiveStreamsProducer(this, this.stream, this.getReactiveStreamsService());
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        return new ReactiveStreamsConsumer(this, processor, this.getReactiveStreamsService());
    }

    @ManagedAttribute(description="Name of the stream channel used by the endpoint to exchange messages")
    public String getStream() {
        return this.stream;
    }

    public void setStream(String stream) {
        this.stream = stream;
    }

    @ManagedAttribute(description="Maximum number of exchanges concurrently being processed by Camel")
    public Integer getMaxInflightExchanges() {
        return this.maxInflightExchanges;
    }

    public void setMaxInflightExchanges(Integer maxInflightExchanges) {
        this.maxInflightExchanges = maxInflightExchanges;
    }

    public int getConcurrentConsumers() {
        return this.concurrentConsumers;
    }

    @ManagedAttribute(description="Number of threads used to process exchanges in the Camel route")
    public void setConcurrentConsumers(int concurrentConsumers) {
        this.concurrentConsumers = concurrentConsumers;
    }

    public ReactiveStreamsBackpressureStrategy getBackpressureStrategy() {
        return this.backpressureStrategy;
    }

    public void setBackpressureStrategy(ReactiveStreamsBackpressureStrategy backpressureStrategy) {
        this.backpressureStrategy = backpressureStrategy;
    }

    @ManagedAttribute(description="Determines if onComplete events should be pushed to the Camel route")
    public boolean isForwardOnComplete() {
        return this.forwardOnComplete;
    }

    public void setForwardOnComplete(boolean forwardOnComplete) {
        this.forwardOnComplete = forwardOnComplete;
    }

    @ManagedAttribute(description="Determines if onError events should be pushed to the Camel route")
    public boolean isForwardOnError() {
        return this.forwardOnError;
    }

    public void setForwardOnError(boolean forwardOnError) {
        this.forwardOnError = forwardOnError;
    }

    @ManagedAttribute(description="The percentage of maxInflightExchanges below which new items can be requested to the source subscription")
    public double getExchangesRefillLowWatermark() {
        return this.exchangesRefillLowWatermark;
    }

    public void setExchangesRefillLowWatermark(double exchangesRefillLowWatermark) {
        this.exchangesRefillLowWatermark = exchangesRefillLowWatermark;
    }

    CamelReactiveStreamsService getReactiveStreamsService() {
        return ((ReactiveStreamsComponent)this.getComponent()).getReactiveStreamsService();
    }
}

