/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.htmlxlsx.model;

public class RouteTotalsStatistic {
    private int totalEips;
    private int totalEipsTested;
    private int totalProcessingTime;
    private int coverage;

    public void incrementTotalEips(int totalEips) {
        this.totalEips += totalEips;
        this.calculateCoverage();
    }

    public void incrementTotalEipsTested(int totalEipsTested) {
        this.totalEipsTested += totalEipsTested;
        this.calculateCoverage();
    }

    public void incrementTotalProcessingTime(int processingTime) {
        this.totalProcessingTime += processingTime;
    }

    protected void calculateCoverage() {
        if (this.totalEips > 0) {
            this.coverage = 100 * this.totalEipsTested / this.totalEips;
        }
    }

    public int getTotalEips() {
        return this.totalEips;
    }

    public void setTotalEips(int totalEips) {
        this.totalEips = totalEips;
    }

    public int getTotalEipsTested() {
        return this.totalEipsTested;
    }

    public void setTotalEipsTested(int totalEipsTested) {
        this.totalEipsTested = totalEipsTested;
    }

    public int getTotalProcessingTime() {
        return this.totalProcessingTime;
    }

    public void setTotalProcessingTime(int totalProcessingTime) {
        this.totalProcessingTime = totalProcessingTime;
    }

    public int getCoverage() {
        return this.coverage;
    }

    public void setCoverage(int coverage) {
        this.coverage = coverage;
    }

    public String toString() {
        return "RouteTotalsStatistic{totalEips=" + this.totalEips + ", totalEipsTested=" + this.totalEipsTested + ", totalProcessingTime=" + this.totalProcessingTime + ", coverage=" + this.coverage + "}";
    }
}

