/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.github;

import org.apache.camel.CamelContext;
import org.apache.camel.github.GistResource;
import org.apache.camel.spi.Resource;
import org.apache.camel.spi.annotations.ResourceResolver;
import org.apache.camel.support.service.ServiceSupport;

@ResourceResolver(value="gist")
public class GistResourceResolver
extends ServiceSupport
implements org.apache.camel.spi.ResourceResolver {
    private static final String GIST_URL = "https://gist.githubusercontent.com/%s/%s/raw/%s/%s";
    private CamelContext camelContext;

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public String getSupportedScheme() {
        return "gist";
    }

    public Resource resolve(String location) {
        String[] parts = location.split(":");
        String user = null;
        String gid = null;
        String gid2 = null;
        String fileName = null;
        if (parts.length == 5) {
            user = parts[1];
            gid = parts[2];
            gid2 = parts[3];
            fileName = parts[4];
        }
        if (user == null || gid == null || gid2 == null || fileName == null) {
            throw new IllegalArgumentException(location);
        }
        String target = String.format(GIST_URL, user, gid, gid2, fileName);
        return new GistResource(this.camelContext, target);
    }
}

