/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rest.openapi;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.security.SecurityScheme;
import io.swagger.v3.oas.models.servers.Server;
import io.swagger.v3.parser.OpenAPIV3Parser;
import io.swagger.v3.parser.core.models.ParseOptions;
import io.swagger.v3.parser.core.models.SwaggerParseResult;
import java.io.Closeable;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.ExchangePattern;
import org.apache.camel.NoSuchBeanException;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.platform.http.spi.PlatformHttpConsumerAware;
import org.apache.camel.component.rest.openapi.RestOpenApiComponent;
import org.apache.camel.component.rest.openapi.RestOpenApiHelper;
import org.apache.camel.component.rest.openapi.RestOpenApiProcessor;
import org.apache.camel.component.rest.openapi.RestOpenApiProducer;
import org.apache.camel.component.rest.openapi.RestOpenapiProcessorStrategy;
import org.apache.camel.component.rest.openapi.validator.DefaultRequestValidator;
import org.apache.camel.component.rest.openapi.validator.RequestValidator;
import org.apache.camel.component.rest.openapi.validator.RestOpenApiOperation;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.Resource;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.spi.RestOpenApiConsumerFactory;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.support.ResourceHelper;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.UnsafeUriCharactersEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(firstVersion="3.1.0", scheme="rest-openapi", title="REST OpenApi", syntax="rest-openapi:specificationUri#operationId", category={Category.REST, Category.API})
public final class RestOpenApiEndpoint
extends DefaultEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(RestOpenApiEndpoint.class);
    public static final String[] DEFAULT_REST_OPENAPI_CONSUMER_COMPONENTS = new String[]{"platform-http"};
    Map<String, Object> parameters = Collections.emptyMap();
    @UriParam(description="API basePath, for example \"`/v3`\". Default is unset, if set overrides the value present in OpenApi specification and in the component configuration.", label="producer")
    private String basePath;
    @UriParam(description="Name of the Camel component that will perform the requests. The component must be present in Camel registry and it must implement RestProducerFactory service provider interface. If not set CLASSPATH is searched for single component that implements RestProducerFactory SPI. Overrides component configuration.", label="producer,advanced")
    private String componentName;
    @UriParam(description="Name of the Camel component that will service the requests. The component must be present in Camel registry and it must implement RestOpenApiConsumerFactory service provider interface. If not set CLASSPATH is searched for single component that implements RestOpenApiConsumerFactory SPI. Overrides component configuration.", label="consumer,advanced")
    private String consumerComponentName;
    @UriParam(description="Scheme hostname and port to direct the HTTP requests to in the form of `http[s]://hostname[:port]`. Can be configured at the endpoint, component or in the corresponding REST configuration in the Camel Context. If you give this component a name (e.g. `petstore`) that REST configuration is consulted first, `rest-openapi` next, and global configuration last. If set overrides any value found in the OpenApi specification, RestConfiguration. Overrides all other  configuration.", label="producer")
    private String host;
    @UriPath(description="ID of the operation from the OpenApi specification. This is required when using producer", label="producer")
    private String operationId;
    @UriParam(description="What payload type this component capable of consuming. Could be one type, like `application/json` or multiple types as `application/json, application/xml; q=0.5` according to the RFC7231. This equates or multiple types as `application/json, application/xml; q=0.5` according to the RFC7231. This equates to the value of `Accept` HTTP header. If set overrides any value found in the OpenApi specification and. in the component configuration", label="consumer")
    private String consumes;
    @UriParam(description="What payload type this component is producing. For example `application/json` according to the RFC7231. This equates to the value of `Content-Type` HTTP header. If set overrides any value present in the OpenApi specification. Overrides all other configuration.", label="producer")
    private String produces;
    @UriPath(description="Path to the OpenApi specification file. The scheme, host base path are taken from this specification, but these can be overridden with properties on the component or endpoint level. If not given the component tries to load `openapi.json` resource from the classpath. Note that the `host` defined on the component and endpoint of this Component should contain the scheme, hostname and optionally the port in the URI syntax (i.e. `http://api.example.com:8080`). Overrides component configuration. The OpenApi specification can be loaded from different sources by prefixing with file: classpath: http: https:. Support for https is limited to using the JDK installed UrlHandler, and as such it can be cumbersome to setup TLS/SSL certificates for https (such as setting a number of javax.net.ssl JVM system properties). How to do that consult the JDK documentation for UrlHandler.", defaultValue="openapi.json", defaultValueNote="By default loads `openapi.json` file", label="common")
    private String specificationUri;
    @Metadata(label="consumer,advanced", description="Package name to use as base (offset) for classpath scanning of POJO classes are located when using binding mode is enabled for JSon or XML. Multiple package names can be separated by comma.")
    private String bindingPackageScan;
    @UriParam(label="consumer", description="Whether to enable validation of the client request to check if the incoming request is valid according to the OpenAPI specification")
    private boolean clientRequestValidation;
    @UriParam(label="producer", description="Enable validation of requests against the configured OpenAPI specification")
    private boolean requestValidationEnabled;
    @UriParam(description="To use a custom strategy for how to process Rest DSL requests", label="consumer,advanced")
    private RestOpenapiProcessorStrategy restOpenapiProcessorStrategy;
    @UriParam(description="Whether the consumer should fail,ignore or return a mock response for OpenAPI operations that are not mapped to a corresponding route.", enums="fail,ignore,mock", label="consumer", defaultValue="fail")
    private String missingOperation;
    @UriParam(description="Used for inclusive filtering of mock data from directories. The pattern is using Ant-path style pattern. Multiple patterns can be specified separated by comma.", label="consumer,advanced", defaultValue="classpath:camel-mock/**")
    private String mockIncludePattern;
    @UriParam(label="consumer", description="Sets the context-path to use for servicing the OpenAPI specification")
    private String apiContextPath;

    public RestOpenApiEndpoint() {
    }

    public RestOpenApiEndpoint(String uri, String remaining, RestOpenApiComponent component, Map<String, Object> parameters) {
        super(uri, (Component)component);
        if (remaining.contains("#")) {
            this.operationId = StringHelper.after((String)remaining, (String)"#");
            String spec = StringHelper.before((String)remaining, (String)"#");
            if (spec != null && !spec.isEmpty()) {
                this.specificationUri = spec;
            }
        } else if (remaining.endsWith(".json") || remaining.endsWith(".yaml") || remaining.endsWith(".yml")) {
            this.specificationUri = remaining;
        } else {
            this.operationId = remaining;
        }
        if (this.specificationUri == null) {
            this.specificationUri = component.getSpecificationUri();
        }
        if (this.specificationUri == null) {
            this.specificationUri = "openapi.json";
        }
        this.parameters = parameters;
        this.setExchangePattern(ExchangePattern.InOut);
    }

    public RestOpenApiComponent getComponent() {
        return (RestOpenApiComponent)super.getComponent();
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        OpenAPI doc = RestOpenApiEndpoint.loadSpecificationFrom(this.getCamelContext(), this.specificationUri);
        String path = this.determineBasePath(doc);
        RestOpenApiProcessor target = new RestOpenApiProcessor(this, doc, path, this.apiContextPath, processor, this.restOpenapiProcessorStrategy);
        CamelContextAware.trySetCamelContext((Object)((Object)target), (CamelContext)this.getCamelContext());
        Consumer consumer = this.createConsumerFor(path, target);
        target.setConsumer(consumer);
        return consumer;
    }

    protected Consumer createConsumerFor(String basePath, RestOpenApiProcessor processor) throws Exception {
        Set factories;
        Component comp;
        RestOpenApiConsumerFactory factory = null;
        String cname = null;
        if (this.getConsumerComponentName() != null) {
            comp = this.getCamelContext().getRegistry().lookupByName(this.getConsumerComponentName());
            if (comp instanceof RestOpenApiConsumerFactory) {
                factory = (RestOpenApiConsumerFactory)comp;
            } else {
                comp = this.getCamelContext().getComponent(this.getConsumerComponentName());
                if (comp instanceof RestOpenApiConsumerFactory) {
                    factory = (RestOpenApiConsumerFactory)comp;
                }
            }
            if (factory == null) {
                if (comp != null) {
                    throw new IllegalArgumentException("Component " + this.getConsumerComponentName() + " is not a RestOpenApiConsumerFactory");
                }
                throw new NoSuchBeanException(this.getConsumerComponentName(), RestOpenApiConsumerFactory.class.getName());
            }
            cname = this.getConsumerComponentName();
        }
        if (factory == null) {
            comp = this.getCamelContext().getComponentNames().iterator();
            while (comp.hasNext()) {
                String name = (String)comp.next();
                Component comp2 = this.getCamelContext().getComponent(name);
                if (!(comp2 instanceof RestOpenApiConsumerFactory)) continue;
                factory = (RestOpenApiConsumerFactory)comp2;
                cname = name;
                break;
            }
        }
        if (factory == null && (comp = this.getCamelContext().getComponent("platform-http", true)) instanceof RestOpenApiConsumerFactory) {
            factory = (RestOpenApiConsumerFactory)comp;
            LOG.debug("Auto discovered platform-http as RestConsumerFactory");
        }
        if (factory == null && (factories = this.getCamelContext().getRegistry().findByType(RestOpenApiConsumerFactory.class)) != null && factories.size() == 1) {
            factory = (RestOpenApiConsumerFactory)factories.iterator().next();
        }
        if (factory == null) {
            RestOpenApiConsumerFactory found = null;
            Component foundName = null;
            for (Component name : DEFAULT_REST_OPENAPI_CONSUMER_COMPONENTS) {
                Component comp3 = this.getCamelContext().getComponent((String)name, true);
                if (!(comp3 instanceof RestOpenApiConsumerFactory)) continue;
                if (found == null) {
                    found = (RestOpenApiConsumerFactory)comp3;
                    foundName = name;
                    continue;
                }
                throw new IllegalArgumentException("Multiple RestOpenApiConsumerFactory found on classpath. Configure explicit which component to use");
            }
            if (found != null) {
                LOG.debug("Auto discovered {} as RestOpenApiConsumerFactory", foundName);
                factory = found;
            }
        }
        if (factory != null) {
            RestConfiguration config = CamelContextHelper.getRestConfiguration((CamelContext)this.getCamelContext(), cname);
            HashMap<String, Object> copy = new HashMap<String, Object>(this.parameters);
            Consumer consumer = factory.createConsumer(this.getCamelContext(), (Processor)processor, basePath, config, copy);
            if (consumer instanceof PlatformHttpConsumerAware) {
                PlatformHttpConsumerAware phca = (PlatformHttpConsumerAware)consumer;
                processor.setPlatformHttpConsumer(phca);
            }
            this.configureConsumer(consumer);
            return consumer;
        }
        throw new IllegalStateException("Cannot find RestOpenApiConsumerFactory in Registry or as a Component to use");
    }

    public Producer createProducer() throws Exception {
        CamelContext camelContext = this.getCamelContext();
        OpenAPI openapiDoc = RestOpenApiEndpoint.loadSpecificationFrom(camelContext, this.specificationUri);
        Paths paths = openapiDoc.getPaths();
        for (Map.Entry pathEntry : paths.entrySet()) {
            PathItem path = (PathItem)pathEntry.getValue();
            Map operationMap = path.readOperationsMap();
            Optional<Map.Entry> maybeOperationEntry = operationMap.entrySet().stream().filter(operationEntry -> this.operationId.equals(((Operation)operationEntry.getValue()).getOperationId())).findAny();
            if (!maybeOperationEntry.isPresent()) continue;
            Map.Entry operationEntry2 = maybeOperationEntry.get();
            Operation operation = (Operation)operationEntry2.getValue();
            Map<String, Object> pathParameters = operation.getParameters() != null ? operation.getParameters().stream().filter(p -> "path".equals(p.getIn())).collect(Collectors.toMap(Parameter::getName, Function.identity())) : new HashMap<String, Parameter>();
            String uriTemplate = this.resolveUri((String)pathEntry.getKey(), pathParameters);
            PathItem.HttpMethod httpMethod = (PathItem.HttpMethod)operationEntry2.getKey();
            String method = httpMethod.name();
            return this.createProducerFor(openapiDoc, operation, method, uriTemplate);
        }
        String supportedOperations = paths.values().stream().flatMap(p -> p.readOperations().stream()).map(Operation::getOperationId).collect(Collectors.joining(", "));
        throw new IllegalArgumentException("The specified operation with ID: `" + this.operationId + "` cannot be found in the OpenApi specification loaded from `" + this.specificationUri + "`. Operations defined in the specification are: " + supportedOperations);
    }

    public String getBasePath() {
        return this.basePath;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public String getConsumerComponentName() {
        return this.consumerComponentName;
    }

    public String getConsumes() {
        return this.consumes;
    }

    public String getHost() {
        return this.host;
    }

    public String getOperationId() {
        return this.operationId;
    }

    public String getProduces() {
        return this.produces;
    }

    public String getSpecificationUri() {
        return this.specificationUri;
    }

    public boolean isLenientProperties() {
        return true;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    public void setConsumerComponentName(String consumerComponentName) {
        this.consumerComponentName = consumerComponentName;
    }

    public void setConsumes(String consumes) {
        this.consumes = consumes;
    }

    public void setHost(String host) {
        this.host = RestOpenApiHelper.isHostParam(host);
    }

    public void setOperationId(String operationId) {
        this.operationId = operationId;
    }

    public void setProduces(String produces) {
        this.produces = produces;
    }

    public void setSpecificationUri(String specificationUri) {
        this.specificationUri = specificationUri;
    }

    public void setRequestValidationEnabled(boolean requestValidationEnabled) {
        this.requestValidationEnabled = requestValidationEnabled;
    }

    public boolean isRequestValidationEnabled() {
        return this.requestValidationEnabled;
    }

    public boolean isClientRequestValidation() {
        return this.clientRequestValidation;
    }

    public void setClientRequestValidation(boolean clientRequestValidation) {
        this.clientRequestValidation = clientRequestValidation;
    }

    public RestOpenapiProcessorStrategy getRestOpenapiProcessorStrategy() {
        return this.restOpenapiProcessorStrategy;
    }

    public void setRestOpenapiProcessorStrategy(RestOpenapiProcessorStrategy restOpenapiProcessorStrategy) {
        this.restOpenapiProcessorStrategy = restOpenapiProcessorStrategy;
    }

    public String getMissingOperation() {
        return this.missingOperation;
    }

    public void setMissingOperation(String missingOperation) {
        this.missingOperation = missingOperation;
    }

    public void setMockIncludePattern(String mockIncludePattern) {
        this.mockIncludePattern = mockIncludePattern;
    }

    public String getMockIncludePattern() {
        return this.mockIncludePattern;
    }

    public String getApiContextPath() {
        return this.apiContextPath;
    }

    public void setApiContextPath(String apiContextPath) {
        this.apiContextPath = apiContextPath;
    }

    public String getBindingPackageScan() {
        return this.bindingPackageScan;
    }

    public void setBindingPackageScan(String bindingPackageScan) {
        this.bindingPackageScan = bindingPackageScan;
    }

    Producer createProducerFor(OpenAPI openapi, Operation operation, String method, String uriTemplate) throws Exception {
        CamelContext camelContext = this.getCamelContext();
        Map<String, Object> params = this.determineEndpointParameters(openapi, operation);
        boolean hasHost = params.containsKey("host");
        String basePath = this.determineBasePath(openapi);
        String componentEndpointUri = "rest:" + method + ":" + basePath + ":" + uriTemplate;
        if (hasHost) {
            componentEndpointUri = componentEndpointUri + "?host=" + params.get("host");
        }
        Endpoint endpoint = camelContext.getEndpoint(componentEndpointUri);
        endpoint.configureProperties(params);
        RequestValidator requestValidator = null;
        if (this.requestValidationEnabled) {
            requestValidator = this.configureRequestValidator(openapi, operation, method, uriTemplate);
        }
        return new RestOpenApiProducer(endpoint.createProducer(), hasHost, requestValidator);
    }

    String determineBasePath(OpenAPI openapi) {
        if (ObjectHelper.isNotEmpty((String)this.basePath)) {
            return this.basePath;
        }
        String componentBasePath = this.getComponent().getBasePath();
        if (ObjectHelper.isNotEmpty((String)componentBasePath)) {
            return componentBasePath;
        }
        String specificationBasePath = RestOpenApiHelper.getBasePathFromOpenApi(openapi);
        if (ObjectHelper.isNotEmpty((String)specificationBasePath)) {
            return specificationBasePath;
        }
        CamelContext camelContext = this.getCamelContext();
        RestConfiguration restConfiguration = CamelContextHelper.getRestConfiguration((CamelContext)camelContext, null, (String)this.determineComponentName());
        String restConfigurationBasePath = restConfiguration.getContextPath();
        if (ObjectHelper.isNotEmpty((String)restConfigurationBasePath)) {
            return restConfigurationBasePath;
        }
        return "/";
    }

    String determineComponentName() {
        return Optional.ofNullable(this.componentName).orElse(this.getComponent().getComponentName());
    }

    Map<String, Object> determineEndpointParameters(OpenAPI openapi, Operation operation) {
        String queryParameters;
        String determinedProducers;
        String determinedConsumes;
        String host;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        String componentName = this.determineComponentName();
        if (componentName != null) {
            parameters.put("producerComponentName", componentName);
        }
        if ((host = this.determineHost(openapi, operation)) != null) {
            parameters.put("host", host);
        }
        RestOpenApiComponent component = this.getComponent();
        ArrayList<String> specificationLevelConsumers = new ArrayList<String>();
        HashSet<String> operationLevelConsumers = new HashSet<String>();
        if (operation.getResponses() != null) {
            for (ApiResponse response : operation.getResponses().values()) {
                if (response.getContent() == null) continue;
                operationLevelConsumers.addAll(response.getContent().keySet());
            }
        }
        if (ObjectHelper.isNotEmpty((String)(determinedConsumes = RestOpenApiEndpoint.determineOption(specificationLevelConsumers, operationLevelConsumers, component.getConsumes(), this.consumes)))) {
            parameters.put("consumes", determinedConsumes);
        }
        ArrayList<String> specificationLevelProducers = new ArrayList<String>();
        HashSet<String> operationLevelProducers = new HashSet<String>();
        if (operation.getRequestBody() != null && operation.getRequestBody().getContent() != null) {
            operationLevelProducers.addAll(operation.getRequestBody().getContent().keySet());
        }
        if (ObjectHelper.isNotEmpty((String)(determinedProducers = RestOpenApiEndpoint.determineOption(specificationLevelProducers, operationLevelProducers, component.getProduces(), this.produces)))) {
            parameters.put("produces", determinedProducers);
        }
        if (ObjectHelper.isNotEmpty((String)(queryParameters = RestOpenApiEndpoint.determineQueryParameters(openapi, operation).map(this::queryParameter).collect(Collectors.joining("&"))))) {
            parameters.put("queryParameters", queryParameters);
        }
        HashMap<String, Boolean> componentParameters = new HashMap<String, Boolean>();
        if (component.isUseGlobalSslContextParameters()) {
            componentParameters.put("useGlobalSslContextParameters", component.isUseGlobalSslContextParameters());
        }
        if (component.getSslContextParameters() != null) {
            componentParameters.put("sslContextParameters", (Boolean)component.getSslContextParameters());
        }
        HashMap<String, Object> nestedParameters = new HashMap<String, Object>();
        if (!componentParameters.isEmpty()) {
            nestedParameters.put("component", componentParameters);
        }
        if (this.parameters != null) {
            if (operation.getParameters() != null) {
                for (Map.Entry<String, Object> entry : this.parameters.entrySet()) {
                    for (Parameter param : operation.getParameters()) {
                        boolean clash = "path".equals(param.getIn()) && entry.getKey().equals(param.getName());
                        if (clash) continue;
                        nestedParameters.put(entry.getKey(), entry.getValue());
                    }
                }
            } else {
                nestedParameters.putAll(this.parameters);
            }
        }
        if (!nestedParameters.isEmpty()) {
            parameters.put("parameters", nestedParameters);
        }
        return parameters;
    }

    String determineHost(OpenAPI openApi, Operation operation) {
        CamelContext camelContext;
        RestConfiguration globalRestConfiguration;
        String globalConfigurationHost;
        if (ObjectHelper.isNotEmpty((String)this.host)) {
            return this.host;
        }
        String componentHost = this.getComponent().getHost();
        if (ObjectHelper.isNotEmpty((String)componentHost)) {
            return componentHost;
        }
        URI absoluteURI = null;
        URI relativeURI = null;
        Set<URI> operationURIs = this.getURIs(operation.getServers());
        Optional<URI> opURI = operationURIs.stream().filter(URI::isAbsolute).findFirst();
        if (opURI.isEmpty()) {
            Set<URI> apiURIs = this.getURIs(openApi.getServers());
            for (URI uri : apiURIs) {
                if (uri.isAbsolute()) {
                    absoluteURI = uri;
                    continue;
                }
                relativeURI = uri;
            }
            for (URI uri : operationURIs) {
                if (absoluteURI != null) {
                    absoluteURI = absoluteURI.resolve(uri);
                    continue;
                }
                if (relativeURI != null && !relativeURI.equals(uri)) {
                    relativeURI = relativeURI.resolve(uri);
                    continue;
                }
                relativeURI = uri;
            }
        } else {
            absoluteURI = opURI.get();
        }
        if (absoluteURI != null) {
            String scheme = absoluteURI.getScheme();
            String host = absoluteURI.getHost();
            int port = absoluteURI.getPort();
            if (ObjectHelper.isNotEmpty((String)scheme) && ObjectHelper.isNotEmpty((String)host)) {
                return scheme + "://" + host + (String)(port > 0 ? ":" + port : "");
            }
        }
        if ((globalConfigurationHost = RestOpenApiEndpoint.hostFrom(globalRestConfiguration = CamelContextHelper.getRestConfiguration((CamelContext)(camelContext = this.getCamelContext()), null, (String)this.determineComponentName()))) != null) {
            return globalConfigurationHost;
        }
        try {
            URI uri = new URI(this.specificationUri);
            String specificationScheme = uri.getScheme();
            String prefix = "http";
            if (uri.isAbsolute() && specificationScheme.regionMatches(true, 0, prefix, 0, prefix.length())) {
                return new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), null, null, null).toString();
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to create a new URI from: " + this.specificationUri, e);
        }
        throw new IllegalStateException("Unable to determine destination host for requests. The OpenApi specification does not specify `scheme` and `host` parameters, the specification URI is not absolute with `http` or `https` scheme, and no RestConfigurations configured with `scheme`, `host` and `port` were found for `" + (this.determineComponentName() != null ? this.determineComponentName() : "default` component") + " and there is no global RestConfiguration with those properties");
    }

    private Set<URI> getURIs(List<Server> servers) {
        HashSet<URI> uris = new HashSet<URI>();
        if (servers != null) {
            for (Server server : servers) {
                try {
                    uris.add(new URI(RestOpenApiHelper.parseVariables(server.getUrl(), server)));
                }
                catch (URISyntaxException uRISyntaxException) {}
            }
        }
        return uris;
    }

    String literalPathParameterValue(Parameter parameter) {
        String name = parameter.getName();
        String valueStr = String.valueOf(this.parameters.get(name));
        return UnsafeUriCharactersEncoder.encode((String)valueStr);
    }

    String literalQueryParameterValue(Parameter parameter) {
        String name = parameter.getName();
        String valueStr = String.valueOf(this.parameters.get(name));
        String encoded = UnsafeUriCharactersEncoder.encode((String)valueStr);
        return name + "=" + encoded;
    }

    String queryParameter(Parameter parameter) {
        String name = parameter.getName();
        if (ObjectHelper.isEmpty((String)name)) {
            return "";
        }
        if (this.parameters.containsKey(name)) {
            return this.literalQueryParameterValue(parameter);
        }
        return RestOpenApiEndpoint.queryParameterExpression(parameter);
    }

    String resolveUri(String uriTemplate, Map<String, Parameter> pathParameters) {
        if (pathParameters.isEmpty()) {
            return uriTemplate;
        }
        int start = uriTemplate.indexOf(123);
        if (start == -1) {
            return uriTemplate;
        }
        int pos = 0;
        StringBuilder resolved = new StringBuilder(uriTemplate.length() * 2);
        while (start != -1) {
            resolved.append(uriTemplate, pos, start);
            int end = uriTemplate.indexOf(125, start);
            String name = uriTemplate.substring(start + 1, end);
            if (this.parameters.containsKey(name)) {
                Parameter parameter = pathParameters.get(name);
                String value = this.literalPathParameterValue(parameter);
                resolved.append((Object)value);
            } else {
                resolved.append('{').append(name).append('}');
            }
            pos = end + 1;
            start = uriTemplate.indexOf(123, pos);
        }
        if (pos < uriTemplate.length()) {
            resolved.append(uriTemplate, pos, uriTemplate.length());
        }
        return resolved.toString();
    }

    protected RequestValidator configureRequestValidator(OpenAPI openAPI, Operation operation, String method, String uriTemplate) {
        DefaultRequestValidator answer = new DefaultRequestValidator();
        answer.setOperation(new RestOpenApiOperation(operation, method, uriTemplate));
        return answer;
    }

    static String determineOption(List<String> specificationLevel, Set<String> operationLevel, String componentLevel, String endpointLevel) {
        if (ObjectHelper.isNotEmpty((String)endpointLevel)) {
            return endpointLevel;
        }
        if (ObjectHelper.isNotEmpty((String)componentLevel)) {
            return componentLevel;
        }
        if (operationLevel != null && !operationLevel.isEmpty()) {
            return String.join((CharSequence)", ", operationLevel);
        }
        if (specificationLevel != null && !specificationLevel.isEmpty()) {
            return String.join((CharSequence)", ", specificationLevel);
        }
        return null;
    }

    static Stream<Parameter> determineQueryParameters(OpenAPI openApi, Operation operation) {
        List securityRequirements = operation.getSecurity();
        ArrayList<Parameter> securityQueryParameters = new ArrayList<Parameter>();
        if (securityRequirements != null) {
            Map securityDefinitions = openApi.getComponents().getSecuritySchemes();
            for (Map securityRequirement : securityRequirements) {
                for (String securityRequirementName : securityRequirement.keySet()) {
                    SecurityScheme securitySchemeDefinition = (SecurityScheme)securityDefinitions.get(securityRequirementName);
                    if (!SecurityScheme.In.QUERY.equals((Object)securitySchemeDefinition.getIn())) continue;
                    securityQueryParameters.add(new Parameter().name(securitySchemeDefinition.getName()).required(Boolean.valueOf(true)).description(securitySchemeDefinition.getDescription()));
                }
            }
        }
        if (operation.getParameters() != null) {
            return Stream.concat(securityQueryParameters.stream(), operation.getParameters().stream().filter(p -> "query".equals(p.getIn())));
        }
        return securityQueryParameters.stream();
    }

    static String hostFrom(RestConfiguration restConfiguration) {
        if (restConfiguration == null) {
            return null;
        }
        String scheme = restConfiguration.getScheme();
        String host = restConfiguration.getHost();
        int port = restConfiguration.getPort();
        if (scheme == null || host == null) {
            return null;
        }
        StringBuilder answer = new StringBuilder(scheme).append("://").append(host);
        if (!(port <= 0 || "http".equalsIgnoreCase(scheme) && port == 80 || "https".equalsIgnoreCase(scheme) && port == 443)) {
            answer.append(':').append(port);
        }
        return answer.toString();
    }

    static OpenAPI loadSpecificationFrom(CamelContext camelContext, String uri) {
        InputStream is;
        block10: {
            OpenAPI openAPI;
            OpenAPIV3Parser openApiParser = new OpenAPIV3Parser();
            ParseOptions options = new ParseOptions();
            options.setResolveFully(true);
            is = null;
            try {
                String location = null;
                String content = null;
                Resource resource = ResourceHelper.resolveMandatoryResource((CamelContext)camelContext, (String)uri);
                if (resource.getScheme().startsWith("http")) {
                    location = resource.getURI().toString();
                } else {
                    is = resource.getInputStream();
                    if (is != null) {
                        content = IOHelper.loadText((InputStream)is);
                    }
                }
                SwaggerParseResult openApi = null;
                if (location != null) {
                    openApi = openApiParser.readLocation(location, null, options);
                } else if (content != null) {
                    openApi = openApiParser.readContents(content, null, options);
                }
                if (openApi == null || openApi.getOpenAPI() == null) break block10;
                openAPI = openApi.getOpenAPI();
            }
            catch (Exception e) {
                try {
                    throw new IllegalArgumentException("The given OpenApi specification cannot be loaded from: " + uri, e);
                }
                catch (Throwable throwable) {
                    IOHelper.close(is);
                    throw throwable;
                }
            }
            IOHelper.close((Closeable)is);
            return openAPI;
        }
        IOHelper.close((Closeable)is);
        throw new IllegalArgumentException("The given OpenApi specification cannot be loaded from: " + uri);
    }

    static String pickBestScheme(String specificationScheme, List<String> schemes) {
        if (schemes != null && !schemes.isEmpty()) {
            if (schemes.contains("https")) {
                return "https";
            }
            if (schemes.contains("http")) {
                return "http";
            }
        }
        return specificationScheme;
    }

    static String queryParameterExpression(Parameter parameter) {
        String name = parameter.getName();
        StringBuilder expression = new StringBuilder(name).append("={").append(name);
        if (parameter.getRequired() == null || !parameter.getRequired().booleanValue()) {
            expression.append('?');
        }
        expression.append('}');
        return expression.toString();
    }
}

