/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rest.openapi;

import com.atlassian.oai.validator.OpenApiInteractionValidator;
import com.atlassian.oai.validator.report.LevelResolver;
import com.atlassian.oai.validator.report.ValidationReport;
import io.swagger.parser.OpenAPIParser;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.security.SecurityScheme;
import io.swagger.v3.oas.models.servers.Server;
import io.swagger.v3.oas.models.servers.ServerVariable;
import io.swagger.v3.parser.core.models.ParseOptions;
import io.swagger.v3.parser.core.models.SwaggerParseResult;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.camel.CamelContext;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.rest.openapi.RestOpenApiComponent;
import org.apache.camel.component.rest.openapi.RestOpenApiHelper;
import org.apache.camel.component.rest.openapi.RestOpenApiProducer;
import org.apache.camel.component.rest.openapi.validator.DefaultRequestValidationCustomizer;
import org.apache.camel.component.rest.openapi.validator.RequestValidationCustomizer;
import org.apache.camel.component.rest.openapi.validator.RequestValidator;
import org.apache.camel.component.rest.openapi.validator.RestOpenApiOperation;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.Resource;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.support.ResourceHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.UnsafeUriCharactersEncoder;
import org.apache.commons.io.FileUtils;
import org.slf4j.LoggerFactory;

@UriEndpoint(firstVersion="3.1.0", scheme="rest-openapi", title="REST OpenApi", syntax="rest-openapi:specificationUri#operationId", category={Category.REST, Category.API}, producerOnly=true)
public final class RestOpenApiEndpoint
extends DefaultEndpoint {
    Map<String, Object> parameters = Collections.emptyMap();
    @UriParam(description="API basePath, for example \"`/v2`\". Default is unset, if set overrides the value present in OpenApi specification and in the component configuration.", defaultValue="", label="producer")
    private String basePath;
    @UriParam(description="Name of the Camel component that will perform the requests. The component must be present in Camel registry and it must implement RestProducerFactory service provider interface. If not set CLASSPATH is searched for single component that implements RestProducerFactory SPI. Overrides component configuration.", label="producer")
    private String componentName;
    @UriParam(description="What payload type this component capable of consuming. Could be one type, like `application/json` or multiple types as `application/json, application/xml; q=0.5` according to the RFC7231. This equates to the value of `Accept` HTTP header. If set overrides any value found in the OpenApi specification and. in the component configuration", label="producer")
    private String consumes;
    @UriParam(description="Scheme hostname and port to direct the HTTP requests to in the form of `http[s]://hostname[:port]`. Can be configured at the endpoint, component or in the corresponding REST configuration in the Camel Context. If you give this component a name (e.g. `petstore`) that REST configuration is consulted first, `rest-openapi` next, and global configuration last. If set overrides any value found in the OpenApi specification, RestConfiguration. Overrides all other  configuration.", label="producer")
    private String host;
    @UriPath(description="ID of the operation from the OpenApi specification.", label="producer")
    @Metadata(required=true)
    private String operationId;
    @UriParam(description="What payload type this component is producing. For example `application/json` according to the RFC7231. This equates to the value of `Content-Type` HTTP header. If set overrides any value present in the OpenApi specification. Overrides all other configuration.", label="producer")
    private String produces;
    @UriPath(description="Path to the OpenApi specification file. The scheme, host base path are taken from this specification, but these can be overridden with properties on the component or endpoint level. If not given the component tries to load `openapi.json` resource from the classpath. Note that the `host` defined on the component and endpoint of this Component should contain the scheme, hostname and optionally the port in the URI syntax (i.e. `http://api.example.com:8080`). Overrides component configuration. The OpenApi specification can be loaded from different sources by prefixing with file: classpath: http: https:. Support for https is limited to using the JDK installed UrlHandler, and as such it can be cumbersome to setup TLS/SSL certificates for https (such as setting a number of javax.net.ssl JVM system properties). How to do that consult the JDK documentation for UrlHandler.", defaultValue="openapi.json", defaultValueNote="By default loads `openapi.json` file", label="producer")
    private URI specificationUri = RestOpenApiComponent.DEFAULT_SPECIFICATION_URI;
    @UriParam(description="Enable validation of requests against the configured OpenAPI specification", defaultValue="false")
    private boolean requestValidationEnabled;
    @UriParam(description="If request validation is enabled, this option provides the capability to customize the creation of OpenApiInteractionValidator used to validate requests.", defaultValue="org.apache.camel.component.rest.openapi.validator.DefaultRequestValidationCustomizer")
    private RequestValidationCustomizer requestValidationCustomizer;
    @UriParam(description="Levels for specific OpenAPI request validation options. Multiple options can be specified as URI options prefixed by 'validation.'. For example, validation.request.body=ERROR&validation.request.body.unexpected=IGNORED. Supported values are INFO, ERROR, WARN & IGNORE.", prefix="validation.", multiValue=true)
    private Map<String, Object> requestValidationLevels = new HashMap<String, Object>();

    public RestOpenApiEndpoint() {
    }

    public RestOpenApiEndpoint(String uri, String remaining, RestOpenApiComponent component, Map<String, Object> parameters) {
        super(StringHelper.notEmpty((String)uri, (String)"uri"), (Component)ObjectHelper.notNull((Object)((Object)component), (String)"component"));
        this.parameters = parameters;
        this.specificationUri = StringHelper.before((String)remaining, (String)"#", StringHelper::trimToNull).map(URI::create).orElse(Optional.ofNullable(component.getSpecificationUri()).orElse(RestOpenApiComponent.DEFAULT_SPECIFICATION_URI));
        this.operationId = Optional.ofNullable(StringHelper.after((String)remaining, (String)"#")).orElse(remaining);
        this.setExchangePattern(ExchangePattern.InOut);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("Consumer not supported");
    }

    public Producer createProducer() throws Exception {
        CamelContext camelContext = this.getCamelContext();
        OpenAPI openapiDoc = RestOpenApiEndpoint.loadSpecificationFrom(camelContext, this.specificationUri);
        Paths paths = openapiDoc.getPaths();
        for (Map.Entry pathEntry : paths.entrySet()) {
            PathItem path = (PathItem)pathEntry.getValue();
            Map operationMap = path.readOperationsMap();
            Optional<Map.Entry> maybeOperationEntry = operationMap.entrySet().stream().filter(operationEntry -> this.operationId.equals(((Operation)operationEntry.getValue()).getOperationId())).findAny();
            if (!maybeOperationEntry.isPresent()) continue;
            Map.Entry operationEntry2 = maybeOperationEntry.get();
            Operation operation = (Operation)operationEntry2.getValue();
            Map<String, Object> pathParameters = operation.getParameters() != null ? operation.getParameters().stream().filter(p -> "path".equals(p.getIn())).collect(Collectors.toMap(Parameter::getName, Function.identity())) : new HashMap<String, Parameter>();
            String uriTemplate = this.resolveUri((String)pathEntry.getKey(), pathParameters);
            PathItem.HttpMethod httpMethod = (PathItem.HttpMethod)operationEntry2.getKey();
            String method = httpMethod.name();
            return this.createProducerFor(openapiDoc, operation, method, uriTemplate);
        }
        String supportedOperations = paths.values().stream().flatMap(p -> p.readOperations().stream()).map(Operation::getOperationId).collect(Collectors.joining(", "));
        throw new IllegalArgumentException("The specified operation with ID: `" + this.operationId + "` cannot be found in the OpenApi specification loaded from `" + this.specificationUri + "`. Operations defined in the specification are: " + supportedOperations);
    }

    public String getBasePath() {
        return this.basePath;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public String getConsumes() {
        return this.consumes;
    }

    public String getHost() {
        return this.host;
    }

    public String getOperationId() {
        return this.operationId;
    }

    public String getProduces() {
        return this.produces;
    }

    public URI getSpecificationUri() {
        return this.specificationUri;
    }

    public boolean isLenientProperties() {
        return true;
    }

    public void setBasePath(String basePath) {
        this.basePath = StringHelper.notEmpty((String)basePath, (String)"basePath");
    }

    public void setComponentName(String componentName) {
        this.componentName = StringHelper.notEmpty((String)componentName, (String)"componentName");
    }

    public void setConsumes(String consumes) {
        this.consumes = RestOpenApiHelper.isMediaRange(consumes, "consumes");
    }

    public void setHost(String host) {
        this.host = RestOpenApiHelper.isHostParam(host);
    }

    public void setOperationId(String operationId) {
        this.operationId = StringHelper.notEmpty((String)operationId, (String)"operationId");
    }

    public void setProduces(String produces) {
        this.produces = RestOpenApiHelper.isMediaRange(produces, "produces");
    }

    public void setSpecificationUri(URI specificationUri) {
        this.specificationUri = (URI)ObjectHelper.notNull((Object)specificationUri, (String)"specificationUri");
    }

    public void setRequestValidationCustomizer(RequestValidationCustomizer requestValidationCustomizer) {
        this.requestValidationCustomizer = requestValidationCustomizer;
    }

    public RequestValidationCustomizer getRequestValidationCustomizer() {
        return this.requestValidationCustomizer;
    }

    public void setRequestValidationEnabled(boolean requestValidationEnabled) {
        this.requestValidationEnabled = requestValidationEnabled;
    }

    public boolean isRequestValidationEnabled() {
        return this.requestValidationEnabled;
    }

    public void setRequestValidationLevels(Map<String, Object> requestValidationLevels) {
        this.requestValidationLevels = requestValidationLevels;
    }

    public Map<String, Object> getRequestValidationLevels() {
        return this.requestValidationLevels;
    }

    RestOpenApiComponent component() {
        return (RestOpenApiComponent)this.getComponent();
    }

    Producer createProducerFor(OpenAPI openapi, Operation operation, String method, String uriTemplate) throws Exception {
        CamelContext camelContext = this.getCamelContext();
        Map<String, Object> params = this.determineEndpointParameters(openapi, operation);
        boolean hasHost = params.containsKey("host");
        String basePath = this.determineBasePath(openapi);
        String componentEndpointUri = "rest:" + method + ":" + basePath + ":" + uriTemplate;
        if (hasHost) {
            componentEndpointUri = componentEndpointUri + "?host=" + params.get("host");
        }
        Endpoint endpoint = camelContext.getEndpoint(componentEndpointUri);
        endpoint.configureProperties(params);
        RestOpenApiComponent component = this.component();
        RequestValidator requestValidator = null;
        if (component.isRequestValidationEnabled() || this.requestValidationEnabled) {
            requestValidator = this.configureRequestValidator(openapi, operation, method, uriTemplate);
        }
        return new RestOpenApiProducer(endpoint.createProducer(), hasHost, requestValidator);
    }

    String determineBasePath(OpenAPI openapi) {
        if (ObjectHelper.isNotEmpty((String)this.basePath)) {
            return this.basePath;
        }
        String componentBasePath = this.component().getBasePath();
        if (ObjectHelper.isNotEmpty((String)componentBasePath)) {
            return componentBasePath;
        }
        String specificationBasePath = RestOpenApiEndpoint.getBasePathFromOpenApi(openapi);
        if (ObjectHelper.isNotEmpty((String)specificationBasePath)) {
            return specificationBasePath;
        }
        CamelContext camelContext = this.getCamelContext();
        RestConfiguration restConfiguration = CamelContextHelper.getRestConfiguration((CamelContext)camelContext, null, (String)this.determineComponentName());
        String restConfigurationBasePath = restConfiguration.getContextPath();
        if (ObjectHelper.isNotEmpty((String)restConfigurationBasePath)) {
            return restConfigurationBasePath;
        }
        return "/";
    }

    public static String getBasePathFromOpenApi(OpenAPI openApi) {
        String basePath = null;
        if (openApi.getServers() != null) {
            for (Server server : openApi.getServers()) {
                if (server.getUrl() == null) continue;
                try {
                    URI serverUrl = new URI(RestOpenApiEndpoint.parseVariables(server.getUrl(), server));
                    basePath = serverUrl.getPath();
                    if (basePath.indexOf("//") == 0) {
                        basePath = basePath.substring(1);
                    }
                    if (!"/".equals(basePath)) continue;
                    basePath = "";
                }
                catch (URISyntaxException e) {
                    basePath = server.getUrl();
                }
            }
        }
        return basePath;
    }

    public static String parseVariables(String url, Server server) {
        Pattern p = Pattern.compile("\\{(.*?)\\}");
        Matcher m = p.matcher(url);
        while (m.find()) {
            String variable = m.group(1);
            if (server == null || server.getVariables() == null || server.getVariables().get((Object)variable) == null) continue;
            String varValue = ((ServerVariable)server.getVariables().get((Object)variable)).getDefault();
            url = url.replace("{" + variable + "}", varValue);
        }
        return url;
    }

    String determineComponentName() {
        return Optional.ofNullable(this.componentName).orElse(this.component().getComponentName());
    }

    Map<String, Object> determineEndpointParameters(OpenAPI openapi, Operation operation) {
        String queryParameters;
        String determinedProducers;
        String determinedConsumes;
        String host;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        String componentName = this.determineComponentName();
        if (componentName != null) {
            parameters.put("producerComponentName", componentName);
        }
        if ((host = this.determineHost(openapi, operation)) != null) {
            parameters.put("host", host);
        }
        RestOpenApiComponent component = this.component();
        ArrayList<String> specificationLevelConsumers = new ArrayList<String>();
        HashSet<String> operationLevelConsumers = new HashSet<String>();
        if (operation.getResponses() != null) {
            for (ApiResponse response : operation.getResponses().values()) {
                if (response.getContent() == null) continue;
                operationLevelConsumers.addAll(response.getContent().keySet());
            }
        }
        if (ObjectHelper.isNotEmpty((String)(determinedConsumes = RestOpenApiEndpoint.determineOption(specificationLevelConsumers, operationLevelConsumers, component.getConsumes(), this.consumes)))) {
            parameters.put("consumes", determinedConsumes);
        }
        ArrayList<String> specificationLevelProducers = new ArrayList<String>();
        HashSet<String> operationLevelProducers = new HashSet<String>();
        if (operation.getRequestBody() != null && operation.getRequestBody().getContent() != null) {
            operationLevelProducers.addAll(operation.getRequestBody().getContent().keySet());
        }
        if (ObjectHelper.isNotEmpty((String)(determinedProducers = RestOpenApiEndpoint.determineOption(specificationLevelProducers, operationLevelProducers, component.getProduces(), this.produces)))) {
            parameters.put("produces", determinedProducers);
        }
        if (ObjectHelper.isNotEmpty((String)(queryParameters = RestOpenApiEndpoint.determineQueryParameters(openapi, operation).map(this::queryParameter).collect(Collectors.joining("&"))))) {
            parameters.put("queryParameters", queryParameters);
        }
        HashMap<String, Boolean> componentParameters = new HashMap<String, Boolean>();
        if (component.isUseGlobalSslContextParameters()) {
            componentParameters.put("useGlobalSslContextParameters", component.isUseGlobalSslContextParameters());
        }
        if (component.getSslContextParameters() != null) {
            componentParameters.put("sslContextParameters", (Boolean)component.getSslContextParameters());
        }
        HashMap<String, Object> nestedParameters = new HashMap<String, Object>();
        if (!componentParameters.isEmpty()) {
            nestedParameters.put("component", componentParameters);
        }
        if (this.parameters != null) {
            if (operation.getParameters() != null) {
                for (Map.Entry<String, Object> entry : this.parameters.entrySet()) {
                    for (Parameter param : operation.getParameters()) {
                        boolean clash = "path".equals(param.getIn()) && entry.getKey().equals(param.getName());
                        if (clash) continue;
                        nestedParameters.put(entry.getKey(), entry.getValue());
                    }
                }
            } else {
                nestedParameters.putAll(this.parameters);
            }
        }
        if (!nestedParameters.isEmpty()) {
            parameters.put("parameters", nestedParameters);
        }
        return parameters;
    }

    String determineHost(OpenAPI openApi, Operation operation) {
        if (ObjectHelper.isNotEmpty((String)this.host)) {
            return this.host;
        }
        String componentHost = this.component().getHost();
        if (ObjectHelper.isNotEmpty((String)componentHost)) {
            return componentHost;
        }
        URI absoluteURI = null;
        URI relativeURI = null;
        Set<URI> operationURIs = this.getURIs(operation.getServers());
        Optional<URI> opURI = operationURIs.stream().filter(uri -> uri.isAbsolute()).findFirst();
        if (opURI.isEmpty()) {
            Set<URI> apiURIs = this.getURIs(openApi.getServers());
            for (URI uri2 : apiURIs) {
                if (uri2.isAbsolute()) {
                    absoluteURI = uri2;
                    continue;
                }
                relativeURI = uri2;
            }
            for (URI uri2 : operationURIs) {
                if (absoluteURI != null) {
                    absoluteURI = absoluteURI.resolve(uri2);
                    continue;
                }
                if (relativeURI != null && !relativeURI.equals(uri2)) {
                    relativeURI = relativeURI.resolve(uri2);
                    continue;
                }
                relativeURI = uri2;
            }
        } else {
            absoluteURI = opURI.get();
        }
        if (absoluteURI != null) {
            return absoluteURI.toString();
        }
        CamelContext camelContext = this.getCamelContext();
        RestConfiguration globalRestConfiguration = CamelContextHelper.getRestConfiguration((CamelContext)camelContext, null, (String)this.determineComponentName());
        String globalConfigurationHost = RestOpenApiEndpoint.hostFrom(globalRestConfiguration);
        if (globalConfigurationHost != null) {
            return globalConfigurationHost;
        }
        String specificationScheme = this.specificationUri.getScheme();
        String prefix = "http";
        if (this.specificationUri.isAbsolute() && specificationScheme.regionMatches(true, 0, prefix, 0, prefix.length())) {
            try {
                return new URI(this.specificationUri.getScheme(), this.specificationUri.getUserInfo(), this.specificationUri.getHost(), this.specificationUri.getPort(), null, null, null).toString();
            }
            catch (URISyntaxException e) {
                throw new IllegalStateException("Unable to create a new URI from: " + this.specificationUri, e);
            }
        }
        throw new IllegalStateException("Unable to determine destination host for requests. The OpenApi specification does not specify `scheme` and `host` parameters, the specification URI is not absolute with `http` or `https` scheme, and no RestConfigurations configured with `scheme`, `host` and `port` were found for `" + (this.determineComponentName() != null ? this.determineComponentName() : "default` component") + " and there is no global RestConfiguration with those properties");
    }

    private Set<URI> getURIs(List<Server> servers) {
        HashSet<URI> uris = new HashSet<URI>();
        if (servers != null) {
            for (Server server : servers) {
                try {
                    uris.add(new URI(RestOpenApiEndpoint.parseVariables(server.getUrl(), server)));
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
            }
        }
        return uris;
    }

    String literalPathParameterValue(Parameter parameter) {
        String name = parameter.getName();
        String valueStr = String.valueOf(this.parameters.get(name));
        return UnsafeUriCharactersEncoder.encode((String)valueStr);
    }

    String literalQueryParameterValue(Parameter parameter) {
        String name = parameter.getName();
        String valueStr = String.valueOf(this.parameters.get(name));
        String encoded = UnsafeUriCharactersEncoder.encode((String)valueStr);
        return name + "=" + encoded;
    }

    String queryParameter(Parameter parameter) {
        String name = parameter.getName();
        if (ObjectHelper.isEmpty((String)name)) {
            return "";
        }
        if (this.parameters.containsKey(name)) {
            return this.literalQueryParameterValue(parameter);
        }
        return RestOpenApiEndpoint.queryParameterExpression(parameter);
    }

    String resolveUri(String uriTemplate, Map<String, Parameter> pathParameters) {
        if (pathParameters.isEmpty()) {
            return uriTemplate;
        }
        int start = uriTemplate.indexOf(123);
        if (start == -1) {
            return uriTemplate;
        }
        int pos = 0;
        StringBuilder resolved = new StringBuilder(uriTemplate.length() * 2);
        while (start != -1) {
            resolved.append(uriTemplate, pos, start);
            int end = uriTemplate.indexOf(125, start);
            String name = uriTemplate.substring(start + 1, end);
            if (this.parameters.containsKey(name)) {
                Parameter parameter = pathParameters.get(name);
                String value = this.literalPathParameterValue(parameter);
                resolved.append((Object)value);
            } else {
                resolved.append('{').append(name).append('}');
            }
            pos = end + 1;
            start = uriTemplate.indexOf(123, pos);
        }
        if (pos < uriTemplate.length()) {
            resolved.append(uriTemplate, pos, uriTemplate.length());
        }
        return resolved.toString();
    }

    RequestValidator configureRequestValidator(OpenAPI openapi, Operation operation, String method, String uriTemplate) {
        RestOpenApiComponent component = this.component();
        RequestValidationCustomizer validationCustomizer = this.requestValidationCustomizer;
        if (validationCustomizer == null) {
            validationCustomizer = component.getRequestValidationCustomizer();
        }
        if (validationCustomizer == null) {
            validationCustomizer = new DefaultRequestValidationCustomizer();
        }
        RestOpenApiOperation restOpenApiOperation = new RestOpenApiOperation(operation, method, uriTemplate);
        OpenApiInteractionValidator.Builder builder = OpenApiInteractionValidator.createFor((OpenAPI)openapi);
        LevelResolver.Builder levelResolverBuilder = LevelResolver.create();
        levelResolverBuilder.withDefaultLevel(ValidationReport.Level.IGNORE).withLevel("validation.request.body", ValidationReport.Level.ERROR).withLevel("validation.request.contentType.notAllowed", ValidationReport.Level.ERROR).withLevel("validation.request.path.missing", ValidationReport.Level.ERROR).withLevel("validation.request.parameter.header.missing", ValidationReport.Level.ERROR).withLevel("validation.request.parameter.query.missing", ValidationReport.Level.ERROR);
        this.requestValidationLevels.forEach((key, level) -> levelResolverBuilder.withLevel("validation." + key, ValidationReport.Level.valueOf((String)level.toString().toUpperCase())));
        builder.withLevelResolver(levelResolverBuilder.build());
        validationCustomizer.customizeOpenApiInteractionValidator(builder);
        return new RequestValidator(builder.build(), restOpenApiOperation, validationCustomizer);
    }

    static String determineOption(List<String> specificationLevel, Set<String> operationLevel, String componentLevel, String endpointLevel) {
        if (ObjectHelper.isNotEmpty((String)endpointLevel)) {
            return endpointLevel;
        }
        if (ObjectHelper.isNotEmpty((String)componentLevel)) {
            return componentLevel;
        }
        if (operationLevel != null && !operationLevel.isEmpty()) {
            return String.join((CharSequence)", ", operationLevel);
        }
        if (specificationLevel != null && !specificationLevel.isEmpty()) {
            return String.join((CharSequence)", ", specificationLevel);
        }
        return null;
    }

    static Stream<Parameter> determineQueryParameters(OpenAPI openApi, Operation operation) {
        List securityRequirements = operation.getSecurity();
        ArrayList<Parameter> securityQueryParameters = new ArrayList<Parameter>();
        if (securityRequirements != null) {
            Map securityDefinitions = openApi.getComponents().getSecuritySchemes();
            for (Map securityRequirement : securityRequirements) {
                for (String securityRequirementName : securityRequirement.keySet()) {
                    SecurityScheme securitySchemeDefinition = (SecurityScheme)securityDefinitions.get(securityRequirementName);
                    if (!SecurityScheme.In.QUERY.equals((Object)securitySchemeDefinition.getIn())) continue;
                    securityQueryParameters.add(new Parameter().name(securitySchemeDefinition.getName()).required(Boolean.valueOf(true)).description(securitySchemeDefinition.getDescription()));
                }
            }
        }
        if (operation.getParameters() != null) {
            return Stream.concat(securityQueryParameters.stream(), operation.getParameters().stream().filter(p -> "query".equals(p.getIn())));
        }
        return securityQueryParameters.stream();
    }

    static String hostFrom(RestConfiguration restConfiguration) {
        if (restConfiguration == null) {
            return null;
        }
        String scheme = restConfiguration.getScheme();
        String host = restConfiguration.getHost();
        int port = restConfiguration.getPort();
        if (scheme == null || host == null) {
            return null;
        }
        StringBuilder answer = new StringBuilder(scheme).append("://").append(host);
        if (!(port <= 0 || "http".equalsIgnoreCase(scheme) && port == 80 || "https".equalsIgnoreCase(scheme) && port == 443)) {
            answer.append(':').append(port);
        }
        return answer.toString();
    }

    static OpenAPI loadSpecificationFrom(CamelContext camelContext, URI uri) {
        String uriAsString = uri.toString();
        OpenAPIParser openApiParser = new OpenAPIParser();
        ParseOptions options = new ParseOptions();
        options.setResolveFully(true);
        File tmpFileToDelete = null;
        try {
            String locationToSearch;
            Resource resource = ResourceHelper.resolveMandatoryResource((CamelContext)camelContext, (String)uriAsString);
            if ("bean:".equals(ResourceHelper.getScheme((String)uriAsString))) {
                Path tmpFile = Files.createTempFile(null, null, new FileAttribute[0]);
                tmpFileToDelete = tmpFile.toFile();
                tmpFileToDelete.deleteOnExit();
                FileUtils.copyInputStreamToFile((InputStream)resource.getInputStream(), (File)tmpFileToDelete);
                locationToSearch = tmpFile.toUri().toString();
            } else {
                locationToSearch = resource.getURI().toString();
            }
            SwaggerParseResult openApi = openApiParser.readLocation(locationToSearch, null, options);
            if (openApi != null && openApi.getOpenAPI() != null) {
                RestOpenApiEndpoint.checkV2specification(openApi.getOpenAPI(), uri);
                OpenAPI openAPI = openApi.getOpenAPI();
                return openAPI;
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("The given OpenApi specification could not be loaded from `" + uri + "`.", e);
        }
        finally {
            if (tmpFileToDelete != null) {
                tmpFileToDelete.delete();
            }
        }
        throw new IllegalArgumentException("The given OpenApi specification could not be loaded from `" + uri + "`.");
    }

    private static void checkV2specification(OpenAPI openAPI, URI uri) {
        Object swaggerVersion;
        if (openAPI.getExtensions() != null && (swaggerVersion = openAPI.getExtensions().get("x-original-swagger-version")) != null) {
            LoggerFactory.getLogger(RestOpenApiEndpoint.class).info("The specification {} was upgraded from {} to OpenAPI {}", new Object[]{uri, swaggerVersion, openAPI.getSpecVersion()});
        }
    }

    static String pickBestScheme(String specificationScheme, List<String> schemes) {
        if (schemes != null && !schemes.isEmpty()) {
            if (schemes.contains("https")) {
                return "https";
            }
            if (schemes.contains("http")) {
                return "http";
            }
        }
        return specificationScheme;
    }

    static String queryParameterExpression(Parameter parameter) {
        String name = parameter.getName();
        StringBuilder expression = new StringBuilder(name).append("={").append(name);
        if (parameter.getRequired() == null || !parameter.getRequired().booleanValue()) {
            expression.append('?');
        }
        expression.append('}');
        return expression.toString();
    }
}

