/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rest.openapi.validator;

import com.atlassian.oai.validator.OpenApiInteractionValidator;
import com.atlassian.oai.validator.model.Request;
import com.atlassian.oai.validator.model.SimpleRequest;
import com.atlassian.oai.validator.report.ValidationReport;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.Message;
import org.apache.camel.TypeConverter;
import org.apache.camel.component.rest.openapi.validator.RequestValidationCustomizer;
import org.apache.camel.component.rest.openapi.validator.RestOpenApiOperation;
import org.apache.camel.support.MessageHelper;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.UnsafeUriCharactersEncoder;

public class RequestValidator {
    private static final Pattern REST_PATH_PARAM_PATTERN = Pattern.compile("\\{([^}]+)}");
    private final OpenApiInteractionValidator openApiInteractionValidator;
    private final RestOpenApiOperation restOpenApiOperation;
    private final RequestValidationCustomizer requestValidationCustomizer;

    public RequestValidator(OpenApiInteractionValidator openApiInteractionValidator, RestOpenApiOperation restOpenApiOperation, RequestValidationCustomizer requestValidationCustomizer) {
        this.openApiInteractionValidator = openApiInteractionValidator;
        this.restOpenApiOperation = restOpenApiOperation;
        this.requestValidationCustomizer = requestValidationCustomizer;
    }

    public Set<String> validate(Exchange exchange) {
        Message message = exchange.getMessage();
        String contentType = (String)message.getHeader("Content-Type", String.class);
        String charsetFromExchange = this.getCharsetFromExchange(exchange);
        Charset charset = null;
        if (ObjectHelper.isNotEmpty((String)charsetFromExchange)) {
            charset = Charset.forName(charsetFromExchange);
        }
        SimpleRequest.Builder builder = new SimpleRequest.Builder(this.restOpenApiOperation.getMethod(), this.resolvePathParams(exchange));
        builder.withContentType(contentType);
        Object body = message.getBody();
        if (ObjectHelper.isNotEmpty((Object)body)) {
            if (body instanceof InputStream) {
                builder.withBody((InputStream)body);
            } else if (body instanceof byte[]) {
                builder.withBody((byte[])body);
            } else {
                TypeConverter typeConverter = exchange.getContext().getTypeConverter();
                String stringBody = (String)typeConverter.tryConvertTo(String.class, body);
                builder.withBody(stringBody, charset);
            }
        }
        this.restOpenApiOperation.getQueryParams().stream().filter(parameter -> Objects.nonNull(parameter.getRequired()) && parameter.getRequired() != false).forEach(parameter -> {
            Object header = exchange.getMessage().getHeader(parameter.getName());
            if (ObjectHelper.isNotEmpty((Object)header)) {
                if (header instanceof String) {
                    builder.withQueryParam(parameter.getName(), new String[]{(String)header});
                } else if (header instanceof List) {
                    builder.withQueryParam(parameter.getName(), (List)header);
                }
            }
        });
        this.restOpenApiOperation.getHeaders().stream().filter(parameter -> Objects.nonNull(parameter.getRequired()) && parameter.getRequired() != false).forEach(parameter -> {
            Object header = exchange.getMessage().getHeader(parameter.getName());
            if (ObjectHelper.isNotEmpty((Object)header)) {
                if (header instanceof String) {
                    builder.withHeader(parameter.getName(), new String[]{(String)header});
                } else if (header instanceof List) {
                    builder.withHeader(parameter.getName(), (List)header);
                }
            }
        });
        this.requestValidationCustomizer.customizeSimpleRequestBuilder(builder, this.restOpenApiOperation, exchange);
        LinkedHashSet validationErrors = new LinkedHashSet();
        this.openApiInteractionValidator.validateRequest((Request)builder.build()).getMessages().stream().filter(validationMessage -> validationMessage.getLevel().equals((Object)ValidationReport.Level.ERROR)).map(ValidationReport.Message::getMessage).forEach(validationErrors::add);
        MessageHelper.resetStreamCache((Message)message);
        return Collections.unmodifiableSet(validationErrors);
    }

    protected String resolvePathParams(Exchange exchange) {
        String path = this.restOpenApiOperation.getUriTemplate();
        Matcher matcher = REST_PATH_PARAM_PATTERN.matcher(path);
        String pathToProcess = path;
        while (matcher.find()) {
            String paramName = matcher.group(1);
            String paramValue = (String)exchange.getMessage().getHeader(paramName, String.class);
            if (!ObjectHelper.isNotEmpty((String)paramValue)) continue;
            pathToProcess = pathToProcess.replace("{" + paramName + "}", UnsafeUriCharactersEncoder.encode((String)paramValue));
        }
        return pathToProcess;
    }

    protected String getCharsetFromExchange(Exchange exchange) {
        String contentType;
        String charset = null;
        if (exchange != null && ObjectHelper.isNotEmpty((String)(contentType = (String)exchange.getMessage().getHeader("Content-Type", String.class))) && ObjectHelper.isEmpty((String)(charset = IOHelper.getCharsetNameFromContentType((String)contentType)))) {
            charset = (String)exchange.getProperty(ExchangePropertyKey.CHARSET_NAME, String.class);
        }
        return charset;
    }
}

