/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.resteasy.servlet;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.camel.component.resteasy.servlet.ResteasyServletOutputStreamCopier;

public class ResteasyHttpServletResponseWrapper
extends HttpServletResponseWrapper {
    private ServletOutputStream outputStream;
    private PrintWriter writer;
    private ResteasyServletOutputStreamCopier copier;

    public ResteasyHttpServletResponseWrapper(HttpServletResponse response) throws IOException {
        super(response);
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.writer != null) {
            throw new IllegalStateException("getWriter() has already been called on this response.");
        }
        if (this.outputStream == null) {
            this.outputStream = this.getResponse().getOutputStream();
            this.copier = new ResteasyServletOutputStreamCopier((OutputStream)this.outputStream);
        }
        return this.copier;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.outputStream != null) {
            throw new IllegalStateException("getOutputStream() has already been called on this response.");
        }
        if (this.writer == null) {
            this.copier = new ResteasyServletOutputStreamCopier((OutputStream)this.getResponse().getOutputStream());
            this.writer = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)((Object)this.copier), this.getResponse().getCharacterEncoding()), true);
        }
        return this.writer;
    }

    public void flushBuffer() throws IOException {
        if (this.writer != null) {
            this.writer.flush();
        } else if (this.outputStream != null) {
            this.copier.flush();
        }
    }

    public byte[] getCopy() {
        if (this.copier != null) {
            return this.copier.getCopy();
        }
        return new byte[0];
    }

    public ByteArrayOutputStream getStream() {
        if (this.copier != null) {
            return this.copier.getStream();
        }
        return null;
    }
}

