/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.resteasy;

import java.net.URI;
import org.apache.camel.Category;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.http.HttpComponent;
import org.apache.camel.component.http.HttpEndpoint;
import org.apache.camel.component.resteasy.ResteasyComponent;
import org.apache.camel.component.resteasy.ResteasyConstants;
import org.apache.camel.component.resteasy.ResteasyConsumer;
import org.apache.camel.component.resteasy.ResteasyHeaderFilterStrategy;
import org.apache.camel.component.resteasy.ResteasyProducer;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(firstVersion="3.4.0", scheme="resteasy", extendsScheme="http", title="Resteasy", syntax="resteasy:httpUri", category={Category.REST}, headersClass=ResteasyConstants.class)
@Metadata(excludeProperties="clientConnectionManager,connectionsPerRoute,connectionTimeToLive,httpBinding,httpClientConfigurer,httpConfiguration,httpContext,httpRegistry,maxTotalConnections,connectionRequestTimeout,connectTimeout,socketTimeout,cookieStore,x509HostnameVerifier,sslContextParameters,clientBuilder,httpClient,httpClientOptions,proxyHost,proxyMethod,proxyPort,authDomain,authenticationPreemptive,authHost,authMethod,authMethodPriority,authPassword,authUsername,basicAuth,proxyAuthScheme,proxyAuthMethod,proxyAuthUsername,proxyAuthPassword,proxyAuthHost,proxyAuthPort,proxyAuthDomain,proxyAuthNtHost")
public class ResteasyEndpoint
extends HttpEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(ResteasyEndpoint.class);
    private String protocol;
    private String host;
    private int port;
    private String uriPattern;
    @UriParam(defaultValue="GET")
    private String resteasyMethod = "GET";
    @UriParam
    private String servletName;
    @UriParam(label="proxy")
    private String proxyClientClass;
    @UriParam(label="proxy")
    private String proxyMethod;
    @UriParam(label="advanced")
    private Boolean setHttpResponseDuringProcessing = false;
    @UriParam(label="advanced")
    private Boolean skipServletProcessing = false;
    @UriParam(label="security")
    private Boolean basicAuth = false;
    @UriParam(label="security", secret=true)
    private String username;
    @UriParam(label="security", secret=true)
    private String password;
    @UriParam(label="advanced")
    private HeaderFilterStrategy headerFilterStrategy;

    public ResteasyEndpoint(String endPointURI, ResteasyComponent component, URI httpUri) {
        super(endPointURI, (HttpComponent)component, httpUri, null, null, null);
    }

    public Producer createProducer() throws Exception {
        return new ResteasyProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        ResteasyConsumer answer = new ResteasyConsumer(this, processor);
        this.configureConsumer((Consumer)answer);
        return answer;
    }

    public HeaderFilterStrategy getHeaderFilterStrategy() {
        if (this.headerFilterStrategy == null) {
            this.headerFilterStrategy = new ResteasyHeaderFilterStrategy();
        }
        return this.headerFilterStrategy;
    }

    public void setHeaderFilterStrategy(HeaderFilterStrategy headerFilterStrategy) {
        this.headerFilterStrategy = headerFilterStrategy;
    }

    public String getProxyMethod() {
        return this.proxyMethod;
    }

    public void setProxyMethod(String proxyMethod) {
        this.proxyMethod = proxyMethod;
    }

    public Boolean getSetHttpResponseDuringProcessing() {
        return this.setHttpResponseDuringProcessing;
    }

    public void setSetHttpResponseDuringProcessing(Boolean setHttpResponseDuringProcessing) {
        this.setHttpResponseDuringProcessing = setHttpResponseDuringProcessing;
    }

    public Boolean getSkipServletProcessing() {
        return this.skipServletProcessing;
    }

    public void setSkipServletProcessing(Boolean skipServletProcessing) {
        this.skipServletProcessing = skipServletProcessing;
    }

    public String getProxyClientClass() {
        return this.proxyClientClass;
    }

    public void setProxyClientClass(String proxyClientClass) {
        this.proxyClientClass = proxyClientClass;
    }

    public String getServletName() {
        return this.servletName;
    }

    public void setServletName(String servletName) {
        this.servletName = servletName;
    }

    public String getResteasyMethod() {
        return this.resteasyMethod;
    }

    public void setResteasyMethod(String resteasyMethod) {
        this.resteasyMethod = resteasyMethod;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getUriPattern() {
        return this.uriPattern;
    }

    public void setUriPattern(String uriPattern) {
        this.uriPattern = uriPattern;
    }

    public Boolean getBasicAuth() {
        return this.basicAuth;
    }

    public void setBasicAuth(Boolean basicAuth) {
        this.basicAuth = basicAuth;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    protected String buildUri() {
        String uri = this.port == 0 ? this.protocol + "://" + this.host + this.uriPattern : this.protocol + "://" + this.host + ":" + this.port + this.uriPattern;
        LOG.debug("Using uri: {}", (Object)uri);
        return uri;
    }
}

