/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.resteasy;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class ResteasyEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":httpUri";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;
    private static final Set<String> MULTI_VALUE_PREFIXES;

    public boolean isEnabled(String scheme) {
        return "resteasy".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax = scheme + BASE;
        Object uri = syntax;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, (String)uri, "httpUri", null, true, copy);
        uri = this.buildQueryParameters((String)uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public Set<String> multiValuePrefixes() {
        return MULTI_VALUE_PREFIXES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(42);
        props.add("async");
        props.add("bridgeEndpoint");
        props.add("bridgeErrorHandler");
        props.add("clearExpiredCookies");
        props.add("connectionClose");
        props.add("cookieHandler");
        props.add("copyHeaders");
        props.add("customHostHeader");
        props.add("deleteWithBody");
        props.add("disableStreamCache");
        props.add("eagerCheckContentAvailable");
        props.add("exceptionHandler");
        props.add("exchangePattern");
        props.add("followRedirects");
        props.add("getWithBody");
        props.add("headerFilterStrategy");
        props.add("httpMethod");
        props.add("httpMethodRestrict");
        props.add("httpUri");
        props.add("ignoreResponseBody");
        props.add("lazyStartProducer");
        props.add("mapHttpMessageBody");
        props.add("mapHttpMessageFormUrlEncodedBody");
        props.add("mapHttpMessageHeaders");
        props.add("muteException");
        props.add("okStatusCodeRange");
        props.add("optionsEnabled");
        props.add("password");
        props.add("preserveHostHeader");
        props.add("proxyClientClass");
        props.add("responseBufferSize");
        props.add("resteasyMethod");
        props.add("servletName");
        props.add("setHttpResponseDuringProcessing");
        props.add("skipRequestHeaders");
        props.add("skipResponseHeaders");
        props.add("skipServletProcessing");
        props.add("throwExceptionOnFailure");
        props.add("traceEnabled");
        props.add("useSystemProperties");
        props.add("userAgent");
        props.add("username");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        HashSet<String> secretProps = new HashSet<String>(2);
        secretProps.add("password");
        secretProps.add("username");
        SECRET_PROPERTY_NAMES = Collections.unmodifiableSet(secretProps);
        MULTI_VALUE_PREFIXES = Collections.emptySet();
    }
}

