/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.resteasy;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.resteasy.ResteasyEndpoint;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.support.MessageHelper;
import org.apache.camel.util.ObjectHelper;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;
import org.jboss.resteasy.client.jaxrs.internal.BasicAuthentication;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResteasyProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(ResteasyProducer.class);
    private static final String RESTEASY_METHOD_OPTION = "method";
    private static final String RESTEASY_PROXY_METHOD_NAME_OPTION = "proxyMethodName";
    private static final String RESTEASY_USERNAME_OPTION = "username";
    private static final String RESTEASY_PASSWORD_OPTION = "password";

    public ResteasyProducer(ResteasyEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public void process(Exchange exchange) throws Exception {
        ResteasyEndpoint resteasyEndpoint = (ResteasyEndpoint)((Object)ObjectHelper.cast(ResteasyEndpoint.class, (Object)this.getEndpoint()));
        Map<String, String> parameters = ResteasyProducer.getParameters(exchange, resteasyEndpoint);
        String query = (String)exchange.getIn().getHeader("CamelHttpQuery", String.class);
        String uri = resteasyEndpoint.buildUri();
        if (query != null) {
            LOG.debug("Adding query: {} to uri: {}", (Object)query, (Object)uri);
            uri = this.addQueryToUri(uri, query);
            LOG.debug("URI: {} populated via ResteasyConstants.HTTP_QUERY header", (Object)uri);
        }
        WebTarget resteasyWebTarget = this.createWebClientTarget(uri);
        this.applyAuth(resteasyEndpoint, parameters, resteasyWebTarget);
        if (resteasyEndpoint.getProxyClientClass() != null) {
            if (resteasyEndpoint.getProxyClientClass().isEmpty()) {
                throw new IllegalArgumentException("Uri option proxyClientClass cannot be empty! Full class name must be specified.");
            }
            this.writeResponseByProxy(exchange, resteasyEndpoint, parameters, resteasyWebTarget);
        } else {
            this.writeResponse(exchange, resteasyEndpoint, parameters, resteasyWebTarget);
        }
    }

    protected static Map<String, String> getParameters(Exchange exchange, ResteasyEndpoint endpoint) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        String methodHeader = (String)exchange.getIn().getHeader("CamelResteasyHttpMethod", String.class);
        String method = endpoint.getResteasyMethod();
        if (methodHeader != null && !method.equalsIgnoreCase(methodHeader)) {
            method = methodHeader;
        }
        parameters.put(RESTEASY_METHOD_OPTION, method);
        String proxyMethodNameHeader = (String)exchange.getIn().getHeader("CamelResteasyProxyMethod", String.class);
        String proxyMethodName = endpoint.getProxyMethod();
        if (proxyMethodNameHeader != null && !proxyMethodName.equalsIgnoreCase(proxyMethodNameHeader)) {
            proxyMethodName = proxyMethodNameHeader;
        }
        parameters.put(RESTEASY_PROXY_METHOD_NAME_OPTION, proxyMethodName);
        String usernameHeader = (String)exchange.getIn().getHeader("CamelResteasyLogin", String.class);
        String username = endpoint.getUsername();
        if (usernameHeader != null && !username.equals(usernameHeader)) {
            username = usernameHeader;
        }
        parameters.put(RESTEASY_USERNAME_OPTION, username);
        String passwordHeader = (String)exchange.getIn().getHeader("CamelResteasyPassword", String.class);
        String password = endpoint.getPassword();
        if (passwordHeader != null && !password.equals(passwordHeader)) {
            password = passwordHeader;
        }
        parameters.put(RESTEASY_PASSWORD_OPTION, password);
        return parameters;
    }

    private String addQueryToUri(String uri, String query) {
        if (uri == null || uri.length() == 0) {
            return uri;
        }
        StringBuilder answer = new StringBuilder();
        int index = uri.indexOf(63);
        if (index < 0) {
            answer.append(uri);
            answer.append("?");
            answer.append(query);
        } else {
            answer.append(uri.substring(0, index));
            answer.append("?");
            answer.append(query);
            String remaining = uri.substring(index + 1);
            if (remaining.length() > 0) {
                answer.append("&");
                answer.append(remaining);
            }
        }
        return answer.toString();
    }

    private WebTarget createWebClientTarget(String uri) {
        Client client = ClientBuilder.newBuilder().build();
        return client.target(uri);
    }

    private void applyAuth(ResteasyEndpoint resteasyEndpoint, Map<String, String> parameters, WebTarget resteasyWebTarget) {
        if (resteasyEndpoint.getBasicAuth() != null && Boolean.TRUE.equals(resteasyEndpoint.getBasicAuth()) && parameters.get(RESTEASY_USERNAME_OPTION) != null) {
            resteasyWebTarget.register((Object)new BasicAuthentication(parameters.get(RESTEASY_USERNAME_OPTION), parameters.get(RESTEASY_USERNAME_OPTION)));
            if (LOG.isTraceEnabled()) {
                LOG.trace("Basic authentication was applied");
            }
        }
    }

    private Object createResponseObject(Exchange exchange, ResteasyEndpoint resteasyEndpoint, Map<String, String> parameters, WebTarget resteasyWebTarget) {
        Object object = null;
        try {
            Class<?> realClazz = Class.forName(resteasyEndpoint.getProxyClientClass());
            Object simple = ((ResteasyWebTarget)ObjectHelper.cast(ResteasyWebTarget.class, (Object)resteasyWebTarget)).proxy(realClazz);
            ArrayList headerParams = (ArrayList)exchange.getIn().getHeader("CamelResteasyProxyMethodArgs", ArrayList.class);
            if (headerParams != null) {
                Object[] args = new Object[headerParams.size()];
                Class[] paramsClasses = new Class[headerParams.size()];
                for (int i = 0; i < headerParams.size(); ++i) {
                    paramsClasses[i] = headerParams.get(i).getClass();
                    args[i] = headerParams.get(i);
                }
                Method m = simple.getClass().getMethod(parameters.get(RESTEASY_PROXY_METHOD_NAME_OPTION), paramsClasses);
                object = m.invoke(simple, args);
            } else {
                Method m = simple.getClass().getMethod(parameters.get(RESTEASY_PROXY_METHOD_NAME_OPTION), new Class[0]);
                object = m.invoke(simple, new Object[0]);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            exchange.getMessage().getHeaders().put("CamelResteasyProxyProducerException", e);
            exchange.getMessage().setBody((Object)e);
            LOG.error("Camel Resteasy Proxy Client Exception: {}", (Object)e.getMessage(), (Object)e);
        }
        return object;
    }

    private void writeResponseByProxy(Exchange exchange, ResteasyEndpoint resteasyEndpoint, Map<String, String> parameters, WebTarget resteasyWebTarget) {
        Object object = this.createResponseObject(exchange, resteasyEndpoint, parameters, resteasyWebTarget);
        if (object == null) {
            throw new IllegalArgumentException("Proxy Method parameters failed to create response");
        }
        if (object instanceof Response) {
            Response response = (Response)ObjectHelper.cast(Response.class, (Object)object);
            this.doWriteResponse(exchange, response, resteasyEndpoint.getHeaderFilterStrategy());
            response.close();
        } else {
            exchange.getMessage().setBody(object);
            MessageHelper.copyHeaders((Message)exchange.getIn(), (Message)exchange.getMessage(), (boolean)false);
        }
    }

    private Response createResponse(Exchange exchange, ResteasyEndpoint resteasyEndpoint, Map<String, String> parameters, WebTarget target) {
        String body = (String)exchange.getIn().getBody(String.class);
        LOG.debug("Body in producer: {}", (Object)body);
        String mediaType = (String)exchange.getIn().getHeader("Content-Type", String.class);
        LOG.debug("Populate Resteasy request from exchange body: {} using media type {}", (Object)body, (Object)mediaType);
        Invocation.Builder builder = mediaType != null ? target.request(new String[]{mediaType}) : target.request();
        for (Map.Entry entry : exchange.getIn().getHeaders().entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (resteasyEndpoint.getHeaderFilterStrategy() == null || resteasyEndpoint.getHeaderFilterStrategy().applyFilterToCamelHeaders(key, value, exchange)) continue;
            builder.header(key, value);
            LOG.debug("Populate Resteasy request from exchange header: {} value: {}", (Object)key, value);
        }
        String method = parameters.get(RESTEASY_METHOD_OPTION);
        Response response = null;
        if (method.equals("GET")) {
            response = builder.get();
        }
        if (method.equals("POST")) {
            response = builder.post(Entity.entity((Object)body, (String)mediaType));
        }
        if (method.equals("PUT")) {
            response = builder.put(Entity.entity((Object)body, (String)mediaType));
        }
        if (method.equals("DELETE")) {
            response = builder.delete();
        }
        if (method.equals("OPTIONS")) {
            response = builder.options();
        }
        if (method.equals("TRACE")) {
            response = builder.trace();
        }
        if (method.equals("HEAD")) {
            response = builder.head();
        }
        return response;
    }

    private void writeResponse(Exchange exchange, ResteasyEndpoint resteasyEndpoint, Map<String, String> parameters, WebTarget target) {
        Response response = this.createResponse(exchange, resteasyEndpoint, parameters, target);
        if (response == null) {
            throw new IllegalArgumentException("Method '" + parameters.get(RESTEASY_METHOD_OPTION) + "' is not supported method to create response");
        }
        this.doWriteResponse(exchange, response, resteasyEndpoint.getHeaderFilterStrategy());
        response.close();
    }

    public void doWriteResponse(Exchange exchange, Response response, HeaderFilterStrategy headerFilterStrategy) {
        int responseCode = response.getStatus();
        HashMap<String, Object> headers = new HashMap<String, Object>();
        headers.put("CamelHttpResponseCode", responseCode);
        for (String key : response.getHeaders().keySet()) {
            Object value = response.getHeaders().get((Object)key);
            if (headerFilterStrategy == null || headerFilterStrategy.applyFilterToExternalHeaders(key, value, exchange)) continue;
            headers.put(key, value);
            LOG.debug("Populate Camel exchange from response: {} value: {}", (Object)key, value);
        }
        headers.put("CamelResteasyResponse", response);
        exchange.getMessage().setHeaders(headers);
        LOG.debug("Headers from exchange.getIn() : {}", (Object)exchange.getIn().getHeaders());
        LOG.debug("Headers from exchange.getOut() before copying : {}", (Object)exchange.getMessage().getHeaders());
        LOG.debug("Header from response : {}", (Object)response.getHeaders());
        if (response.hasEntity()) {
            exchange.getMessage().setBody(response.readEntity(String.class));
        } else {
            exchange.getMessage().setBody((Object)response.getStatusInfo());
        }
        MessageHelper.copyHeaders((Message)exchange.getIn(), (Message)exchange.getMessage(), (boolean)false);
    }
}

