/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.restlet;

import java.io.File;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.dom.DOMSource;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.StringSource;
import org.apache.camel.TypeConverter;
import org.apache.camel.WrappedFile;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.restlet.RestletBinding;
import org.apache.camel.component.restlet.RestletHelper;
import org.apache.camel.component.restlet.RestletOnCompletion;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.HeaderFilterStrategyAware;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.MessageHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.URISupport;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.CacheDirective;
import org.restlet.data.ChallengeResponse;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.CharacterSet;
import org.restlet.data.ClientInfo;
import org.restlet.data.Cookie;
import org.restlet.data.Encoding;
import org.restlet.data.Form;
import org.restlet.data.Header;
import org.restlet.data.Language;
import org.restlet.data.MediaType;
import org.restlet.data.Metadata;
import org.restlet.data.Method;
import org.restlet.data.Preference;
import org.restlet.data.Status;
import org.restlet.engine.application.DecodeRepresentation;
import org.restlet.engine.header.HeaderUtils;
import org.restlet.representation.ByteArrayRepresentation;
import org.restlet.representation.EmptyRepresentation;
import org.restlet.representation.FileRepresentation;
import org.restlet.representation.InputRepresentation;
import org.restlet.representation.Representation;
import org.restlet.representation.StreamRepresentation;
import org.restlet.representation.StringRepresentation;
import org.restlet.util.Series;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRestletBinding
implements RestletBinding,
HeaderFilterStrategyAware {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultRestletBinding.class);
    private static final String RFC_2822_DATE_PATTERN = "EEE, dd MMM yyyy HH:mm:ss Z";
    private HeaderFilterStrategy headerFilterStrategy;
    private boolean streamRepresentation;
    private boolean autoCloseStream;

    @Override
    public void populateExchangeFromRestletRequest(Request request, Response response, Exchange exchange) throws Exception {
        Message inMessage = exchange.getIn();
        inMessage.setHeader("CamelRestletRequest", (Object)request);
        inMessage.setHeader("CamelRestletResponse", (Object)response);
        for (Map.Entry entry : request.getAttributes().entrySet()) {
            if (this.headerFilterStrategy.applyFilterToExternalHeaders((String)entry.getKey(), entry.getValue(), exchange)) continue;
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if ("org.restlet.http.headers".equalsIgnoreCase(key)) {
                Series series = (Series)value;
                for (Header header : series) {
                    if (this.headerFilterStrategy.applyFilterToExternalHeaders(header.getName(), (Object)header.getValue(), exchange)) continue;
                    inMessage.setHeader(header.getName(), (Object)header.getValue());
                }
            } else {
                inMessage.setHeader(key, value);
            }
            LOG.debug("Populate exchange from Restlet request header: {} value: {}", (Object)key, value);
        }
        this.populateQueryParameters(request, exchange);
        inMessage.setHeader("CamelHttpUri", (Object)request.getResourceRef().getIdentifier(true));
        inMessage.setHeader("CamelHttpMethod", (Object)request.getMethod().toString());
        if (!request.isEntityAvailable()) {
            return;
        }
        if (request.getEntity().getMediaType() != null && request.getEntity().getMediaType().equals((Object)MediaType.APPLICATION_WWW_FORM, true)) {
            Form form = new Form(request.getEntity());
            for (String paramName : form.getValuesMap().keySet()) {
                String[] values = form.getValuesArray(paramName);
                Object value = null;
                if (values != null && values.length > 0) {
                    value = values.length == 1 ? values[0] : values;
                }
                if (value == null) {
                    inMessage.setBody((Object)paramName);
                    LOG.debug("Populate exchange from Restlet request body: {}", (Object)paramName);
                    continue;
                }
                if (this.headerFilterStrategy.applyFilterToExternalHeaders(paramName, value, exchange)) continue;
                inMessage.setHeader(paramName, value);
                LOG.debug("Populate exchange from Restlet request user header: {} value: {}", (Object)paramName, value);
            }
        } else {
            InputStream is = request.getEntity().getStream();
            Object body = RestletHelper.readResponseBodyFromInputStream(is, exchange);
            inMessage.setBody(body);
        }
    }

    protected void populateQueryParameters(Request request, Exchange exchange) throws Exception {
        String query = request.getResourceRef().getQuery();
        if (query != null) {
            exchange.getIn().setHeader("CamelHttpQuery", (Object)query);
            Map map = URISupport.parseQuery((String)query);
            for (Map.Entry entry : map.entrySet()) {
                if (this.headerFilterStrategy.applyFilterToExternalHeaders((String)entry.getKey(), entry.getValue(), exchange)) continue;
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                LOG.trace("HTTP query parameter {} = {}", (Object)key, value);
                exchange.getIn().setHeader(key, value);
            }
        }
    }

    @Override
    public void populateRestletRequestFromExchange(Request request, Exchange exchange) {
        Series restletHeaders;
        request.setReferrerRef("camel-restlet");
        Method method = request.getMethod();
        MediaType mediaType = (MediaType)exchange.getIn().getHeader("Content-Type", MediaType.class);
        if (mediaType == null) {
            mediaType = MediaType.APPLICATION_WWW_FORM;
        }
        Form form = null;
        if ((Method.PUT == method || Method.POST == method) && MediaType.APPLICATION_WWW_FORM.equals((Object)mediaType, true)) {
            form = new Form();
            if (exchange.getIn().getBody() instanceof Map) {
                try {
                    Map pairs = (Map)exchange.getIn().getBody(Map.class);
                    for (Object key : pairs.keySet()) {
                        Object value = pairs.get(key);
                        form.add(key.toString(), value != null ? value.toString() : null);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeCamelException("body for " + MediaType.APPLICATION_WWW_FORM + " request must be Map<String,String> or string format like name=bob&password=secRet", (Throwable)e);
                }
            } else {
                String body = (String)exchange.getIn().getBody(String.class);
                if (body != null) {
                    Object key;
                    List pairs = URLEncodedUtils.parse((String)body, (Charset)Charset.forName(IOHelper.getCharsetName((Exchange)exchange, (boolean)true)));
                    key = pairs.iterator();
                    while (key.hasNext()) {
                        NameValuePair p = (NameValuePair)key.next();
                        form.add(p.getName(), p.getValue());
                    }
                }
            }
        }
        if ((restletHeaders = (Series)exchange.getIn().getHeader("org.restlet.http.headers", Series.class)) == null) {
            restletHeaders = new Series(Header.class);
            request.getAttributes().put("org.restlet.http.headers", restletHeaders);
        } else {
            for (String name : restletHeaders.getNames()) {
                if (!this.headerFilterStrategy.applyFilterToCamelHeaders(name, (Object)restletHeaders.getValues(name), exchange)) continue;
                restletHeaders.removeAll(name);
            }
            request.getAttributes().put("org.restlet.http.headers", restletHeaders);
            exchange.getIn().removeHeader("org.restlet.http.headers");
        }
        String login = (String)exchange.getIn().getHeader("CamelRestletLogin", String.class);
        String password = (String)exchange.getIn().getHeader("CamelRestletPassword", String.class);
        if (login != null && password != null) {
            ChallengeResponse authentication = new ChallengeResponse(ChallengeScheme.HTTP_BASIC, login, password);
            request.setChallengeResponse(authentication);
            LOG.debug("Basic HTTP Authentication has been applied");
        }
        for (Map.Entry entry : exchange.getIn().getHeaders().entrySet()) {
            Object value;
            String key = (String)entry.getKey();
            if (this.headerFilterStrategy.applyFilterToCamelHeaders(key, value = entry.getValue(), exchange)) continue;
            if (form != null) {
                if (key.startsWith("org.restlet.")) {
                    request.getAttributes().put(key, value);
                } else if (value instanceof Collection) {
                    for (Object v : (Collection)value) {
                        form.add(key, v.toString());
                        if (this.headerFilterStrategy.applyFilterToCamelHeaders(key, value, exchange)) continue;
                        restletHeaders.set(key, value.toString());
                    }
                } else {
                    form.add(key, value.toString());
                    if (!this.headerFilterStrategy.applyFilterToCamelHeaders(key, value, exchange)) {
                        restletHeaders.set(key, value.toString());
                    }
                }
            } else if (!this.headerFilterStrategy.applyFilterToCamelHeaders(key, value, exchange)) {
                restletHeaders.set(key, value.toString());
            }
            LOG.debug("Populate Restlet request from exchange header: {} value: {}", (Object)key, value);
        }
        if (form != null) {
            request.setEntity(form.getWebRepresentation());
            LOG.debug("Populate Restlet {} request from exchange body as form using media type {}", (Object)method, (Object)mediaType);
        } else if (request.getMethod().equals((Object)Method.PUT) || request.getMethod().equals((Object)Method.POST) || request.getMethod().equals((Object)Method.PATCH)) {
            Representation body = this.createRepresentationFromBody(exchange, mediaType);
            request.setEntity(body);
            LOG.debug("Populate Restlet {} request from exchange body: {} using media type {}", new Object[]{method, body, mediaType});
        } else {
            LOG.debug("Populate Restlet {} request from exchange using media type {}", (Object)method, (Object)mediaType);
            request.setEntity((Representation)new EmptyRepresentation());
        }
        Request extensionHeaders = new Request();
        HeaderUtils.copyExtensionHeaders((Series)restletHeaders, (org.restlet.Message)extensionHeaders);
        Series series = new Series(Header.class);
        series.addAll((Collection)restletHeaders);
        series.removeAll((Collection)extensionHeaders.getHeaders());
        restletHeaders.removeAll((Collection)series);
        LOG.debug("Detected {} request extension headers", (Object)extensionHeaders.getHeaders().size());
        LOG.debug("Detected {} request standard headers", (Object)series.size());
        this.configureRestletRequestStandardHeaders(exchange, request, series);
        MediaType[] acceptedMediaTypes = (MediaType[])exchange.getIn().getHeader("CamelAcceptContentType", MediaType[].class);
        if (acceptedMediaTypes != null) {
            ClientInfo clientInfo = request.getClientInfo();
            List acceptedMediaTypesList = clientInfo.getAcceptedMediaTypes();
            for (MediaType acceptedMediaType : acceptedMediaTypes) {
                acceptedMediaTypesList.add(new Preference((Metadata)acceptedMediaType));
            }
        }
    }

    private void configureRestletRequestStandardHeaders(Exchange exchange, Request request, Series standardHeaders) {
        for (Header h : standardHeaders) {
            ClientInfo clientInfo;
            String key = h.getName();
            String value = h.getValue();
            if ("Server".equalsIgnoreCase(key) || "Set-Cookie".equalsIgnoreCase(key) || "Expires".equalsIgnoreCase(key) || "Connection".equalsIgnoreCase(key)) continue;
            if ("Authorization".equalsIgnoreCase(key)) {
                ChallengeResponse c = new ChallengeResponse(new ChallengeScheme("", ""));
                c.setRawValue(value);
                request.setChallengeResponse(c);
                continue;
            }
            if ("Accept".equalsIgnoreCase(key)) {
                MediaType[] acceptedMediaTypes;
                clientInfo = request.getClientInfo();
                List acceptedMediaTypesList = clientInfo.getAcceptedMediaTypes();
                for (MediaType acceptedMediaType : acceptedMediaTypes = (MediaType[])exchange.getContext().getTypeConverter().tryConvertTo(MediaType[].class, exchange, (Object)value)) {
                    acceptedMediaTypesList.add(new Preference((Metadata)acceptedMediaType));
                }
                continue;
            }
            if ("Accept-Encoding".equalsIgnoreCase(key)) {
                clientInfo = request.getClientInfo();
                Encoding encoding = Encoding.valueOf((String)value);
                clientInfo.getAcceptedEncodings().add(new Preference((Metadata)encoding));
                continue;
            }
            if ("Accept-Language".equalsIgnoreCase(key)) {
                clientInfo = request.getClientInfo();
                Language language = Language.valueOf((String)value);
                clientInfo.getAcceptedLanguages().add(new Preference((Metadata)language));
                continue;
            }
            if ("Cookie".equalsIgnoreCase(key)) {
                String k = StringHelper.before((String)value, (String)"=");
                String v = StringHelper.after((String)value, (String)"=");
                if (k == null || v == null) continue;
                Cookie cookie = new Cookie(k, v);
                request.getCookies().add((Object)cookie);
                continue;
            }
            if ("Content-Type".equalsIgnoreCase(key)) {
                MediaType mediaType = (MediaType)exchange.getContext().getTypeConverter().tryConvertTo(MediaType.class, exchange, (Object)value);
                if (mediaType == null) continue;
                request.getEntity().setMediaType(mediaType);
                continue;
            }
            if ("User-Agent".equalsIgnoreCase(key)) {
                request.getClientInfo().setAgent(value);
                continue;
            }
            if ("Referer".equalsIgnoreCase(key)) {
                request.setReferrerRef(value);
                continue;
            }
            if ("Host".equalsIgnoreCase(key)) {
                request.setHostRef(value);
                continue;
            }
            if ("Date".equalsIgnoreCase(key)) {
                Date d = (Date)exchange.getContext().getTypeConverter().tryConvertTo(Date.class, exchange, (Object)value);
                if (d == null) continue;
                request.setDate(d);
                continue;
            }
            LOG.warn("Addition of the standard request header \"{}\" is not allowed. Please use the equivalent property in the Restlet API.", (Object)key);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void populateRestletResponseFromExchange(Exchange exchange, Response response) throws Exception {
        Object body;
        Integer responseCode;
        MediaType mediaType;
        Message out;
        if (exchange.isFailed()) {
            Message msg;
            response.setStatus(Status.valueOf((int)500));
            Message message = msg = exchange.hasOut() ? exchange.getOut() : exchange.getIn();
            if (!msg.isFault()) {
                Exception t = exchange.getException();
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                t.printStackTrace(pw);
                response.setEntity(sw.toString(), MediaType.TEXT_PLAIN);
                return;
            }
            out = msg;
        } else {
            out = exchange.hasOut() ? exchange.getOut() : exchange.getIn();
        }
        if ((mediaType = (MediaType)out.getHeader("Content-Type", MediaType.class)) == null) {
            Object body2 = out.getBody();
            mediaType = MediaType.TEXT_PLAIN;
            if (body2 instanceof String) {
                mediaType = MediaType.TEXT_PLAIN;
            } else if (body2 instanceof StringSource || body2 instanceof DOMSource) {
                mediaType = MediaType.TEXT_XML;
            }
        }
        if ((responseCode = (Integer)out.getHeader("CamelHttpResponseCode", Integer.class)) != null) {
            response.setStatus(Status.valueOf((int)responseCode));
        }
        if ((body = out.getBody()) instanceof WrappedFile) {
            GenericFile gf = (GenericFile)body;
            body = gf.getBody();
        }
        if (body == null) {
            response.setEntity("", MediaType.TEXT_PLAIN);
            if (Status.SUCCESS_OK.equals((Object)response.getStatus())) {
                response.setStatus(Status.SUCCESS_NO_CONTENT);
            }
        } else if (body instanceof Response) {
            LOG.debug("Using existing Restlet Response from exchange body: {}", body);
        } else if (body instanceof Representation) {
            response.setEntity((Representation)out.getBody(Representation.class));
        } else if (body instanceof InputStream) {
            response.setEntity((Representation)new InputRepresentation((InputStream)out.getBody(InputStream.class), mediaType));
        } else if (body instanceof File) {
            response.setEntity((Representation)new FileRepresentation((File)out.getBody(File.class), mediaType));
        } else if (body instanceof byte[]) {
            byte[] bytes = (byte[])out.getBody(byte[].class);
            response.setEntity((Representation)new ByteArrayRepresentation(bytes, mediaType, (long)bytes.length));
        } else {
            String text = (String)out.getBody(String.class);
            response.setEntity(text, mediaType);
        }
        LOG.debug("Populate Restlet response from exchange body: {}", body);
        if (exchange.getProperty("CamelCharsetName") != null) {
            CharacterSet cs = CharacterSet.valueOf((String)((String)exchange.getProperty("CamelCharsetName", String.class)));
            response.getEntity().setCharacterSet(cs);
        }
        Series series = new Series(Header.class);
        for (Map.Entry entry : out.getHeaders().entrySet()) {
            String text;
            boolean added;
            Object value;
            String key = (String)entry.getKey();
            if (this.headerFilterStrategy.applyFilterToCamelHeaders(key, value = entry.getValue(), exchange) || (added = this.setResponseHeader(exchange, response, key, value)) || key.startsWith("Camel") || key.startsWith("org.restlet") || (text = (String)exchange.getContext().getTypeConverter().tryConvertTo(String.class, exchange, value)) == null) continue;
            series.add(key, text);
        }
        Request extensionHeaders = new Request();
        HeaderUtils.copyExtensionHeaders((Series)series, (org.restlet.Message)extensionHeaders);
        Series standardHeaders = new Series(Header.class);
        standardHeaders.addAll((Collection)series);
        standardHeaders.removeAll((Collection)extensionHeaders.getHeaders());
        series.removeAll((Collection)standardHeaders);
        LOG.debug("Detected {} response extension headers", (Object)extensionHeaders.getHeaders().size());
        LOG.debug("Detected {} response standard headers", (Object)standardHeaders.size());
        HeaderUtils.copyResponseTransportHeaders((Series)standardHeaders, (Response)response);
        HeaderUtils.extractEntityHeaders((Iterable)standardHeaders, (Representation)response.getEntity());
        if (extensionHeaders.getHeaders().size() > 0) {
            response.getHeaders().addAll((Collection)extensionHeaders.getHeaders());
        }
    }

    @Override
    public void populateExchangeFromRestletResponse(Exchange exchange, Response response) throws Exception {
        for (Map.Entry entry : response.getAttributes().entrySet()) {
            Object value;
            String key = (String)entry.getKey();
            if (this.headerFilterStrategy.applyFilterToExternalHeaders(key, value = entry.getValue(), exchange)) continue;
            exchange.getOut().setHeader(key, value);
            LOG.debug("Populate exchange from Restlet response header: {} value: {}", (Object)key, value);
        }
        int responseCode = response.getStatus().getCode();
        exchange.getOut().setHeader("CamelHttpResponseCode", (Object)responseCode);
        exchange.getOut().setHeader("CamelRestletResponse", (Object)response);
        if (response.getEntity() != null) {
            DecodeRepresentation representationDecoded;
            MediaType mediaType = response.getEntity().getMediaType();
            if (mediaType != null) {
                LOG.debug("Setting the Content-Type to be {}", (Object)mediaType);
                exchange.getOut().setHeader("Content-Type", (Object)mediaType.toString());
            }
            if (this.streamRepresentation && response.getEntity() instanceof StreamRepresentation) {
                representationDecoded = new DecodeRepresentation(response.getEntity());
                InputStream is = representationDecoded.getStream();
                exchange.getOut().setBody((Object)is);
                if (this.autoCloseStream) {
                    exchange.addOnCompletion((Synchronization)new RestletOnCompletion(is));
                }
            } else if (response.getEntity() instanceof Representation) {
                representationDecoded = new DecodeRepresentation(response.getEntity());
                exchange.getOut().setBody((Object)representationDecoded.getText());
            } else {
                String text = response.getEntity().getText();
                LOG.debug("Populate exchange from Restlet response: {}", (Object)text);
                exchange.getOut().setBody((Object)text);
            }
        }
        MessageHelper.copyHeaders((Message)exchange.getIn(), (Message)exchange.getOut(), (boolean)false);
    }

    protected boolean setResponseHeader(Exchange exchange, Response message, String header, Object value) {
        if (value == null) {
            return true;
        }
        message.getAttributes().put(header, value);
        if (message.getEntity() != null) {
            if (header.equalsIgnoreCase("Access-Control-Allow-Credentials")) {
                Boolean bool = (Boolean)exchange.getContext().getTypeConverter().tryConvertTo(Boolean.class, value);
                if (bool != null) {
                    message.setAccessControlAllowCredentials(bool);
                }
                return true;
            }
            if (header.equalsIgnoreCase("Access-Control-Allow-Headers")) {
                Set<String> set = this.convertToStringSet(value, exchange.getContext().getTypeConverter());
                message.setAccessControlAllowHeaders(set);
                return true;
            }
            if (header.equalsIgnoreCase("Access-Control-Allow-Methods")) {
                Set<Method> set = this.convertToMethodSet(value, exchange.getContext().getTypeConverter());
                message.setAccessControlAllowMethods(set);
                return true;
            }
            if (header.equalsIgnoreCase("Access-Control-Allow-Origin")) {
                String text = (String)exchange.getContext().getTypeConverter().tryConvertTo(String.class, value);
                if (text != null) {
                    message.setAccessControlAllowOrigin(text);
                }
                return true;
            }
            if (header.equalsIgnoreCase("Access-Control-Expose-Headers")) {
                Set<String> set = this.convertToStringSet(value, exchange.getContext().getTypeConverter());
                message.setAccessControlExposeHeaders(set);
                return true;
            }
            if (header.equalsIgnoreCase("Cache-Control")) {
                if (value instanceof List) {
                    message.setCacheDirectives((List)value);
                }
                if (value instanceof String) {
                    ArrayList<CacheDirective> list = new ArrayList<CacheDirective>();
                    list.add(new CacheDirective((String)value));
                    message.setCacheDirectives(list);
                }
                return true;
            }
            if (header.equalsIgnoreCase("Location")) {
                String text = (String)exchange.getContext().getTypeConverter().tryConvertTo(String.class, value);
                if (text != null) {
                    message.setLocationRef(text);
                }
                return true;
            }
            if (header.equalsIgnoreCase("Expires")) {
                if (value instanceof Calendar) {
                    message.getEntity().setExpirationDate(((Calendar)value).getTime());
                } else if (value instanceof Date) {
                    message.getEntity().setExpirationDate((Date)value);
                } else if (value instanceof String) {
                    SimpleDateFormat format = new SimpleDateFormat(RFC_2822_DATE_PATTERN, Locale.ENGLISH);
                    try {
                        Date date = format.parse((String)value);
                        message.getEntity().setExpirationDate(date);
                    }
                    catch (ParseException e) {
                        LOG.debug("Header {} with value {} cannot be converted as a Date. The value will be ignored.", (Object)"Expires", value);
                    }
                }
                return true;
            }
            if (header.equalsIgnoreCase("Last-Modified")) {
                if (value instanceof Calendar) {
                    message.getEntity().setModificationDate(((Calendar)value).getTime());
                } else if (value instanceof Date) {
                    message.getEntity().setModificationDate((Date)value);
                } else if (value instanceof String) {
                    SimpleDateFormat format = new SimpleDateFormat(RFC_2822_DATE_PATTERN, Locale.ENGLISH);
                    try {
                        Date date = format.parse((String)value);
                        message.getEntity().setModificationDate(date);
                    }
                    catch (ParseException e) {
                        LOG.debug("Header {} with value {} cannot be converted as a Date. The value will be ignored.", (Object)"Last-Modified", value);
                    }
                }
                return true;
            }
            if (header.equalsIgnoreCase("Content-Length")) {
                if (value instanceof Long) {
                    message.getEntity().setSize(((Long)value).longValue());
                } else if (value instanceof Integer) {
                    message.getEntity().setSize((long)((Integer)value).intValue());
                } else {
                    Long num = (Long)exchange.getContext().getTypeConverter().tryConvertTo(Long.class, value);
                    if (num != null) {
                        message.getEntity().setSize(num.longValue());
                    } else {
                        LOG.debug("Header {} with value {} cannot be converted as a Long. The value will be ignored.", (Object)"Content-Length", value);
                    }
                }
                return true;
            }
            if (header.equalsIgnoreCase("Content-Type")) {
                if (value instanceof MediaType) {
                    message.getEntity().setMediaType((MediaType)value);
                } else {
                    String type = value.toString();
                    MediaType media = MediaType.valueOf((String)type);
                    if (media != null) {
                        message.getEntity().setMediaType(media);
                    } else {
                        LOG.debug("Header {} with value {} cannot be converted as a MediaType. The value will be ignored.", (Object)"Content-Type", value);
                    }
                }
                return true;
            }
        }
        return false;
    }

    private Set<String> convertToStringSet(Object value, TypeConverter typeConverter) {
        if (value instanceof Set) {
            return (Set)value;
        }
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        Iterator it = ObjectHelper.createIterator((Object)value);
        while (it.hasNext()) {
            Object next = it.next();
            String text = (String)typeConverter.tryConvertTo(String.class, next);
            if (text == null) continue;
            set.add(text.trim());
        }
        return set;
    }

    private Set<Method> convertToMethodSet(Object value, TypeConverter typeConverter) {
        if (value instanceof Set) {
            return (Set)value;
        }
        LinkedHashSet<Method> set = new LinkedHashSet<Method>();
        Iterator it = ObjectHelper.createIterator((Object)value);
        while (it.hasNext()) {
            Object next = it.next();
            String text = (String)typeConverter.tryConvertTo(String.class, next);
            if (text == null) continue;
            Method method = Method.valueOf((String)text.trim());
            set.add(method);
        }
        return set;
    }

    protected Representation createRepresentationFromBody(Exchange exchange, MediaType mediaType) {
        Object body = exchange.getIn().getBody();
        if (body == null) {
            return new EmptyRepresentation();
        }
        if (body instanceof WrappedFile) {
            body = ((WrappedFile)body).getFile();
        }
        if (body instanceof InputStream) {
            return new InputRepresentation((InputStream)body, mediaType);
        }
        if (body instanceof File) {
            return new FileRepresentation((File)body, mediaType);
        }
        if (body instanceof byte[]) {
            return new ByteArrayRepresentation((byte[])body, mediaType);
        }
        if (body instanceof String) {
            return new StringRepresentation((CharSequence)body, mediaType);
        }
        body = exchange.getIn().getBody(String.class);
        if (body != null) {
            return new StringRepresentation((CharSequence)body, mediaType);
        }
        return new EmptyRepresentation();
    }

    public HeaderFilterStrategy getHeaderFilterStrategy() {
        return this.headerFilterStrategy;
    }

    public void setHeaderFilterStrategy(HeaderFilterStrategy strategy) {
        this.headerFilterStrategy = strategy;
    }

    public boolean isStreamRepresentation() {
        return this.streamRepresentation;
    }

    public void setStreamRepresentation(boolean streamRepresentation) {
        this.streamRepresentation = streamRepresentation;
    }

    public boolean isAutoCloseStream() {
        return this.autoCloseStream;
    }

    public void setAutoCloseStream(boolean autoCloseStream) {
        this.autoCloseStream = autoCloseStream;
    }
}

