/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.rx.support;

import org.apache.camel.CamelContext;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.rx.support.ReactiveBeanPostProcessor;
import org.apache.camel.spi.Injector;
import org.apache.camel.util.ReflectionInjector;

public class ReactiveInjector
implements Injector {
    private final Injector delegate = new ReflectionInjector();
    private final ReactiveBeanPostProcessor postProcessor;

    public ReactiveInjector(CamelContext context) {
        this.postProcessor = new ReactiveBeanPostProcessor(context);
    }

    public <T> T newInstance(Class<T> type) {
        Object answer = this.delegate.newInstance(type);
        if (answer != null) {
            try {
                this.postProcessor.postProcessBeforeInitialization(answer, answer.getClass().getName());
                this.postProcessor.postProcessAfterInitialization(answer, answer.getClass().getName());
            }
            catch (Exception e) {
                throw new RuntimeCamelException("Error during post processing of bean " + answer, (Throwable)e);
            }
        }
        return (T)answer;
    }

    public <T> T newInstance(Class<T> type, Object instance) {
        Object answer = this.delegate.newInstance(type, instance);
        if (answer != null) {
            try {
                this.postProcessor.postProcessBeforeInitialization(answer, answer.getClass().getName());
                this.postProcessor.postProcessAfterInitialization(answer, answer.getClass().getName());
            }
            catch (Exception e) {
                throw new RuntimeCamelException("Error during post processing of bean " + answer, (Throwable)e);
            }
        }
        return (T)answer;
    }

    public boolean supportsAutoWiring() {
        return this.delegate.supportsAutoWiring();
    }
}

