/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce.api.dto.composite;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.camel.component.salesforce.api.dto.AbstractSObjectBase;
import org.apache.camel.component.salesforce.api.dto.Attributes;
import org.apache.camel.component.salesforce.api.dto.RestError;
import org.apache.camel.component.salesforce.api.dto.composite.Counter;
import org.apache.camel.component.salesforce.api.dto.composite.ReferenceGenerator;
import org.apache.camel.component.salesforce.api.dto.composite.SObjectNode;
import org.apache.camel.util.ObjectHelper;

public final class SObjectTree
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty
    final List<SObjectNode> records = new CopyOnWriteArrayList<SObjectNode>();
    final ReferenceGenerator referenceGenerator;
    private String objectType;

    public SObjectTree() {
        this(new Counter());
    }

    public SObjectTree(ReferenceGenerator referenceGenerator) {
        this.referenceGenerator = Objects.requireNonNull(referenceGenerator, "You must specify the ReferenceGenerator implementation");
    }

    public SObjectNode addObject(AbstractSObjectBase object) {
        ObjectHelper.notNull((Object)object, (String)"object");
        return this.addNode(new SObjectNode(this, object));
    }

    public Stream<SObjectNode> allNodes() {
        return this.records.stream().flatMap(r -> Stream.concat(Stream.of(r), r.getChildNodes()));
    }

    public Stream<AbstractSObjectBase> allObjects() {
        return this.records.stream().flatMap(r -> Stream.concat(Stream.of(r.getObject()), r.getChildren()));
    }

    @JsonIgnore
    public String getObjectType() {
        return this.objectType;
    }

    public Class[] objectTypes() {
        Set<Class> types = this.records.stream().flatMap(n -> n.objectTypes()).collect(Collectors.toSet());
        return types.toArray(new Class[types.size()]);
    }

    public void setErrorFor(String referenceId, List<RestError> errors) {
        for (SObjectNode node : this.records) {
            if (!this.setErrorFor(node, referenceId, errors)) continue;
            return;
        }
    }

    public void setIdFor(String referenceId, String id) {
        for (SObjectNode node : this.records) {
            if (!this.setIdFor(node, referenceId, id)) continue;
            return;
        }
    }

    public int size() {
        return this.records.stream().mapToInt(r -> r.size()).sum();
    }

    SObjectNode addNode(SObjectNode node) {
        String givenObjectType = node.getObjectType();
        if (this.objectType != null && !this.objectType.equals(givenObjectType)) {
            throw new IllegalArgumentException("SObjectTree can hold only records of the same type, previously given: " + this.objectType + ", and now trying to add: " + givenObjectType);
        }
        this.objectType = givenObjectType;
        this.records.add(node);
        return node;
    }

    boolean setErrorFor(SObjectNode node, String referenceId, List<RestError> errors) {
        Attributes attributes = node.getObject().getAttributes();
        String attributesReferenceId = attributes.getReferenceId();
        if (Objects.equals(attributesReferenceId, referenceId)) {
            node.setErrors(errors);
            return true;
        }
        return StreamSupport.stream(node.getChildNodes().spliterator(), false).anyMatch(n -> this.setErrorFor((SObjectNode)n, referenceId, errors));
    }

    boolean setIdFor(SObjectNode node, String referenceId, String id) {
        Attributes attributes = node.getObject().getAttributes();
        String attributesReferenceId = attributes.getReferenceId();
        if (Objects.equals(attributesReferenceId, referenceId)) {
            AbstractSObjectBase object = node.getObject();
            if (object != null) {
                return this.updateBaseObjectId(id, object);
            }
            return this.updateGeneralObjectId(id, object);
        }
        return StreamSupport.stream(node.getChildNodes().spliterator(), false).anyMatch(n -> this.setIdFor((SObjectNode)n, referenceId, id));
    }

    boolean updateBaseObjectId(String id, AbstractSObjectBase object) {
        object.setId(id);
        return true;
    }

    boolean updateGeneralObjectId(String id, Object object) {
        BeanInfo beanInfo;
        Class<?> clazz = object.getClass();
        try {
            beanInfo = Introspector.getBeanInfo(clazz);
        }
        catch (IntrospectionException e) {
            throw new IllegalStateException(e);
        }
        PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
        Optional<PropertyDescriptor> maybeIdProperty = Arrays.stream(propertyDescriptors).filter(pd -> "id".equals(pd.getName())).findFirst();
        if (maybeIdProperty.isPresent()) {
            Method readMethod = maybeIdProperty.get().getReadMethod();
            try {
                readMethod.invoke(object, id);
                return true;
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new IllegalStateException(e);
            }
        }
        return false;
    }
}

