/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce.internal.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.type.CollectionType;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.camel.component.salesforce.SalesforceEndpointConfig;
import org.apache.camel.component.salesforce.SalesforceHttpClient;
import org.apache.camel.component.salesforce.SalesforceLoginConfig;
import org.apache.camel.component.salesforce.api.SalesforceException;
import org.apache.camel.component.salesforce.api.dto.composite.SObjectBatch;
import org.apache.camel.component.salesforce.api.dto.composite.SObjectBatchResponse;
import org.apache.camel.component.salesforce.api.dto.composite.SObjectComposite;
import org.apache.camel.component.salesforce.api.dto.composite.SObjectCompositeResponse;
import org.apache.camel.component.salesforce.api.dto.composite.SObjectTree;
import org.apache.camel.component.salesforce.api.dto.composite.SObjectTreeResponse;
import org.apache.camel.component.salesforce.api.utils.JsonUtils;
import org.apache.camel.component.salesforce.api.utils.Version;
import org.apache.camel.component.salesforce.internal.SalesforceSession;
import org.apache.camel.component.salesforce.internal.client.AbstractClientBase;
import org.apache.camel.component.salesforce.internal.client.CompositeApiClient;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.util.InputStreamContentProvider;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;

public class DefaultCompositeApiClient
extends AbstractClientBase
implements CompositeApiClient {
    private ObjectMapper mapper;

    public DefaultCompositeApiClient(SalesforceEndpointConfig configuration, String version, SalesforceSession session, SalesforceHttpClient httpClient, SalesforceLoginConfig loginConfig) throws SalesforceException {
        super(version, session, httpClient, loginConfig);
        this.mapper = configuration.getObjectMapper() != null ? configuration.getObjectMapper() : JsonUtils.createObjectMapper();
    }

    @Override
    public void submitCompositeRaw(InputStream raw, Map<String, List<String>> headers, final CompositeApiClient.ResponseCallback<InputStream> callback, String compositeMethod) throws SalesforceException {
        String url = this.versionUrl() + "composite";
        if (compositeMethod == null) {
            compositeMethod = HttpMethod.POST.asString();
        }
        Request request = this.createRequest(compositeMethod, url, headers);
        InputStreamContentProvider content = new InputStreamContentProvider(raw);
        request.content((ContentProvider)content);
        this.doHttpRequest(request, new AbstractClientBase.ClientResponseCallback(){

            @Override
            public void onResponse(InputStream response, Map<String, String> headers, SalesforceException ex) {
                callback.onResponse(Optional.ofNullable(response), headers, ex);
            }
        });
    }

    @Override
    public void submitComposite(SObjectComposite composite, Map<String, List<String>> headers, CompositeApiClient.ResponseCallback<SObjectCompositeResponse> callback) throws SalesforceException {
        String url = this.versionUrl() + "composite";
        Request post = this.createRequest(HttpMethod.POST, url, headers);
        ContentProvider content = this.serialize(composite, composite.objectTypes());
        post.content(content);
        this.doHttpRequest(post, (response, responseHeaders, exception) -> callback.onResponse(this.tryToReadResponse(SObjectCompositeResponse.class, response), responseHeaders, exception));
    }

    @Override
    public void submitCompositeBatch(SObjectBatch batch, Map<String, List<String>> headers, CompositeApiClient.ResponseCallback<SObjectBatchResponse> callback) throws SalesforceException {
        DefaultCompositeApiClient.checkCompositeBatchVersion(this.version, batch.getVersion());
        String url = this.versionUrl() + "composite/batch";
        Request post = this.createRequest(HttpMethod.POST, url, headers);
        ContentProvider content = this.serialize(batch, batch.objectTypes());
        post.content(content);
        this.doHttpRequest(post, (response, responseHeaders, exception) -> callback.onResponse(this.tryToReadResponse(SObjectBatchResponse.class, response), responseHeaders, exception));
    }

    @Override
    public void submitCompositeTree(SObjectTree tree, Map<String, List<String>> headers, CompositeApiClient.ResponseCallback<SObjectTreeResponse> callback) throws SalesforceException {
        String url = this.versionUrl() + "composite/tree/" + tree.getObjectType();
        Request post = this.createRequest(HttpMethod.POST, url, headers);
        ContentProvider content = this.serialize(tree, tree.objectTypes());
        post.content(content);
        this.doHttpRequest(post, (response, responseHeaders, exception) -> callback.onResponse(this.tryToReadResponse(SObjectTreeResponse.class, response), responseHeaders, exception));
    }

    Request createRequest(String method, String url, Map<String, List<String>> headers) {
        Request request = this.getRequest(method, url, headers);
        return this.populateRequest(request);
    }

    Request createRequest(HttpMethod method, String url, Map<String, List<String>> headers) {
        Request request = this.getRequest(method, url, headers);
        return this.populateRequest(request);
    }

    private Request populateRequest(Request request) {
        this.setAccessToken(request);
        request.header(HttpHeader.CONTENT_TYPE, "application/json;charset=utf-8");
        request.header(HttpHeader.ACCEPT, "application/json;charset=utf-8");
        request.header(HttpHeader.ACCEPT_CHARSET, "utf-8");
        return request;
    }

    <T> T fromJson(Class<T> expectedType, InputStream responseStream) throws IOException {
        return (T)this.jsonReaderFor(expectedType).readValue(responseStream);
    }

    <T> List<T> fromJsonList(Class<T> expectedType, InputStream responseStream) throws IOException {
        CollectionType collectionType = this.mapper.getTypeFactory().constructCollectionType(List.class, expectedType);
        return (List)this.mapper.readValue(responseStream, (JavaType)collectionType);
    }

    ObjectReader jsonReaderFor(Class<?> type) {
        return this.mapper.readerFor(type);
    }

    ObjectWriter jsonWriterFor(Object obj) {
        Class<?> type = obj.getClass();
        return this.mapper.writerFor(type);
    }

    ContentProvider serialize(Object body, Class<?> ... additionalTypes) throws SalesforceException {
        return new InputStreamContentProvider(this.toJson(body));
    }

    String servicesDataUrl() {
        return this.instanceUrl + "/services/data/";
    }

    InputStream toJson(Object obj) throws SalesforceException {
        byte[] jsonBytes;
        try {
            jsonBytes = this.jsonWriterFor(obj).writeValueAsBytes(obj);
        }
        catch (JsonProcessingException e) {
            throw new SalesforceException("Unable to serialize given SObjectTree to JSON", e);
        }
        return new ByteArrayInputStream(jsonBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> Optional<T> tryToReadResponse(Class<T> expectedType, InputStream responseStream) {
        if (responseStream == null) {
            return Optional.empty();
        }
        try {
            Optional<T> optional = Optional.of(this.fromJson(expectedType, responseStream));
            return optional;
        }
        catch (IOException e) {
            this.log.warn("Unable to read response from the Composite API", (Throwable)e);
            Optional optional = Optional.empty();
            return optional;
        }
        finally {
            IOHelper.close((Closeable)responseStream);
        }
    }

    String versionUrl() {
        ObjectHelper.notNull((Object)this.version, (String)"version");
        return this.servicesDataUrl() + "v" + this.version + "/";
    }

    @Override
    protected void setAccessToken(Request request) {
        request.getHeaders().put("Authorization", "Bearer " + this.accessToken);
    }

    static void checkCompositeBatchVersion(String configuredVersion, Version batchVersion) throws SalesforceException {
        if (Version.create(configuredVersion).compareTo(batchVersion) < 0) {
            throw new SalesforceException("Component is configured with Salesforce API version " + configuredVersion + ", but the payload of the Composite API batch operation requires at least " + batchVersion, 0);
        }
    }
}

