/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce.internal.client;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.apache.camel.component.salesforce.SalesforceHttpClient;
import org.apache.camel.component.salesforce.SalesforceLoginConfig;
import org.apache.camel.component.salesforce.api.SalesforceException;
import org.apache.camel.component.salesforce.internal.PayloadFormat;
import org.apache.camel.component.salesforce.internal.SalesforceSession;
import org.apache.camel.component.salesforce.internal.client.AbstractClientBase;
import org.apache.camel.component.salesforce.internal.client.RawClient;
import org.apache.commons.io.IOUtils;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.util.InputStreamContentProvider;
import org.eclipse.jetty.http.HttpHeader;

public class DefaultRawClient
extends AbstractClientBase
implements RawClient {
    private static final String BULK_TOKEN_HEADER = "X-SFDC-Session";
    private static final String REST_TOKEN_HEADER = "Authorization";
    private static final String TOKEN_PREFIX = "Bearer ";

    public DefaultRawClient(SalesforceHttpClient httpClient, String version, SalesforceSession session, SalesforceLoginConfig loginConfig) throws SalesforceException {
        super(version, session, httpClient, loginConfig);
    }

    @Override
    protected void setAccessToken(Request request) {
        request.header(BULK_TOKEN_HEADER, null);
        request.header(REST_TOKEN_HEADER, null);
        request.header(BULK_TOKEN_HEADER, this.accessToken);
        request.header(REST_TOKEN_HEADER, TOKEN_PREFIX + this.accessToken);
    }

    @Override
    protected SalesforceException createRestException(Response response, InputStream responseContent) {
        Object message = null;
        try {
            message = IOUtils.toString((InputStream)responseContent, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            message = "Unable to read exception message: " + e.getMessage();
        }
        return new SalesforceException((String)message, response.getStatus());
    }

    @Override
    public void makeRequest(String method, String path, PayloadFormat format, InputStream body, Map<String, List<String>> headers, RawClient.ResponseCallback callback) {
        String contentType;
        Request request = this.getRequest(method, this.instanceUrl + path, headers);
        String string = contentType = PayloadFormat.JSON.equals((Object)format) ? "application/json;charset=utf-8" : "application/xml;charset=utf-8";
        if (!request.getHeaders().contains(HttpHeader.ACCEPT)) {
            request.header(HttpHeader.ACCEPT, contentType);
        }
        request.header(HttpHeader.ACCEPT_CHARSET, "utf-8");
        if (!request.getHeaders().contains(HttpHeader.CONTENT_TYPE)) {
            request.header(HttpHeader.CONTENT_TYPE, contentType);
        }
        if (body != null) {
            request.content((ContentProvider)new InputStreamContentProvider(body));
        }
        this.setAccessToken(request);
        this.doHttpRequest(request, new DelegatingClientCallback(callback));
    }

    private static class DelegatingClientCallback
    implements AbstractClientBase.ClientResponseCallback {
        private final RawClient.ResponseCallback callback;

        DelegatingClientCallback(RawClient.ResponseCallback callback) {
            this.callback = callback;
        }

        @Override
        public void onResponse(InputStream response, Map<String, String> headers, SalesforceException ex) {
            this.callback.onResponse(response, headers, ex);
        }
    }
}

