/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce.internal.processor;

import java.io.IOException;
import java.util.List;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.component.salesforce.SalesforceEndpoint;
import org.apache.camel.component.salesforce.api.SalesforceException;
import org.apache.camel.component.salesforce.api.dto.pubsub.PublishResult;
import org.apache.camel.component.salesforce.internal.OperationName;
import org.apache.camel.component.salesforce.internal.client.PubSubApiClient;
import org.apache.camel.component.salesforce.internal.processor.AbstractSalesforceProcessor;
import org.apache.camel.support.service.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PubSubApiProcessor
extends AbstractSalesforceProcessor {
    private final Logger LOG = LoggerFactory.getLogger(this.getClass());
    private final String topic;
    private PubSubApiClient pubSubClient;

    public PubSubApiProcessor(SalesforceEndpoint endpoint) {
        super(endpoint);
        this.topic = endpoint.getTopicName();
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            if (this.operationName == OperationName.PUBSUB_PUBLISH) {
                this.processPublish(exchange, callback);
                return false;
            }
            throw new SalesforceException("Unknown operation: " + this.operationName.value(), null);
        }
        catch (SalesforceException e) {
            exchange.setException((Throwable)((Object)new SalesforceException(String.format("Error processing %s: [%s] \"%s\"", this.operationName.value(), e.getStatusCode(), e.getMessage()), (Throwable)((Object)e))));
            callback.done(true);
            return true;
        }
        catch (Exception e) {
            exchange.setException((Throwable)((Object)new SalesforceException(String.format("Unexpected Error processing %s: \"%s\"", this.operationName.value(), e.getMessage()), e)));
            callback.done(true);
            return true;
        }
    }

    private void processPublish(Exchange exchange, AsyncCallback callback) throws SalesforceException {
        try {
            this.LOG.debug("Publishing on topic: {}", (Object)this.topic);
            List body = (List)exchange.getIn().getMandatoryBody(List.class);
            List<PublishResult> results = this.pubSubClient.publishMessage(this.topic, body);
            exchange.getIn().setBody(results);
            callback.done(false);
        }
        catch (IOException | InvalidPayloadException e) {
            exchange.setException((Throwable)((Object)new SalesforceException(String.format("Unexpected Error processing %s: \"%s\"", this.operationName.value(), e.getMessage()), e)));
            callback.done(true);
        }
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        this.pubSubClient = new PubSubApiClient(this.endpoint.getComponent().getSession(), this.endpoint.getComponent().getLoginConfig(), this.endpoint.getComponent().getPubSubHost(), this.endpoint.getComponent().getPubSubPort(), 0L, 0L);
        ServiceHelper.startService((Object)((Object)this.pubSubClient));
    }

    public void doStop() throws Exception {
        ServiceHelper.stopService((Object)((Object)this.pubSubClient));
        super.doStop();
    }
}

