/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce.internal.processor;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.salesforce.SalesforceComponent;
import org.apache.camel.component.salesforce.SalesforceEndpoint;
import org.apache.camel.component.salesforce.api.SalesforceException;
import org.apache.camel.component.salesforce.internal.PayloadFormat;
import org.apache.camel.component.salesforce.internal.client.RawClient;
import org.apache.camel.component.salesforce.internal.processor.AbstractSalesforceProcessor;
import org.apache.camel.support.service.ServiceHelper;

public class RawProcessor
extends AbstractSalesforceProcessor {
    private RawClient rawClient;
    private final PayloadFormat format;

    public RawProcessor(SalesforceEndpoint endpoint) throws SalesforceException {
        super(endpoint);
        this.format = endpoint.getConfiguration().getFormat();
        if (this.format == null) {
            throw new IllegalArgumentException("format option must be specified when using the raw operation.");
        }
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        SalesforceComponent component = this.endpoint.getComponent();
        this.rawClient = component.createRawClientFor(this.endpoint);
        ServiceHelper.startService((Object)this.rawClient);
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopService((Object)this.rawClient);
        super.doStop();
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            StringBuilder path = new StringBuilder(this.getParameter("rawPath", exchange, false, false));
            String method = this.getParameter("rawMethod", exchange, false, false);
            String params = this.getParameter("rawQueryParameters", exchange, false, true);
            if (params != null) {
                path.append("?");
                for (String p : params.split(",")) {
                    if (!path.toString().endsWith("?")) {
                        path.append("&");
                    }
                    path.append(p).append("=");
                    path.append(this.urlEncode(exchange.getIn().getHeader(p).toString()));
                }
            }
            InputStream body = (InputStream)exchange.getIn().getBody(InputStream.class);
            this.rawClient.makeRequest(method, path.toString(), this.format, body, this.determineHeaders(exchange), (response, headers, exception) -> {
                Message in = exchange.getIn();
                in.getHeaders().putAll(headers);
                if (exception != null) {
                    exchange.setException((Throwable)((Object)exception));
                }
                in.setBody((Object)response);
                callback.done(false);
            });
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
            callback.done(true);
            return true;
        }
        return false;
    }

    @Override
    public Map<String, List<String>> determineHeaders(Exchange exchange) {
        try {
            Map headers = super.determineHeaders(exchange);
            String params = this.getParameter("rawHttpHeaders", exchange, false, true);
            if (params != null) {
                for (String p : params.split(",")) {
                    headers.put(p, Collections.singletonList(exchange.getIn().getHeader(p).toString()));
                }
            }
            return headers;
        }
        catch (SalesforceException e) {
            throw new RuntimeException((Throwable)((Object)e));
        }
    }

    private String urlEncode(String query) throws UnsupportedEncodingException {
        String encodedQuery = URLEncoder.encode(query, StandardCharsets.UTF_8);
        encodedQuery = encodedQuery.replace("+", "%20");
        return encodedQuery;
    }
}

