/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce.api.utils;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;

final class InstantSerializer
extends StdSerializer<Instant> {
    static final JsonSerializer<Instant> INSTANCE = new InstantSerializer();
    private static final long serialVersionUID = 1L;

    private InstantSerializer() {
        super(Instant.class);
    }

    public void serialize(Instant value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        ZonedDateTime zonedDateTime = value.atZone(ZoneId.systemDefault());
        serializers.defaultSerializeValue((Object)zonedDateTime, gen);
    }
}

