/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.xquery;

import net.sf.saxon.Configuration;
import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.component.xquery.XQueryBuilder;
import org.apache.camel.spi.PropertyConfigurer;
import org.apache.camel.spi.annotations.Language;
import org.apache.camel.support.SingleInputTypedLanguageSupport;
import org.apache.camel.support.component.PropertyConfigurerSupport;

@Language(value="xquery")
public class XQueryLanguage
extends SingleInputTypedLanguageSupport
implements PropertyConfigurer {
    private Configuration configuration;

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public Predicate createPredicate(String expression) {
        return (Predicate)this.createExpression(expression, null);
    }

    public Expression createExpression(String expression) {
        return this.createExpression(expression, null);
    }

    public Predicate createPredicate(String expression, Object[] properties) {
        return (Predicate)this.createExpression(expression, properties);
    }

    public Expression createExpression(String expression, Object[] properties) {
        expression = this.loadResource(expression);
        XQueryBuilder builder = XQueryBuilder.xquery(expression);
        this.configureBuilder(builder, properties);
        return builder;
    }

    protected void configureBuilder(XQueryBuilder builder, Object[] properties) {
        String str;
        Class clazz = (Class)this.property(Class.class, properties, 0, this.getResultType());
        if (clazz != null) {
            builder.setResultType(clazz);
        }
        if ((str = (String)this.property(String.class, properties, 1, this.getHeaderName())) != null) {
            builder.setHeaderName(str);
        }
        if ((str = (String)this.property(String.class, properties, 2, this.getPropertyName())) != null) {
            builder.setPropertyName(str);
        }
        if ((str = (String)this.property(String.class, properties, 3, this.getVariableName())) != null) {
            builder.setVariableName(str);
        }
        if (this.configuration != null) {
            builder.setConfiguration(this.configuration);
        }
    }

    public boolean configure(CamelContext camelContext, Object target, String name, Object value, boolean ignoreCase) {
        if (target != this) {
            throw new IllegalStateException("Can only configure our own instance !");
        }
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "resulttype": 
            case "resultType": {
                this.setResultType((Class)PropertyConfigurerSupport.property((CamelContext)camelContext, Class.class, (Object)value));
                return true;
            }
            case "headername": 
            case "headerName": {
                this.setHeaderName((String)PropertyConfigurerSupport.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "propertyname": 
            case "propertyName": {
                this.setPropertyName((String)PropertyConfigurerSupport.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "variablename": 
            case "variableName": {
                this.setVariableName((String)PropertyConfigurerSupport.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "configuration": 
            case "Configuration": {
                this.setConfiguration((Configuration)PropertyConfigurerSupport.property((CamelContext)camelContext, Configuration.class, (Object)value));
                return true;
            }
        }
        return false;
    }
}

