/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.service;

import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Service;
import org.apache.camel.StartupListener;
import org.apache.camel.SuspendableService;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.cloud.ServiceDefinition;
import org.apache.camel.cloud.ServiceRegistry;
import org.apache.camel.component.service.ServiceEndpoint;
import org.apache.camel.impl.DefaultConsumer;
import org.apache.camel.util.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedResource(description="Managed Service Consumer")
public class ServiceConsumer
extends DefaultConsumer {
    private static final transient Logger LOGGER = LoggerFactory.getLogger(ServiceConsumer.class);
    private final ServiceRegistry serviceRegistry;
    private final Endpoint delegatedEndpoint;
    private final Processor processor;
    private Consumer delegatedConsumer;

    public ServiceConsumer(ServiceEndpoint serviceEndpoint, Processor processor, ServiceRegistry serviceRegistry) {
        super((Endpoint)serviceEndpoint, processor);
        this.serviceRegistry = serviceRegistry;
        this.delegatedEndpoint = serviceEndpoint.getEndpoint();
        this.processor = processor;
    }

    protected void doStart() throws Exception {
        super.doStart();
        ServiceEndpoint endpoint = (ServiceEndpoint)this.getEndpoint();
        ServiceDefinition definition = endpoint.getServiceDefinition();
        LOGGER.debug("Using ServiceRegistry instance {} (id={}, type={}) to register: {}", new Object[]{this.serviceRegistry, this.serviceRegistry.getId(), this.serviceRegistry.getClass().getName(), definition});
        this.serviceRegistry.register(definition);
        this.delegatedConsumer = this.delegatedEndpoint.createConsumer(this.processor);
        if (this.delegatedConsumer instanceof StartupListener) {
            this.getEndpoint().getCamelContext().addStartupListener((StartupListener)this.delegatedConsumer);
        }
        ServiceHelper.startService((Service)this.delegatedEndpoint);
        ServiceHelper.startService((Service)this.delegatedConsumer);
    }

    protected void doStop() throws Exception {
        super.doStop();
        ServiceEndpoint endpoint = (ServiceEndpoint)this.getEndpoint();
        ServiceDefinition definition = endpoint.getServiceDefinition();
        this.serviceRegistry.deregister(definition);
        ServiceHelper.stopAndShutdownServices((Object[])new Object[]{this.delegatedConsumer});
        ServiceHelper.stopAndShutdownServices((Object[])new Object[]{this.delegatedEndpoint});
        this.delegatedConsumer = null;
    }

    protected void doResume() throws Exception {
        if (this.delegatedConsumer instanceof SuspendableService) {
            ServiceEndpoint endpoint = (ServiceEndpoint)this.getEndpoint();
            ServiceDefinition definition = endpoint.getServiceDefinition();
            this.serviceRegistry.register(definition);
            ((SuspendableService)this.delegatedConsumer).resume();
        }
        super.doResume();
    }

    protected void doSuspend() throws Exception {
        if (this.delegatedConsumer instanceof SuspendableService) {
            ServiceEndpoint endpoint = (ServiceEndpoint)this.getEndpoint();
            ServiceDefinition definition = endpoint.getServiceDefinition();
            this.serviceRegistry.deregister(definition);
            ((SuspendableService)this.delegatedConsumer).suspend();
        }
        super.doSuspend();
    }
}

