/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.servicenow;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.camel.CamelContext;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.extension.MetaDataExtension;
import org.apache.camel.component.extension.metadata.AbstractMetaDataExtension;
import org.apache.camel.component.extension.metadata.MetaDataBuilder;
import org.apache.camel.component.servicenow.ServiceNowClient;
import org.apache.camel.component.servicenow.ServiceNowConfiguration;
import org.apache.camel.component.servicenow.ServiceNowHelper;
import org.apache.camel.component.servicenow.model.DictionaryEntry;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ServiceNowMetaDataExtension
extends AbstractMetaDataExtension {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceNowMetaDataExtension.class);
    private final ConcurrentMap<String, String> properties = new ConcurrentHashMap<String, String>();

    ServiceNowMetaDataExtension() {
        this(null);
    }

    ServiceNowMetaDataExtension(CamelContext context) {
        super(context);
    }

    public Optional<MetaDataExtension.MetaData> meta(Map<String, Object> parameters) {
        String objectType = (String)parameters.get("objectType");
        String metaType = (String)parameters.getOrDefault("metaType", "definition");
        if (ObjectHelper.equalIgnoreCase((Object)objectType, (Object)"table") && ObjectHelper.equalIgnoreCase((Object)metaType, (Object)"definition")) {
            MetaContext context = new MetaContext(parameters);
            ObjectHelper.notNull((Object)context.getObjectType(), (String)"objectType");
            ObjectHelper.notNull((Object)context.getObjectName(), (String)"objectName");
            try {
                return this.tableDefinition(context);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        if (ObjectHelper.equalIgnoreCase((Object)objectType, (Object)"table") && ObjectHelper.equalIgnoreCase((Object)metaType, (Object)"list")) {
            MetaContext context = new MetaContext(parameters);
            ObjectHelper.notNull((Object)context.getObjectType(), (String)"objectType");
            try {
                return this.tableList(context);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        if (ObjectHelper.equalIgnoreCase((Object)objectType, (Object)"import") && ObjectHelper.equalIgnoreCase((Object)metaType, (Object)"list")) {
            MetaContext context = new MetaContext(parameters);
            ObjectHelper.notNull((Object)context.getObjectType(), (String)"objectType");
            try {
                return this.importSetList(context);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        throw new UnsupportedOperationException("Unsupported object type <" + objectType + ">");
    }

    private Optional<MetaDataExtension.MetaData> tableDefinition(MetaContext context) throws Exception {
        List<String> names = this.getObjectHierarchy(context);
        ObjectNode root = context.getConfiguration().getOrCreateMapper().createObjectNode();
        String baseUrn = (String)context.getParameters().getOrDefault("baseUrn", "org:apache:camel:component:servicenow");
        root.put("$schema", "http://json-schema.org/schema#");
        root.put("id", String.format("urn:jsonschema:%s:%s)", baseUrn, context.getObjectName()));
        root.put("type", "object");
        root.put("additionalProperties", false);
        root.putObject("properties");
        root.putArray("required");
        this.loadProperties(context);
        for (String name : names) {
            context.getStack().push(name);
            LOGGER.debug("Load dictionary <{}>", context.getStack());
            this.loadDictionary(context, name, root);
            context.getStack().pop();
        }
        String dateFormat = this.properties.getOrDefault("glide.sys.date_format", "yyyy-MM-dd");
        String timeFormat = this.properties.getOrDefault("glide.sys.time_format", "HH:mm:ss");
        return Optional.of(MetaDataBuilder.on((CamelContext)this.getCamelContext()).withAttribute("Content-Type", (Object)"application/schema+json").withAttribute("Java-Type", JsonNode.class).withAttribute("date.format", (Object)dateFormat).withAttribute("time.format", (Object)timeFormat).withAttribute("date-time.format", (Object)(dateFormat + " " + timeFormat)).withPayload((Object)root).build());
    }

    private Optional<MetaDataExtension.MetaData> importSetList(MetaContext context) throws Exception {
        Optional response = context.getClient().reset().types(MediaType.APPLICATION_JSON_TYPE).path("now").path(context.getConfiguration().getApiVersion()).path("table").path("sys_db_object").query("sysparm_exclude_reference_link", "true").query("sysparm_fields", "name%2Csys_id").query("sysparm_query", "name=sys_import_set_row").trasform("GET", this::findResultNode);
        if (response.isPresent()) {
            JsonNode node = (JsonNode)response.get();
            JsonNode sysId = node.findValue("sys_id");
            if (sysId == null) {
                throw new IllegalStateException("Unable to determine sys_id of sys_import_set_row");
            }
            response = context.getClient().reset().types(MediaType.APPLICATION_JSON_TYPE).path("now").path(context.getConfiguration().getApiVersion()).path("table").path("sys_db_object").query("sysparm_exclude_reference_link", "true").query("sysparm_fields", "name%2Csys_name").queryF("sysparm_query", "super_class=%s", sysId.textValue()).trasform("GET", this::findResultNode);
            if (response.isPresent()) {
                ObjectNode root = context.getConfiguration().getOrCreateMapper().createObjectNode();
                this.processResult((JsonNode)response.get(), n -> {
                    JsonNode name = n.findValue("name");
                    JsonNode label = n.findValue("sys_name");
                    if (name != null && label != null) {
                        root.put(name.textValue(), label.textValue());
                    }
                });
                return Optional.of(MetaDataBuilder.on((CamelContext)this.getCamelContext()).withAttribute("Content-Type", (Object)"application/json").withAttribute("Java-Type", JsonNode.class).withPayload((Object)root).build());
            }
        }
        return Optional.empty();
    }

    private Optional<MetaDataExtension.MetaData> tableList(MetaContext context) throws Exception {
        Optional response = context.getClient().reset().types(MediaType.APPLICATION_JSON_TYPE).path("now").path(context.getConfiguration().getApiVersion()).path("table").path("sys_db_object").query("sysparm_exclude_reference_link", "true").query("sysparm_fields", "name%2Csys_id").query("sysparm_query", "name=sys_import_set_row").trasform("GET", this::findResultNode);
        if (response.isPresent()) {
            JsonNode node = (JsonNode)response.get();
            JsonNode sysId = node.findValue("sys_id");
            response = context.getClient().reset().types(MediaType.APPLICATION_JSON_TYPE).path("now").path(context.getConfiguration().getApiVersion()).path("table").path("sys_db_object").query("sysparm_exclude_reference_link", "true").query("sysparm_fields", "name%2Csys_name%2Csuper_class").trasform("GET", this::findResultNode);
            if (response.isPresent()) {
                ObjectNode root = context.getConfiguration().getOrCreateMapper().createObjectNode();
                this.processResult((JsonNode)response.get(), n -> {
                    JsonNode superClass = n.findValue("super_class");
                    JsonNode name = n.findValue("name");
                    JsonNode label = n.findValue("sys_name");
                    if (superClass != null) {
                        String impId = sysId != null ? sysId.textValue() : null;
                        String superId = superClass.textValue();
                        if (impId != null && superId != null && ObjectHelper.equal((Object)impId, (Object)superId)) {
                            LOGGER.debug("skip table: name={}, label={} because it refers to an import set", (Object)name, (Object)label);
                            return;
                        }
                    }
                    if (name != null && label != null) {
                        String key = name.textValue();
                        String val = label.textValue();
                        if (ObjectHelper.isEmpty((Object)val)) {
                            val = key;
                        }
                        root.put(key, val);
                    }
                });
                return Optional.of(MetaDataBuilder.on((CamelContext)this.getCamelContext()).withAttribute("Content-Type", (Object)"application/json").withAttribute("Java-Type", JsonNode.class).withAttribute("Meta-Context", (Object)"import").withPayload((Object)root).build());
            }
        }
        return Optional.empty();
    }

    private void loadProperties(MetaContext context) throws Exception {
        if (!this.properties.isEmpty()) {
            return;
        }
        String offset = "0";
        while (true) {
            Response response = context.getClient().reset().types(MediaType.APPLICATION_JSON_TYPE).path("now").path(context.getConfiguration().getApiVersion()).path("table").path("sys_properties").query("sysparm_exclude_reference_link", "true").query("sysparm_fields", "name%2Cvalue").query("sysparm_offset", offset).query("sysparm_query", "name=glide.sys.date_format^ORname=glide.sys.time_format").invoke("GET");
            this.findResultNode(response).ifPresent(node -> this.processResult((JsonNode)node, n -> {
                if (n.hasNonNull("name") && n.hasNonNull("value")) {
                    this.properties.putIfAbsent(n.findValue("name").asText(), n.findValue("value").asText());
                }
            }));
            Optional<String> next = ServiceNowHelper.findOffset(response, "next");
            if (!next.isPresent()) break;
            offset = next.get();
        }
    }

    private void loadDictionary(MetaContext context, String name, ObjectNode root) throws Exception {
        String offset = "0";
        while (true) {
            Response response = context.getClient().reset().types(MediaType.APPLICATION_JSON_TYPE).path("now").path(context.getConfiguration().getApiVersion()).path("table").path("sys_dictionary").query("sysparm_display_value", "false").queryF("sysparm_query", "name=%s", name).query("sysparm_offset", offset).invoke("GET");
            this.findResultNode(response).ifPresent(node -> this.processResult((JsonNode)node, n -> this.processDictionaryNode(context, root, (JsonNode)n)));
            Optional<String> next = ServiceNowHelper.findOffset(response, "next");
            if (!next.isPresent()) break;
            offset = next.get();
        }
    }

    private void processDictionaryNode(MetaContext context, ObjectNode root, JsonNode node) {
        String id;
        if (node.hasNonNull("element") && ObjectHelper.isNotEmpty((Object)(id = node.get("element").asText()))) {
            String includeKey = "object." + context.getObjectName() + ".fields";
            String excludeKey = "object." + context.getObjectName() + ".fields.exclude.pattern";
            String fields = (String)context.getParameters().get(includeKey);
            String exclude = (String)context.getParameters().get(excludeKey);
            boolean included = true;
            if (ObjectHelper.isNotEmpty((Object)fields) && ObjectHelper.isNotEmpty((Object)exclude)) {
                boolean isIncluded = Stream.of(fields.split(",")).map(StringHelper::trimToNull).filter(Objects::nonNull).anyMatch(id::equalsIgnoreCase);
                boolean isExcluded = Pattern.compile(exclude).matcher(id).matches();
                included = isIncluded || !isExcluded;
            } else if (ObjectHelper.isNotEmpty((Object)fields)) {
                included = Stream.of(fields.split(",")).map(StringHelper::trimToNull).filter(Objects::nonNull).anyMatch(id::equalsIgnoreCase);
            } else if (ObjectHelper.isNotEmpty((Object)exclude)) {
                boolean bl = included = !Pattern.compile(exclude).matcher(id).matches();
            }
            if (!included) {
                return;
            }
            context.getStack().push(id);
            LOGGER.debug("Load dictionary element <{}>", context.getStack());
            try {
                DictionaryEntry entry = (DictionaryEntry)context.getConfiguration().getOrCreateMapper().treeToValue((TreeNode)node, DictionaryEntry.class);
                ObjectNode property = ((ObjectNode)root.get("properties")).putObject(id);
                ObjectNode servicenow = property.putObject("servicenow");
                servicenow.put("internal_type", entry.getInternalType().getValue());
                switch (entry.getInternalType().getValue()) {
                    case "integer": {
                        property.put("type", "integer");
                        break;
                    }
                    case "float": {
                        property.put("type", "number");
                        break;
                    }
                    case "boolean": {
                        property.put("type", "boolean");
                        break;
                    }
                    case "guid": 
                    case "GUID": {
                        property.put("type", "string");
                        property.put("pattern", "^[a-fA-F0-9]{32}");
                        break;
                    }
                    case "glide_date": {
                        property.put("type", "string");
                        property.put("format", "date");
                        break;
                    }
                    case "due_date": 
                    case "glide_date_time": 
                    case "glide_time": 
                    case "glide_duration": {
                        property.put("type", "string");
                        property.put("format", "date-time");
                        break;
                    }
                    case "reference": {
                        property.put("type", "string");
                        property.put("pattern", "^[a-fA-F0-9]{32}");
                        if (entry.getReference().getValue() == null) break;
                        servicenow.put("sys_db_object", entry.getReference().getValue());
                        break;
                    }
                    default: {
                        property.put("type", "string");
                        if (entry.getMaxLength() == null) break;
                        property.put("maxLength", entry.getMaxLength());
                    }
                }
                if (entry.isMandatory()) {
                    ArrayNode required = (ArrayNode)root.get("required");
                    if (required == null) {
                        required = root.putArray("required");
                    }
                    required.add(id);
                }
            }
            catch (JsonProcessingException e) {
                throw new RuntimeCamelException((Throwable)e);
            }
            finally {
                context.getStack().pop();
            }
        }
    }

    private List<String> getObjectHierarchy(MetaContext context) throws Exception {
        Optional response;
        ArrayList<String> hierarchy = new ArrayList<String>();
        String query = String.format("name=%s", context.getObjectName());
        while ((response = context.getClient().reset().types(MediaType.APPLICATION_JSON_TYPE).path("now").path(context.getConfiguration().getApiVersion()).path("table").path("sys_db_object").query("sysparm_exclude_reference_link", "true").query("sysparm_fields", "name%2Csuper_class").query("sysparm_query", query).trasform("GET", this::findResultNode)).isPresent()) {
            JsonNode node = (JsonNode)response.get();
            JsonNode nameNode = node.findValue("name");
            JsonNode classNode = node.findValue("super_class");
            if (nameNode == null || classNode == null) break;
            query = String.format("sys_id=%s", classNode.textValue());
            hierarchy.add(0, nameNode.textValue());
        }
        return hierarchy;
    }

    private void processResult(JsonNode node, Consumer<JsonNode> consumer) {
        if (node.isArray()) {
            Iterator it = node.elements();
            while (it.hasNext()) {
                consumer.accept((JsonNode)it.next());
            }
        } else {
            consumer.accept(node);
        }
    }

    private Optional<JsonNode> findResultNode(Response response) {
        JsonNode root;
        if (ObjectHelper.isNotEmpty((Object)response.getHeaderString("Content-Type")) && (root = (JsonNode)response.readEntity(JsonNode.class)) != null) {
            Iterator fields = root.fields();
            while (fields.hasNext()) {
                Map.Entry entry = (Map.Entry)fields.next();
                String key = (String)entry.getKey();
                JsonNode node = (JsonNode)entry.getValue();
                if (!ObjectHelper.equal((Object)"result", (Object)key, (boolean)true)) continue;
                return Optional.of(node);
            }
        }
        return Optional.empty();
    }

    private final class MetaContext {
        private final Map<String, Object> parameters;
        private final ServiceNowConfiguration configuration;
        private final ServiceNowClient client;
        private final String instanceName;
        private final String objectName;
        private final String objectType;
        private final Deque<String> stack;

        MetaContext(Map<String, Object> parameters) {
            this.parameters = parameters;
            this.configuration = new ServiceNowConfiguration();
            this.stack = new ArrayDeque<String>();
            try {
                IntrospectionSupport.setProperties((Object)this.configuration, new HashMap<String, Object>(parameters));
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
            this.instanceName = (String)parameters.get("instanceName");
            this.objectType = (String)parameters.getOrDefault("objectType", "table");
            this.objectName = (String)parameters.getOrDefault("objectName", this.configuration.getTable());
            ObjectHelper.notNull((Object)this.instanceName, (String)"instanceName");
            if (!this.configuration.hasApiUrl()) {
                this.configuration.setApiUrl(String.format("https://%s.service-now.com/api", this.instanceName));
            }
            if (!this.configuration.hasOauthTokenUrl()) {
                this.configuration.setOauthTokenUrl(String.format("https://%s.service-now.com/oauth_token.do", this.instanceName));
            }
            this.client = new ServiceNowClient(ServiceNowMetaDataExtension.this.getCamelContext(), this.configuration);
        }

        public Map<String, Object> getParameters() {
            return this.parameters;
        }

        public ServiceNowConfiguration getConfiguration() {
            return this.configuration;
        }

        public ServiceNowClient getClient() {
            return this.client;
        }

        public String getInstanceName() {
            return this.instanceName;
        }

        public String getObjectType() {
            return this.objectType;
        }

        public String getObjectName() {
            return this.objectName;
        }

        public Deque<String> getStack() {
            return this.stack;
        }
    }
}

