/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.servicenow.releases.helsinki;

import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.servicenow.AbstractServiceNowProcessor;
import org.apache.camel.component.servicenow.ServiceNowEndpoint;
import org.apache.camel.component.servicenow.ServiceNowParams;

class HelsinkiServiceNowScorecardProcessor
extends AbstractServiceNowProcessor {
    HelsinkiServiceNowScorecardProcessor(ServiceNowEndpoint endpoint) {
        super(endpoint);
        this.addDispatcher("retrieve", "performance_analytics", this::retrievePerformanceAnalytics);
    }

    private void retrievePerformanceAnalytics(Exchange exchange) throws Exception {
        Message in = exchange.getIn();
        Class<?> responseModel = this.getResponseModel(in);
        String apiVersion = this.getApiVersion(in);
        Response response = this.client.reset().types(MediaType.APPLICATION_JSON_TYPE).path("now").path(apiVersion).path("pa").path("scorecards").query(ServiceNowParams.SYSPARM_UUID, in).query(ServiceNowParams.SYSPARM_BREAKDOWN, in).query(ServiceNowParams.SYSPARM_INCLUDE_SCORES, in).query(ServiceNowParams.SYSPARM_INCLUDE_AGGREGATES, in).query(ServiceNowParams.SYSPARM_INCLUDE_AVAILABLE_BREAKDOWNS, in).query(ServiceNowParams.SYSPARM_INCLUDE_AVAILABLE_AGGREGATES, in).query(ServiceNowParams.SYSPARM_DISPLAY_VALUE, in).query(ServiceNowParams.SYSPARM_EXCLUDE_REFERENCE_LINK, in).query(ServiceNowParams.SYSPARM_FAVORITES, in).query(ServiceNowParams.SYSPARM_KEY, in).query(ServiceNowParams.SYSPARM_TARGET, in).query(ServiceNowParams.SYSPARM_DISPLAY, in).query(ServiceNowParams.SYSPARM_CONTAINS, in).query(ServiceNowParams.SYSPARM_TAGS, in).query(ServiceNowParams.SYSPARM_PER_PAGE, in).query(ServiceNowParams.SYSPARM_PAGE, in).query(ServiceNowParams.SYSPARM_SORT_BY, in).query(ServiceNowParams.SYSPARM_SORT_DIR, in).query(ServiceNowParams.SYSPARM_ELEMENTS_FILTER, in).query(ServiceNowParams.SYSPARM_BREAKDOWN_RELATION, in).query(ServiceNowParams.SYSPARM_INCLUDE_SCORE_NOTES, in).query(responseModel).invoke("GET");
        this.setBodyAndHeaders(in, responseModel, response);
    }
}

