/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.servicenow.auth;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.camel.component.servicenow.ServiceNowConfiguration;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.rs.security.oauth2.client.Consumer;
import org.apache.cxf.rs.security.oauth2.client.OAuthClientUtils;
import org.apache.cxf.rs.security.oauth2.common.AccessTokenGrant;
import org.apache.cxf.rs.security.oauth2.common.ClientAccessToken;
import org.apache.cxf.rs.security.oauth2.grants.owner.ResourceOwnerGrant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthToken {
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuthToken.class);
    private final Lock lock = new ReentrantLock();
    private final ServiceNowConfiguration configuration;
    private ClientAccessToken token;
    private String authString;
    private long expireAt;

    public OAuthToken(ServiceNowConfiguration configuration) {
        this.configuration = configuration;
        this.token = null;
        this.authString = null;
        this.expireAt = 0L;
    }

    private void getOrRefreshAccessToken() {
        this.lock.lock();
        try {
            if (this.token == null) {
                LOGGER.debug("Generate OAuth token");
                this.token = OAuthClientUtils.getAccessToken((WebClient)WebClient.create((String)this.configuration.getOauthTokenUrl()), (Consumer)new Consumer(this.configuration.getOauthClientId(), this.configuration.getOauthClientSecret()), (AccessTokenGrant)new ResourceOwnerGrant(this.configuration.getUserName(), this.configuration.getPassword()), (boolean)true);
                LOGGER.debug("OAuth token expires in {}s", (Object)this.token.getExpiresIn());
                this.token.setIssuedAt(System.currentTimeMillis());
                this.token.setExpiresIn(TimeUnit.MILLISECONDS.convert(this.token.getExpiresIn(), TimeUnit.SECONDS));
                this.authString = this.token.toString();
                if (this.token.getExpiresIn() > 0L) {
                    this.expireAt = this.token.getIssuedAt() + this.token.getExpiresIn();
                }
            } else if (this.expireAt > 0L && System.currentTimeMillis() >= this.expireAt) {
                LOGGER.debug("OAuth token is expired, refresh it");
                this.token = OAuthClientUtils.refreshAccessToken((WebClient)WebClient.create((String)this.configuration.getOauthTokenUrl()), (Consumer)new Consumer(this.configuration.getOauthClientId(), this.configuration.getOauthClientSecret()), (ClientAccessToken)this.token, null, (boolean)false);
                LOGGER.debug("Refreshed OAuth token expires in {}s", (Object)this.token.getExpiresIn());
                this.token.setIssuedAt(System.currentTimeMillis());
                this.token.setExpiresIn(TimeUnit.MILLISECONDS.convert(this.token.getExpiresIn(), TimeUnit.SECONDS));
                this.authString = this.token.toString();
                if (this.token.getExpiresIn() > 0L) {
                    this.expireAt = this.token.getIssuedAt() + this.token.getExpiresIn();
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public ClientAccessToken getClientAccess() {
        this.getOrRefreshAccessToken();
        return this.token;
    }

    public String getAuthString() {
        this.getOrRefreshAccessToken();
        return this.authString;
    }
}

