/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Locale;
import javax.activation.DataSource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.Part;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.attachment.Attachment;
import org.apache.camel.attachment.AttachmentMessage;
import org.apache.camel.attachment.DefaultAttachment;
import org.apache.camel.http.common.DefaultHttpBinding;
import org.apache.camel.http.common.HttpMessage;
import org.apache.camel.util.FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AttachmentHttpBinding
extends DefaultHttpBinding {
    private static final Logger LOG = LoggerFactory.getLogger(AttachmentHttpBinding.class);

    AttachmentHttpBinding() {
    }

    protected void populateAttachments(HttpServletRequest request, HttpMessage message) {
        try {
            Collection parts = request.getParts();
            for (Part part : parts) {
                String ext;
                String fileName = part.getName();
                boolean accepted = true;
                if (this.getFileNameExtWhitelist() != null && (ext = FileUtil.onlyExt((String)fileName)) != null) {
                    ext = ext.toLowerCase(Locale.US);
                    String whiteList = this.getFileNameExtWhitelist().toLowerCase(Locale.US);
                    if (!whiteList.equals("*") && !whiteList.contains(ext)) {
                        accepted = false;
                    }
                }
                if (accepted) {
                    PartDataSource ds = new PartDataSource(part);
                    DefaultAttachment attachment = new DefaultAttachment((DataSource)ds);
                    for (String headerName : part.getHeaderNames()) {
                        for (String headerValue : part.getHeaders(headerName)) {
                            attachment.addHeader(headerName, headerValue);
                        }
                    }
                    AttachmentMessage am = (AttachmentMessage)message.getExchange().getMessage(AttachmentMessage.class);
                    am.addAttachmentObject(part.getName(), (Attachment)attachment);
                    continue;
                }
                LOG.debug("Cannot add file as attachment: {} because the file is not accepted according to fileNameExtWhitelist: {}", (Object)fileName, (Object)this.getFileNameExtWhitelist());
            }
        }
        catch (Exception e) {
            throw new RuntimeCamelException("Cannot populate attachments", (Throwable)e);
        }
    }

    public final class PartDataSource
    implements DataSource {
        private final Part part;

        PartDataSource(Part part) {
            this.part = part;
        }

        public String getSubmittedFileName() {
            return this.part.getSubmittedFileName();
        }

        public OutputStream getOutputStream() throws IOException {
            return null;
        }

        public String getName() {
            return this.part.getName();
        }

        public InputStream getInputStream() throws IOException {
            return this.part.getInputStream();
        }

        public String getContentType() {
            return this.part.getContentType();
        }
    }
}

