/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sjms;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import org.apache.camel.Exchange;
import org.apache.camel.ExtendedExchange;
import org.apache.camel.component.sjms.SessionCallback;
import org.apache.camel.component.sjms.SjmsHelper;
import org.apache.camel.component.sjms.TransactionOnCompletion;
import org.apache.camel.component.sjms.jms.DestinationCreationStrategy;
import org.apache.camel.component.sjms.jms.MessageCreator;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.util.ObjectHelper;

public class SjmsTemplate {
    private final ConnectionFactory connectionFactory;
    private final boolean transacted;
    private final int acknowledgeMode;
    private DestinationCreationStrategy destinationCreationStrategy;
    private boolean explicitQosEnabled;
    private int deliveryMode = 2;
    private int priority = 4;
    private long timeToLive = 0L;

    public SjmsTemplate(ConnectionFactory connectionFactory, boolean transacted, int acknowledgeMode) {
        ObjectHelper.notNull((Object)connectionFactory, (String)"ConnectionFactory", (Object)this);
        this.connectionFactory = connectionFactory;
        this.transacted = transacted;
        this.acknowledgeMode = acknowledgeMode;
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setDestinationCreationStrategy(DestinationCreationStrategy destinationCreationStrategy) {
        this.destinationCreationStrategy = destinationCreationStrategy;
    }

    public void setQoSSettings(int deliveryMode, int priority, long timeToLive) {
        if (deliveryMode != 0) {
            this.deliveryMode = deliveryMode;
            this.explicitQosEnabled = true;
        }
        if (priority != 0) {
            this.priority = priority;
            this.explicitQosEnabled = true;
        }
        if (timeToLive > 0L) {
            this.timeToLive = timeToLive;
            this.explicitQosEnabled = true;
        }
    }

    public void setExplicitQosEnabled(boolean explicitQosEnabled) {
        this.explicitQosEnabled = explicitQosEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(SessionCallback sessionCallback, boolean startConnection) throws Exception {
        Connection con = null;
        Session session = null;
        try {
            con = this.createConnection();
            if (startConnection) {
                con.start();
            }
            session = this.createSession(con);
            Object object = sessionCallback.doInJms(session);
            sessionCallback.onClose(con, session);
            return object;
        }
        catch (Throwable throwable) {
            sessionCallback.onClose(con, session);
            throw throwable;
        }
    }

    public void execute(Session session, SessionCallback sessionCallback) throws Exception {
        if (session == null) {
            this.execute(sessionCallback, false);
        } else {
            try {
                sessionCallback.doInJms(session);
            }
            finally {
                sessionCallback.onClose(null, session);
            }
        }
    }

    public void send(final Exchange exchange, final String destinationName, final MessageCreator messageCreator, final boolean isTopic) throws Exception {
        SessionCallback callback = new SessionCallback(){
            private volatile Message message;
            private volatile boolean transacted;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object doInJms(Session session) throws Exception {
                this.transacted = SjmsHelper.isTransactionOrClientAcknowledgeMode(session);
                if (this.transacted) {
                    exchange.setProperty("CamelJMSSession", (Object)session);
                }
                Destination dest = SjmsTemplate.this.destinationCreationStrategy.createDestination(session, destinationName, isTopic);
                this.message = messageCreator.createMessage(session);
                MessageProducer producer = session.createProducer(dest);
                try {
                    SjmsTemplate.this.send(producer, this.message);
                }
                finally {
                    SjmsHelper.closeProducer(producer);
                }
                return null;
            }

            @Override
            public void onClose(Connection connection, Session session) {
                try {
                    if (this.transacted) {
                        TransactionOnCompletion toc;
                        ExtendedExchange ecc = (ExtendedExchange)exchange.adapt(ExtendedExchange.class);
                        if (!ecc.containsOnCompletion((Synchronization)(toc = new TransactionOnCompletion(session, this.message)))) {
                            ecc.addOnCompletion((Synchronization)toc);
                        }
                    } else {
                        SjmsHelper.closeSession(session);
                        SjmsHelper.closeConnection(connection);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        this.execute(callback, false);
    }

    public void send(MessageProducer producer, Message message) throws Exception {
        if (this.explicitQosEnabled) {
            producer.send(message, this.deliveryMode, this.priority, this.timeToLive);
        } else {
            producer.send(message);
        }
    }

    public Message receive(String destinationName, boolean isTopic, long timeout) throws Exception {
        Object obj = this.execute((Session sc) -> {
            Destination dest = this.destinationCreationStrategy.createDestination(sc, destinationName, isTopic);
            MessageConsumer consumer = sc.createConsumer(dest);
            Message message = null;
            try {
                message = timeout < 0L ? consumer.receiveNoWait() : (timeout == 0L ? consumer.receive() : consumer.receive(timeout));
            }
            catch (Throwable throwable) {
                SjmsHelper.commitIfNeeded(sc, message);
                SjmsHelper.closeConsumer(consumer);
                throw throwable;
            }
            SjmsHelper.commitIfNeeded(sc, message);
            SjmsHelper.closeConsumer(consumer);
            return message;
        }, true);
        return (Message)obj;
    }

    public Connection createConnection() throws Exception {
        return this.connectionFactory.createConnection();
    }

    public Session createSession(Connection connection) throws Exception {
        return connection.createSession(this.transacted, this.acknowledgeMode);
    }
}

