/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sjms.jms;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Session;
import javax.jms.Topic;
import org.apache.camel.component.sjms.jms.DestinationCreationStrategy;
import org.apache.camel.util.URISupport;

public class DefaultDestinationCreationStrategy
implements DestinationCreationStrategy {
    @Override
    public Destination createDestination(Session session, String name, boolean topic) throws JMSException {
        Topic destination;
        if (topic) {
            name = URISupport.stripPrefix((String)name, (String)"topic://");
            name = URISupport.stripPrefix((String)name, (String)"topic:");
            destination = session.createTopic(name);
        } else {
            name = URISupport.stripPrefix((String)name, (String)"queue://");
            name = URISupport.stripPrefix((String)name, (String)"queue:");
            destination = session.createQueue(name);
        }
        return destination;
    }

    @Override
    public Destination createTemporaryDestination(Session session, boolean topic) throws JMSException {
        if (topic) {
            return session.createTemporaryTopic();
        }
        return session.createTemporaryQueue();
    }
}

