/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sjms.jms;

import jakarta.jms.BytesMessage;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.MapMessage;
import jakarta.jms.MessageFormatException;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Session;
import jakarta.jms.StreamMessage;
import jakarta.jms.TextMessage;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.StreamCache;
import org.apache.camel.WrappedFile;
import org.apache.camel.component.sjms.jms.JmsKeyFormatStrategy;
import org.apache.camel.component.sjms.jms.JmsMessageHelper;
import org.apache.camel.component.sjms.jms.JmsMessageType;
import org.apache.camel.component.sjms.jms.MessageCreatedStrategy;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.DefaultExchangeHolder;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public class JmsBinding {
    private static final Logger LOG = LoggerFactory.getLogger(JmsBinding.class);
    private final boolean mapJmsMessage;
    private final boolean allowNullBody;
    private final HeaderFilterStrategy headerFilterStrategy;
    private final JmsKeyFormatStrategy jmsJmsKeyFormatStrategy;
    private final MessageCreatedStrategy messageCreatedStrategy;

    public JmsBinding(boolean mapJmsMessage, boolean allowNullBody, HeaderFilterStrategy headerFilterStrategy, JmsKeyFormatStrategy jmsJmsKeyFormatStrategy, MessageCreatedStrategy messageCreatedStrategy) {
        this.mapJmsMessage = mapJmsMessage;
        this.allowNullBody = allowNullBody;
        this.headerFilterStrategy = headerFilterStrategy;
        this.jmsJmsKeyFormatStrategy = jmsJmsKeyFormatStrategy;
        this.messageCreatedStrategy = messageCreatedStrategy;
    }

    public Object extractBodyFromJms(Exchange exchange, jakarta.jms.Message message) {
        try {
            if (!this.mapJmsMessage) {
                LOG.trace("Option map JMS message is false so using JMS message as body: {}", (Object)message);
                return message;
            }
            if (message instanceof ObjectMessage) {
                LOG.trace("Extracting body as a ObjectMessage from JMS message: {}", (Object)message);
                ObjectMessage objectMessage = (ObjectMessage)message;
                Serializable payload = objectMessage.getObject();
                if (payload instanceof DefaultExchangeHolder) {
                    DefaultExchangeHolder holder = (DefaultExchangeHolder)payload;
                    DefaultExchangeHolder.unmarshal((Exchange)exchange, (DefaultExchangeHolder)holder);
                    return exchange.getIn().getBody();
                }
                return objectMessage.getObject();
            }
            if (message instanceof TextMessage) {
                LOG.trace("Extracting body as a TextMessage from JMS message: {}", (Object)message);
                TextMessage textMessage = (TextMessage)message;
                return textMessage.getText();
            }
            if (message instanceof MapMessage) {
                LOG.trace("Extracting body as a MapMessage from JMS message: {}", (Object)message);
                return this.createMapFromMapMessage((MapMessage)message);
            }
            if (message instanceof BytesMessage) {
                LOG.trace("Extracting body as a BytesMessage from JMS message: {}", (Object)message);
                return this.createByteArrayFromBytesMessage((BytesMessage)message);
            }
            if (message instanceof StreamMessage) {
                LOG.trace("Extracting body as a StreamMessage from JMS message: {}", (Object)message);
                return message;
            }
            return null;
        }
        catch (JMSException e) {
            throw new RuntimeCamelException("Failed to extract body due to: " + e + ". Message: " + message, (Throwable)e);
        }
    }

    public Map<String, Object> extractHeadersFromJms(jakarta.jms.Message jmsMessage, Exchange exchange) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (jmsMessage != null) {
            Enumeration names;
            try {
                map.put("JMSCorrelationID", jmsMessage.getJMSCorrelationID());
                map.put("JMSCorrelationIDAsBytes", JmsMessageHelper.getJMSCorrelationIDAsBytes(jmsMessage));
                map.put("JMSDeliveryMode", jmsMessage.getJMSDeliveryMode());
                map.put("JMSDestination", jmsMessage.getJMSDestination());
                map.put("JMSExpiration", jmsMessage.getJMSExpiration());
                map.put("JMSMessageID", jmsMessage.getJMSMessageID());
                map.put("JMSPriority", jmsMessage.getJMSPriority());
                map.put("JMSRedelivered", jmsMessage.getJMSRedelivered());
                map.put("JMSTimestamp", jmsMessage.getJMSTimestamp());
                map.put("JMSReplyTo", JmsMessageHelper.getJMSReplyTo(jmsMessage));
                map.put("JMSType", JmsMessageHelper.getJMSType(jmsMessage));
                map.put("JMSXGroupID", JmsMessageHelper.getStringProperty(jmsMessage, "JMSXGroupID"));
                map.put("JMSXUserID", JmsMessageHelper.getStringProperty(jmsMessage, "JMSXUserID"));
            }
            catch (JMSException e) {
                throw new RuntimeCamelException((Throwable)e);
            }
            try {
                names = jmsMessage.getPropertyNames();
            }
            catch (JMSException e) {
                throw new RuntimeCamelException((Throwable)e);
            }
            while (names.hasMoreElements()) {
                String name = names.nextElement().toString();
                try {
                    Object value = JmsMessageHelper.getProperty(jmsMessage, name);
                    if (this.headerFilterStrategy != null && this.headerFilterStrategy.applyFilterToExternalHeaders(name, value, exchange)) continue;
                    String key = this.jmsJmsKeyFormatStrategy.decodeKey(name);
                    map.put(key, value);
                }
                catch (JMSException e) {
                    throw new RuntimeCamelException(name, (Throwable)e);
                }
            }
        }
        return map;
    }

    public Object getObjectProperty(jakarta.jms.Message jmsMessage, String name) throws JMSException {
        Object answer = jmsMessage.getObjectProperty(name);
        if (answer == null) {
            String key = this.jmsJmsKeyFormatStrategy.encodeKey(name);
            answer = jmsMessage.getObjectProperty(key);
        }
        return answer;
    }

    protected byte[] createByteArrayFromBytesMessage(BytesMessage message) throws JMSException {
        if (message.getBodyLength() > Integer.MAX_VALUE) {
            LOG.warn("Length of BytesMessage is too long: {}", (Object)message.getBodyLength());
            return null;
        }
        byte[] result = new byte[(int)message.getBodyLength()];
        message.readBytes(result);
        return result;
    }

    public jakarta.jms.Message makeJmsMessage(Exchange exchange, Message camelMessage, Session session, Exception cause) throws JMSException {
        jakarta.jms.Message answer;
        if (cause != null) {
            LOG.debug("Will create JmsMessage with caused exception: {}", (Object)cause.getMessage(), (Object)cause);
            answer = this.createJmsMessage(cause, session);
        } else {
            answer = this.createJmsMessage(exchange, camelMessage.getBody(), camelMessage.getHeaders(), session, exchange.getContext());
            this.appendJmsProperties(answer, exchange, camelMessage.getHeaders());
        }
        if (answer != null && this.messageCreatedStrategy != null) {
            this.messageCreatedStrategy.onMessageCreated(answer, session, exchange, null);
        }
        return answer;
    }

    public void appendJmsProperties(jakarta.jms.Message jmsMessage, Exchange exchange, Map<String, Object> headers) throws JMSException {
        if (headers != null) {
            Set<Map.Entry<String, Object>> entries = headers.entrySet();
            for (Map.Entry<String, Object> entry : entries) {
                String headerName = entry.getKey();
                Object headerValue = entry.getValue();
                this.appendJmsProperty(jmsMessage, exchange, headerName, headerValue);
            }
        }
    }

    public void appendJmsProperty(jakarta.jms.Message jmsMessage, Exchange exchange, String headerName, Object headerValue) throws JMSException {
        if (this.isStandardJMSHeader(headerName)) {
            if (headerName.equals("JMSCorrelationID")) {
                jmsMessage.setJMSCorrelationID((String)ExchangeHelper.convertToType((Exchange)exchange, String.class, (Object)headerValue));
            } else if (headerName.equals("JMSReplyTo") && headerValue != null) {
                if (headerValue instanceof String) {
                    headerValue = JmsMessageHelper.normalizeDestinationName((String)headerValue, true);
                }
                Destination replyTo = (Destination)ExchangeHelper.convertToType((Exchange)exchange, Destination.class, (Object)headerValue);
                JmsMessageHelper.setJMSReplyTo(jmsMessage, replyTo);
            } else if (headerName.equals("JMSType")) {
                jmsMessage.setJMSType((String)ExchangeHelper.convertToType((Exchange)exchange, String.class, (Object)headerValue));
            } else if (headerName.equals("JMSPriority")) {
                jmsMessage.setJMSPriority(((Integer)ExchangeHelper.convertToType((Exchange)exchange, Integer.class, (Object)headerValue)).intValue());
            } else if (headerName.equals("JMSDeliveryMode")) {
                JmsMessageHelper.setJMSDeliveryMode(exchange, jmsMessage, headerValue);
            } else if (headerName.equals("JMSExpiration")) {
                jmsMessage.setJMSExpiration(((Long)ExchangeHelper.convertToType((Exchange)exchange, Long.class, (Object)headerValue)).longValue());
            } else {
                LOG.trace("Ignoring JMS header: {} with value: {}", (Object)headerName, headerValue);
            }
        } else if (this.shouldOutputHeader(headerName, headerValue, exchange)) {
            Object value = this.getValidJMSHeaderValue(headerName, headerValue);
            if (value != null) {
                String key = this.jmsJmsKeyFormatStrategy.encodeKey(headerName);
                JmsMessageHelper.setProperty(jmsMessage, key, value);
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("Ignoring non primitive header: {} of class: {} with value: {}", new Object[]{headerName, headerValue.getClass().getName(), headerValue});
            }
        }
    }

    protected boolean isStandardJMSHeader(String headerName) {
        char fourth;
        if (!headerName.startsWith("JMS")) {
            return false;
        }
        if (headerName.startsWith("JMSX")) {
            return false;
        }
        if (headerName.startsWith("JMS_")) {
            return false;
        }
        return headerName.length() > 3 && Character.isLetter(fourth = headerName.charAt(3));
    }

    protected Object getValidJMSHeaderValue(String headerName, Object headerValue) {
        if (headerValue instanceof String) {
            return headerValue;
        }
        if (headerValue instanceof BigInteger) {
            return headerValue.toString();
        }
        if (headerValue instanceof BigDecimal) {
            return headerValue.toString();
        }
        if (headerValue instanceof Number) {
            return headerValue;
        }
        if (headerValue instanceof Character) {
            return headerValue;
        }
        if (headerValue instanceof CharSequence) {
            return headerValue.toString();
        }
        if (headerValue instanceof Boolean) {
            return headerValue;
        }
        if (headerValue instanceof Date) {
            return headerValue.toString();
        }
        return null;
    }

    protected jakarta.jms.Message createJmsMessage(Exception cause, Session session) throws JMSException {
        LOG.trace("Using JmsMessageType: {}", (Object)JmsMessageType.Object);
        ObjectMessage answer = session.createObjectMessage((Serializable)cause);
        answer.setJMSDeliveryMode(2);
        return answer;
    }

    protected jakarta.jms.Message createJmsMessage(Exchange exchange, Object body, Map<String, Object> headers, Session session, CamelContext context) throws JMSException {
        JmsMessageType type = this.getJMSMessageTypeForBody(exchange, body, headers, session, context);
        if (type != null) {
            if (body == null && !this.allowNullBody) {
                throw new JMSException("Cannot send message as message body is null, and option allowNullBody is false.");
            }
            LOG.trace("Using JmsMessageType: {}", (Object)type);
            jakarta.jms.Message answer = this.createJmsMessageForType(exchange, body, session, context, type);
            answer.setJMSDeliveryMode(2);
            return answer;
        }
        if (body == null && !this.allowNullBody) {
            throw new JMSException("Cannot send message as message body is null, and option allowNullBody is false.");
        }
        if (body != null && LOG.isWarnEnabled()) {
            LOG.warn("Cannot determine specific JmsMessage type to use from body class. Will use generic JmsMessage. Body class: {}. If you want to send a POJO then your class might need to implement java.io.Serializable, or you can force a specific type by setting the jmsMessageType option on the JMS endpoint.", (Object)ObjectHelper.classCanonicalName((Object)body));
        }
        jakarta.jms.Message answer = session.createMessage();
        answer.setJMSDeliveryMode(2);
        return answer;
    }

    protected JmsMessageType getJMSMessageTypeForBody(Exchange exchange, Object body, Map<String, Object> headers, Session session, CamelContext context) {
        JmsMessageType type = null;
        if (body instanceof Node || body instanceof String) {
            type = JmsMessageType.Text;
        } else if (body instanceof byte[] || body instanceof WrappedFile || body instanceof File || body instanceof Reader || body instanceof InputStream || body instanceof ByteBuffer || body instanceof StreamCache) {
            type = JmsMessageType.Bytes;
        } else if (body instanceof Map) {
            type = JmsMessageType.Map;
        } else if (body instanceof Serializable) {
            type = JmsMessageType.Object;
        } else if (exchange.getContext().getTypeConverter().tryConvertTo(File.class, body) != null || exchange.getContext().getTypeConverter().tryConvertTo(InputStream.class, body) != null) {
            type = JmsMessageType.Bytes;
        }
        return type;
    }

    protected jakarta.jms.Message createJmsMessageForType(Exchange exchange, Object body, Session session, CamelContext context, JmsMessageType type) throws JMSException {
        switch (type) {
            case Text: {
                TextMessage message = session.createTextMessage();
                if (body != null) {
                    String payload = (String)context.getTypeConverter().convertTo(String.class, exchange, body);
                    message.setText(payload);
                }
                return message;
            }
            case Bytes: {
                BytesMessage message = session.createBytesMessage();
                if (body != null) {
                    byte[] payload = (byte[])context.getTypeConverter().convertTo(byte[].class, exchange, body);
                    message.writeBytes(payload);
                }
                return message;
            }
            case Map: {
                MapMessage message = session.createMapMessage();
                if (body != null) {
                    Map payload = (Map)context.getTypeConverter().convertTo(Map.class, exchange, body);
                    this.populateMapMessage(message, payload, context);
                }
                return message;
            }
            case Object: {
                ObjectMessage message = session.createObjectMessage();
                if (body != null) {
                    try {
                        Serializable payload = (Serializable)context.getTypeConverter().mandatoryConvertTo(Serializable.class, exchange, body);
                        message.setObject(payload);
                    }
                    catch (NoTypeConversionAvailableException e) {
                        MessageFormatException cause = new MessageFormatException(e.getMessage());
                        cause.initCause((Throwable)e);
                        throw cause;
                    }
                }
                return message;
            }
        }
        return null;
    }

    protected void populateMapMessage(MapMessage message, Map<?, ?> map, CamelContext context) throws JMSException {
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            String keyString = (String)CamelContextHelper.convertTo((CamelContext)context, String.class, entry.getKey());
            if (keyString == null) continue;
            message.setObject(keyString, entry.getValue());
        }
    }

    public Map<String, Object> createMapFromMapMessage(MapMessage message) throws JMSException {
        HashMap<String, Object> answer = new HashMap<String, Object>();
        Enumeration names = message.getMapNames();
        while (names.hasMoreElements()) {
            String name = names.nextElement().toString();
            Object value = message.getObject(name);
            answer.put(name, value);
        }
        return answer;
    }

    protected boolean shouldOutputHeader(String headerName, Object headerValue, Exchange exchange) {
        return this.headerFilterStrategy == null || !this.headerFilterStrategy.applyFilterToCamelHeaders(headerName, headerValue, exchange);
    }
}

