/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sjms.reply;

import jakarta.jms.Destination;
import jakarta.jms.ExceptionListener;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.Session;
import jakarta.jms.TemporaryQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.CamelContext;
import org.apache.camel.component.sjms.MessageListenerContainer;
import org.apache.camel.component.sjms.jms.DestinationCreationStrategy;
import org.apache.camel.component.sjms.reply.ReplyHandler;
import org.apache.camel.component.sjms.reply.ReplyManagerSupport;
import org.apache.camel.component.sjms.reply.TemporaryQueueMessageListenerContainer;

public class TemporaryQueueReplyManager
extends ReplyManagerSupport {
    final TemporaryReplyQueueDestinationResolver destResolver = new TemporaryReplyQueueDestinationResolver();

    public TemporaryQueueReplyManager(CamelContext camelContext) {
        super(camelContext);
    }

    @Override
    public Destination getReplyTo() {
        try {
            this.destResolver.destinationReady();
        }
        catch (InterruptedException e) {
            this.log.warn("Interrupted while waiting for JMSReplyTo destination refresh", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        return super.getReplyTo();
    }

    @Override
    public void updateCorrelationId(String correlationId, String newCorrelationId, long requestTimeout) {
        this.log.trace("Updated provisional correlationId [{}] to expected correlationId [{}]", (Object)correlationId, (Object)newCorrelationId);
        ReplyHandler handler = (ReplyHandler)this.correlation.remove(correlationId);
        if (handler != null) {
            this.correlation.put(newCorrelationId, handler, requestTimeout);
        }
    }

    @Override
    protected void handleReplyMessage(String correlationID, Message message, Session session) {
        ReplyHandler handler = (ReplyHandler)this.correlation.get(correlationID);
        if (handler != null) {
            this.correlation.remove(correlationID);
            handler.onReply(correlationID, message, session);
        } else {
            this.log.warn("Reply received for unknown correlationID [{}]. The message will be ignored: {}", (Object)correlationID, (Object)message);
        }
    }

    @Override
    protected MessageListenerContainer createListenerContainer() throws Exception {
        TemporaryQueueMessageListenerContainer answer = new TemporaryQueueMessageListenerContainer(this.endpoint);
        answer.setMessageListener(this);
        Object clientId = this.endpoint.getClientId();
        if (clientId != null) {
            clientId = (String)clientId + ".CamelReplyManager";
            answer.setClientId((String)clientId);
        }
        answer.setConcurrentConsumers(this.endpoint.getReplyToConcurrentConsumers());
        answer.setExceptionListener(new TemporaryReplyQueueExceptionListener(this.destResolver));
        answer.setDestinationCreationStrategy(this.destResolver);
        answer.setDestinationName("temporary");
        return answer;
    }

    private final class TemporaryReplyQueueDestinationResolver
    implements DestinationCreationStrategy {
        private TemporaryQueue queue;
        private final AtomicBoolean refreshWanted = new AtomicBoolean();

        private TemporaryReplyQueueDestinationResolver() {
        }

        @Override
        public Destination createDestination(Session session, String name, boolean topic) throws JMSException {
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Destination createTemporaryDestination(Session session, boolean topic) throws JMSException {
            AtomicBoolean atomicBoolean = this.refreshWanted;
            synchronized (atomicBoolean) {
                if (this.queue == null || this.refreshWanted.get()) {
                    this.refreshWanted.set(false);
                    this.queue = session.createTemporaryQueue();
                    TemporaryQueueReplyManager.this.setReplyTo((Destination)this.queue);
                    if (TemporaryQueueReplyManager.this.log.isDebugEnabled()) {
                        TemporaryQueueReplyManager.this.log.debug("Refreshed Temporary ReplyTo Queue. New queue: {}", (Object)this.queue.getQueueName());
                    }
                    this.refreshWanted.notifyAll();
                }
            }
            return this.queue;
        }

        public void scheduleRefresh() {
            this.refreshWanted.set(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void destinationReady() throws InterruptedException {
            if (this.refreshWanted.get()) {
                AtomicBoolean atomicBoolean = this.refreshWanted;
                synchronized (atomicBoolean) {
                    if (this.refreshWanted.get()) {
                        TemporaryQueueReplyManager.this.log.debug("Waiting for new Temporary ReplyTo queue to be assigned before we can continue");
                        this.refreshWanted.wait();
                    }
                }
            }
        }
    }

    private final class TemporaryReplyQueueExceptionListener
    implements ExceptionListener {
        private final TemporaryReplyQueueDestinationResolver destResolver;

        private TemporaryReplyQueueExceptionListener(TemporaryReplyQueueDestinationResolver destResolver) {
            this.destResolver = destResolver;
        }

        public void onException(JMSException exception) {
            TemporaryQueueReplyManager.this.log.warn("Exception inside the DMLC for Temporary ReplyTo Queue for destination {}, refreshing ReplyTo destination", (Object)TemporaryQueueReplyManager.this.endpoint.getDestinationName(), (Object)exception);
            this.destResolver.scheduleRefresh();
        }
    }
}

