/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.slack;

import com.google.gson.Gson;
import com.slack.api.Slack;
import com.slack.api.SlackConfig;
import com.slack.api.model.ConversationType;
import com.slack.api.util.http.SlackHttpClient;
import com.slack.api.webhook.WebhookResponse;
import java.util.Collections;
import java.util.Map;
import org.apache.camel.component.extension.ComponentVerifierExtension;
import org.apache.camel.component.extension.verifier.DefaultComponentVerifierExtension;
import org.apache.camel.component.extension.verifier.ResultBuilder;
import org.apache.camel.component.extension.verifier.ResultErrorBuilder;
import org.apache.camel.component.slack.CustomSlackHttpClient;
import org.apache.camel.component.slack.helper.SlackHelper;
import org.apache.camel.component.slack.helper.SlackMessage;
import org.apache.camel.util.ObjectHelper;

public class SlackComponentVerifierExtension
extends DefaultComponentVerifierExtension {
    private static final Gson GSON = new Gson();

    public SlackComponentVerifierExtension() {
        this("slack");
    }

    public SlackComponentVerifierExtension(String scheme) {
        super(scheme);
    }

    protected ComponentVerifierExtension.Result verifyParameters(Map<String, Object> parameters) {
        ResultBuilder builder = ResultBuilder.withStatusAndScope((ComponentVerifierExtension.Result.Status)ComponentVerifierExtension.Result.Status.OK, (ComponentVerifierExtension.Scope)ComponentVerifierExtension.Scope.PARAMETERS);
        if (ObjectHelper.isEmpty((Object)parameters.get("token")) && ObjectHelper.isEmpty((Object)parameters.get("webhookUrl"))) {
            builder.error(ResultErrorBuilder.withCodeAndDescription((ComponentVerifierExtension.VerificationError.Code)ComponentVerifierExtension.VerificationError.StandardCode.GENERIC, (String)"You must specify a webhookUrl (for producer) or a token (for producer and consumer)").parameterKey("webhookUrl").parameterKey("token").build());
        }
        if (ObjectHelper.isNotEmpty((Object)parameters.get("token")) && ObjectHelper.isNotEmpty((Object)parameters.get("webhookUrl"))) {
            builder.error(ResultErrorBuilder.withCodeAndDescription((ComponentVerifierExtension.VerificationError.Code)ComponentVerifierExtension.VerificationError.StandardCode.GENERIC, (String)"You must specify a webhookUrl (for producer) or a token (for producer and consumer). You can't specify both.").parameterKey("webhookUrl").parameterKey("token").build());
        }
        return builder.build();
    }

    protected ComponentVerifierExtension.Result verifyConnectivity(Map<String, Object> parameters) {
        return ResultBuilder.withStatusAndScope((ComponentVerifierExtension.Result.Status)ComponentVerifierExtension.Result.Status.OK, (ComponentVerifierExtension.Scope)ComponentVerifierExtension.Scope.CONNECTIVITY).error(parameters, this::verifyCredentials).build();
    }

    private void verifyCredentials(ResultBuilder builder, Map<String, Object> parameters) {
        WebhookResponse response;
        SlackConfig config;
        String webhookUrl = (String)parameters.get("webhookUrl");
        String serverUrl = (String)parameters.get("serverUrl");
        if (ObjectHelper.isNotEmpty((Object)webhookUrl)) {
            try {
                SlackMessage slackMessage = new SlackMessage();
                slackMessage.setText("Test connection");
                config = SlackHelper.createSlackConfig(serverUrl);
                response = Slack.getInstance((SlackConfig)config, (SlackHttpClient)new CustomSlackHttpClient()).send(webhookUrl, GSON.toJson((Object)slackMessage));
                if (response.getCode() < 200 || response.getCode() > 299) {
                    builder.error(ResultErrorBuilder.withCodeAndDescription((ComponentVerifierExtension.VerificationError.Code)ComponentVerifierExtension.VerificationError.StandardCode.AUTHENTICATION, (String)"Invalid webhookUrl").parameterKey("webhookUrl").build());
                }
            }
            catch (Exception e) {
                builder.error(ResultErrorBuilder.withCodeAndDescription((ComponentVerifierExtension.VerificationError.Code)ComponentVerifierExtension.VerificationError.StandardCode.AUTHENTICATION, (String)"Invalid webhookUrl").parameterKey("webhookUrl").build());
            }
        }
        if (ObjectHelper.isNotEmpty((Object)parameters.get("token"))) {
            String token = (String)parameters.get("token");
            try {
                config = SlackHelper.createSlackConfig(serverUrl);
                response = Slack.getInstance((SlackConfig)config, (SlackHttpClient)new CustomSlackHttpClient()).methods(token).conversationsList(req -> req.types(Collections.singletonList(ConversationType.PUBLIC_CHANNEL)).limit(Integer.valueOf(1)));
                if (!response.isOk()) {
                    builder.error(ResultErrorBuilder.withCodeAndDescription((ComponentVerifierExtension.VerificationError.Code)ComponentVerifierExtension.VerificationError.StandardCode.AUTHENTICATION, (String)"Invalid token").parameterKey("token").build());
                }
            }
            catch (Exception e) {
                builder.error(ResultErrorBuilder.withCodeAndDescription((ComponentVerifierExtension.VerificationError.Code)ComponentVerifierExtension.VerificationError.StandardCode.AUTHENTICATION, (String)"Invalid token").parameterKey("token").build());
            }
        }
    }
}

