/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.smb.strategy;

import java.util.Map;
import java.util.function.Consumer;
import org.apache.camel.LoggingLevel;
import org.apache.camel.component.file.strategy.GenericFileRenameExclusiveReadLockStrategy;
import org.apache.camel.component.smb.strategy.SmbChangedExclusiveReadLockStrategy;

final class StrategyUtil {
    private StrategyUtil() {
    }

    static <T> void ifNotEmpty(Map<String, Object> params, String key, Class<T> clazz, Consumer<T> consumer) {
        Object o = params.get(key);
        if (o != null) {
            consumer.accept(clazz.cast(o));
        }
    }

    static void setup(GenericFileRenameExclusiveReadLockStrategy<?> readLockStrategy, Map<String, Object> params) {
        StrategyUtil.ifNotEmpty(params, "readLockTimeout", Long.class, arg_0 -> readLockStrategy.setTimeout(arg_0));
        StrategyUtil.ifNotEmpty(params, "readLockCheckInterval", Long.class, arg_0 -> readLockStrategy.setCheckInterval(arg_0));
        StrategyUtil.ifNotEmpty(params, "readLockMarkerFile", Boolean.class, arg_0 -> readLockStrategy.setMarkerFiler(arg_0));
        StrategyUtil.ifNotEmpty(params, "readLockLoggingLevel", LoggingLevel.class, arg_0 -> readLockStrategy.setReadLockLoggingLevel(arg_0));
    }

    static void setup(SmbChangedExclusiveReadLockStrategy readLockStrategy, Map<String, Object> params) {
        StrategyUtil.ifNotEmpty(params, "readLockTimeout", Long.class, readLockStrategy::setTimeout);
        StrategyUtil.ifNotEmpty(params, "readLockCheckInterval", Long.class, readLockStrategy::setCheckInterval);
        StrategyUtil.ifNotEmpty(params, "readLockMinLength", Long.class, readLockStrategy::setMinLength);
        StrategyUtil.ifNotEmpty(params, "readLockMinAge", Long.class, readLockStrategy::setMinAge);
        StrategyUtil.ifNotEmpty(params, "readLockMarkerFile", Boolean.class, readLockStrategy::setMarkerFiler);
        StrategyUtil.ifNotEmpty(params, "readLockLoggingLevel", LoggingLevel.class, readLockStrategy::setReadLockLoggingLevel);
    }
}

