/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.smb;

import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.component.smb.SmbEndpoint;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;

@Component(value="smb")
public class SmbComponent
extends DefaultComponent {
    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        if (ObjectHelper.isEmpty((String)remaining)) {
            throw new IllegalArgumentException("Host IP or address must be configured on endpoint using syntax smb:host:port");
        }
        SmbEndpoint endpoint = new SmbEndpoint(uri, this);
        String hostPart = StringHelper.before((String)remaining, (String)"/");
        if (hostPart != null && hostPart.contains(":")) {
            SmbComponent.parseHost(hostPart, endpoint);
        } else {
            endpoint.setHostname(hostPart);
        }
        String path = StringHelper.after((String)remaining, (String)"/");
        this.setProperties((Endpoint)endpoint, parameters);
        endpoint.setShareName(path);
        return endpoint;
    }

    private static void parseHost(String hostPart, SmbEndpoint endpoint) {
        String host = StringHelper.before((String)hostPart, (String)":");
        if (ObjectHelper.isEmpty((String)host)) {
            throw new IllegalArgumentException("Invalid host or address: " + hostPart);
        }
        endpoint.setHostname(host);
        String port = StringHelper.after((String)hostPart, (String)":");
        if (ObjectHelper.isEmpty((String)port)) {
            throw new IllegalArgumentException("Invalid port given on host: " + hostPart);
        }
        endpoint.setPort(Integer.parseInt(port));
    }
}

