/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.smpp;

import java.time.Duration;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.camel.Endpoint;
import org.apache.camel.spi.ExecutorServiceManager;
import org.apache.camel.support.service.BaseService;
import org.apache.camel.support.task.BlockingTask;
import org.apache.camel.support.task.Tasks;
import org.apache.camel.support.task.budget.Budgets;
import org.apache.camel.support.task.budget.TimeBudget;
import org.jsmpp.bean.Alphabet;
import org.jsmpp.bean.DataSm;
import org.jsmpp.bean.SubmitMulti;
import org.jsmpp.bean.SubmitSm;
import org.jsmpp.extra.SessionState;
import org.jsmpp.session.SMPPSession;
import org.jsmpp.util.AbsoluteTimeFormatter;
import org.jsmpp.util.TimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SmppUtils {
    public static final short[] ISO_GSM_0338 = new short[]{64, 163, 36, 165, 232, 233, 249, 236, 242, 199, 10, 216, 248, 13, 197, 229, 0, 95, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 198, 230, 223, 201, 32, 33, 34, 35, 164, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 161, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 196, 214, 209, 220, 167, 191, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 228, 246, 241, 252, 224};
    public static final short[][] ISO_GSM_0338_EXT = new short[][]{{10, 12}, {20, 94}, {40, 123}, {41, 125}, {47, 92}, {60, 91}, {61, 126}, {62, 93}, {64, 124}, {101, 164}};
    private static final Logger LOG = LoggerFactory.getLogger(SmppUtils.class);
    private static final TimeFormatter TIME_FORMATTER = new AbsoluteTimeFormatter();

    private SmppUtils() {
    }

    public static String formatTime(Date date) {
        return TIME_FORMATTER.format(date);
    }

    public static Date string2Date(String date) {
        if (date == null) {
            return null;
        }
        int year = Integer.parseInt(date.substring(0, 2));
        int month = Integer.parseInt(date.substring(2, 4));
        int day = Integer.parseInt(date.substring(4, 6));
        int hour = Integer.parseInt(date.substring(6, 8));
        int minute = Integer.parseInt(date.substring(8, 10));
        int second = Integer.parseInt(date.substring(10, 12));
        Calendar cal = Calendar.getInstance();
        cal.set(SmppUtils.convertTwoDigitYear(year), month - 1, day, hour, minute, second);
        cal.set(14, 0);
        return cal.getTime();
    }

    private static int convertTwoDigitYear(int year) {
        if (year >= 0 && year <= 37) {
            return 2000 + year;
        }
        if (year >= 38 && year <= 99) {
            return 1900 + year;
        }
        return year;
    }

    public static boolean is8Bit(Alphabet alphabet) {
        return alphabet == Alphabet.ALPHA_UNSPECIFIED_2 || alphabet == Alphabet.ALPHA_8_BIT;
    }

    public static boolean isGsm0338Encodeable(byte[] aMessage) {
        block0: for (int i = 0; i < aMessage.length; ++i) {
            int j;
            for (j = 0; j < ISO_GSM_0338.length; ++j) {
                if (ISO_GSM_0338[j] == aMessage[i]) continue block0;
            }
            for (j = 0; j < ISO_GSM_0338_EXT.length; ++j) {
                if (ISO_GSM_0338_EXT[j][1] == aMessage[i]) continue block0;
            }
            return false;
        }
        return true;
    }

    public static SubmitSm copySubmitSm(SubmitSm src) {
        SubmitSm dest = new SubmitSm();
        dest.setCommandId(src.getCommandId());
        dest.setCommandLength(src.getCommandLength());
        dest.setCommandStatus(src.getCommandStatus());
        dest.setDataCoding(src.getDataCoding());
        dest.setDestAddress(src.getDestAddress());
        dest.setDestAddrNpi(src.getDestAddrNpi());
        dest.setDestAddrTon(src.getDestAddrTon());
        dest.setEsmClass(src.getEsmClass());
        dest.setOptionalParameters(src.getOptionalParameters());
        dest.setPriorityFlag(src.getPriorityFlag());
        dest.setProtocolId(src.getProtocolId());
        dest.setRegisteredDelivery(src.getRegisteredDelivery());
        dest.setReplaceIfPresent(src.getReplaceIfPresent());
        dest.setScheduleDeliveryTime(src.getScheduleDeliveryTime());
        dest.setSequenceNumber(src.getSequenceNumber());
        dest.setServiceType(src.getServiceType());
        dest.setShortMessage(src.getShortMessage());
        dest.setSmDefaultMsgId(src.getSmDefaultMsgId());
        dest.setSourceAddr(src.getSourceAddr());
        dest.setSourceAddrNpi(src.getSourceAddrNpi());
        dest.setSourceAddrTon(src.getSourceAddrTon());
        dest.setValidityPeriod(src.getValidityPeriod());
        if (src.isDatagramMode()) {
            dest.setDatagramMode();
        }
        if (src.isDefaultMessageType()) {
            dest.setDefaultMessageType();
        }
        if (src.isDefaultMode()) {
            dest.setDefaultMode();
        }
        if (src.isEsmeDeliveryAcknowledgement()) {
            dest.setEsmeDeliveryAcknowledgement();
        }
        if (src.isEsmeManualAcknowledgement()) {
            dest.setEsmeManualAcknowledgement();
        }
        if (src.isForwardMode()) {
            dest.setForwardMode();
        }
        if (src.isReplyPath()) {
            dest.setReplyPath();
        }
        if (src.isSmscDelReceiptFailureRequested()) {
            dest.setSmscDelReceiptFailureRequested();
        }
        if (src.isSmscDelReceiptNotRequested()) {
            dest.setSmscDelReceiptNotRequested();
        }
        if (src.isSmscDelReceiptSuccessAndFailureRequested()) {
            dest.setSmscDelReceiptSuccessAndFailureRequested();
        }
        if (src.isStoreAndForwardMode()) {
            dest.setStoreAndForwardMode();
        }
        if (src.isUdhi()) {
            dest.setUdhi();
        }
        if (src.isUdhiAndReplyPath()) {
            dest.setUdhiAndReplyPath();
        }
        return dest;
    }

    public static SubmitMulti copySubmitMulti(SubmitMulti src) {
        SubmitMulti dest = new SubmitMulti();
        dest.setCommandId(src.getCommandId());
        dest.setCommandLength(src.getCommandLength());
        dest.setCommandStatus(src.getCommandStatus());
        dest.setDataCoding(src.getDataCoding());
        dest.setDestAddresses(src.getDestAddresses());
        dest.setEsmClass(src.getEsmClass());
        dest.setOptionalParameters(src.getOptionalParameters());
        dest.setPriorityFlag(src.getPriorityFlag());
        dest.setProtocolId(src.getProtocolId());
        dest.setRegisteredDelivery(src.getRegisteredDelivery());
        dest.setReplaceIfPresentFlag(src.getReplaceIfPresentFlag());
        dest.setScheduleDeliveryTime(src.getScheduleDeliveryTime());
        dest.setSequenceNumber(src.getSequenceNumber());
        dest.setServiceType(src.getServiceType());
        dest.setShortMessage(src.getShortMessage());
        dest.setSmDefaultMsgId(src.getSmDefaultMsgId());
        dest.setSourceAddr(src.getSourceAddr());
        dest.setSourceAddrNpi(src.getSourceAddrNpi());
        dest.setSourceAddrTon(src.getSourceAddrTon());
        dest.setValidityPeriod(src.getValidityPeriod());
        return dest;
    }

    public static DataSm copyDataSm(DataSm src) {
        DataSm dest = new DataSm();
        dest.setCommandId(src.getCommandId());
        dest.setCommandLength(src.getCommandLength());
        dest.setCommandStatus(src.getCommandStatus());
        dest.setDataCoding(src.getDataCoding());
        dest.setDestAddress(src.getDestAddress());
        dest.setDestAddrNpi(src.getDestAddrNpi());
        dest.setDestAddrTon(src.getDestAddrTon());
        dest.setEsmClass(src.getEsmClass());
        dest.setOptionalParameters(src.getOptionalParameters());
        dest.setRegisteredDelivery(src.getRegisteredDelivery());
        dest.setSequenceNumber(src.getSequenceNumber());
        dest.setServiceType(src.getServiceType());
        dest.setSourceAddr(src.getSourceAddr());
        dest.setSourceAddrNpi(src.getSourceAddrNpi());
        dest.setSourceAddrTon(src.getSourceAddrTon());
        if (src.isDefaultMessageType()) {
            dest.setDefaultMessageType();
        }
        if (src.isReplyPath()) {
            dest.setReplyPath();
        }
        if (src.isUdhi()) {
            dest.setUdhi();
        }
        if (src.isUdhiAndReplyPath()) {
            dest.setUdhiAndReplyPath();
        }
        return dest;
    }

    public static boolean isServiceStopping(BaseService service) {
        return service.isStopping() || service.isStopped();
    }

    public static boolean isSessionClosed(SMPPSession session) {
        return session == null || session.getSessionState().equals((Object)SessionState.CLOSED);
    }

    public static ScheduledExecutorService createExecutor(BaseService service, Endpoint endpoint, String taskName) {
        if (endpoint.getCamelContext() != null && endpoint.getCamelContext().getExecutorServiceManager() != null) {
            ExecutorServiceManager manager = endpoint.getCamelContext().getExecutorServiceManager();
            return manager.newSingleThreadScheduledExecutor((Object)service, taskName);
        }
        LOG.warn("Not using the Camel scheduled thread executor");
        return Executors.newSingleThreadScheduledExecutor();
    }

    public static BlockingTask newReconnectTask(ScheduledExecutorService service, String taskName, long initialReconnectDelay, long reconnectDelay, int maxReconnect) {
        return (BlockingTask)Tasks.backgroundTask().withBudget((TimeBudget)Budgets.iterationTimeBudget().withInitialDelay(Duration.ofMillis(initialReconnectDelay)).withMaxIterations(maxReconnect).withUnlimitedDuration().withInterval(Duration.ofMillis(reconnectDelay)).build()).withScheduledExecutor(service).withName(taskName).build();
    }

    public static void shutdownReconnectService(ScheduledExecutorService service) throws InterruptedException {
        service.shutdown();
        if (!service.awaitTermination(1L, TimeUnit.SECONDS)) {
            LOG.warn("The reconnect service did not finish executing within the timeout");
            service.shutdownNow();
        }
    }
}

