/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.smpp;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.component.smpp.SmppConfiguration;
import org.apache.camel.component.smpp.SmppUtils;
import org.apache.camel.support.DefaultMessage;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.util.ObjectHelper;
import org.jsmpp.bean.AlertNotification;
import org.jsmpp.bean.Alphabet;
import org.jsmpp.bean.Command;
import org.jsmpp.bean.DataSm;
import org.jsmpp.bean.DeliverSm;
import org.jsmpp.bean.MessageRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmppMessage
extends DefaultMessage {
    private static final Logger LOG = LoggerFactory.getLogger(SmppMessage.class);
    private Command command;
    private SmppConfiguration configuration;

    public SmppMessage(CamelContext camelContext, Command command, SmppConfiguration configuration) {
        super(camelContext);
        this.command = command;
        this.configuration = configuration;
    }

    public SmppMessage newInstance() {
        SmppMessage answer = new SmppMessage(this.getCamelContext(), null, this.configuration);
        return answer;
    }

    public boolean isAlertNotification() {
        return this.command instanceof AlertNotification;
    }

    public boolean isDataSm() {
        return this.command instanceof DataSm;
    }

    public boolean isDeliverSm() {
        return this.command instanceof DeliverSm && !((DeliverSm)this.command).isSmscDeliveryReceipt();
    }

    public boolean isDeliveryReceipt() {
        return this.command instanceof DeliverSm && ((DeliverSm)this.command).isSmscDeliveryReceipt();
    }

    protected Object createBody() {
        if (this.command instanceof MessageRequest) {
            MessageRequest msgRequest = (MessageRequest)this.command;
            byte[] shortMessage = msgRequest.getShortMessage();
            if (shortMessage == null || shortMessage.length == 0) {
                return null;
            }
            Alphabet alphabet = Alphabet.parseDataCoding((byte)msgRequest.getDataCoding());
            if (SmppUtils.is8Bit(alphabet)) {
                return shortMessage;
            }
            String encoding = ExchangeHelper.getCharsetName((Exchange)this.getExchange(), (boolean)false);
            if (ObjectHelper.isEmpty((String)encoding) || !Charset.isSupported(encoding)) {
                encoding = this.configuration.getEncoding();
            }
            try {
                return new String(shortMessage, encoding);
            }
            catch (UnsupportedEncodingException e) {
                LOG.info("Unsupported encoding \"{}\". Using system default encoding.", (Object)encoding);
                return new String(shortMessage);
            }
        }
        return null;
    }

    public String toString() {
        if (this.command != null) {
            return "SmppMessage: " + this.command;
        }
        return "SmppMessage: " + this.getBody();
    }

    public Command getCommand() {
        return this.command;
    }
}

