/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.smpp;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.component.smpp.SmppConsumer;
import org.apache.camel.component.smpp.SmppEndpoint;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.support.LoggingExceptionHandler;
import org.jsmpp.bean.AlertNotification;
import org.jsmpp.bean.DataSm;
import org.jsmpp.bean.DeliverSm;
import org.jsmpp.extra.ProcessRequestException;
import org.jsmpp.session.DataSmResult;
import org.jsmpp.session.MessageReceiverListener;
import org.jsmpp.session.Session;
import org.jsmpp.util.MessageIDGenerator;
import org.jsmpp.util.MessageId;
import org.jsmpp.util.RandomMessageIDGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageReceiverListenerImpl
implements MessageReceiverListener {
    private static final Logger LOG = LoggerFactory.getLogger(MessageReceiverListenerImpl.class);
    private MessageIDGenerator messageIDGenerator = new RandomMessageIDGenerator();
    private Consumer consumer;
    private SmppEndpoint endpoint;
    private Processor processor;
    private ExceptionHandler exceptionHandler;
    private final CountDownLatch initialized = new CountDownLatch(1);

    public MessageReceiverListenerImpl(SmppConsumer consumer, SmppEndpoint endpoint, Processor processor, ExceptionHandler exceptionHandler) {
        this.consumer = consumer;
        this.endpoint = endpoint;
        this.processor = processor;
        this.exceptionHandler = exceptionHandler;
        this.initialized.countDown();
    }

    public MessageReceiverListenerImpl(SmppEndpoint endpoint, String messageReceiverRouteId) throws Exception {
        this.endpoint = endpoint;
        this.endpoint.getCamelContext().addStartupListener((context, alreadyStarted) -> {
            Route route = context.getRoute(messageReceiverRouteId);
            if (route == null) {
                throw new IllegalArgumentException("No route with id '" + messageReceiverRouteId + "' found!");
            }
            this.consumer = route.getConsumer();
            this.processor = this.consumer.getProcessor();
            this.exceptionHandler = new LoggingExceptionHandler(endpoint.getCamelContext(), this.getClass());
            this.initialized.countDown();
        });
    }

    public void onAcceptAlertNotification(AlertNotification alertNotification) {
        try {
            this.initialized.await(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        LOG.debug("Received an alertNotification {}", (Object)alertNotification);
        Exchange exchange = this.createOnAcceptAlertNotificationExchange(alertNotification);
        try {
            this.processor.process(exchange);
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
        }
        if (exchange.getException() != null) {
            this.exceptionHandler.handleException("Cannot process exchange. This exception will be ignored.", exchange, (Throwable)exchange.getException());
        }
        this.consumer.releaseExchange(exchange, false);
    }

    public void onAcceptDeliverSm(DeliverSm deliverSm) throws ProcessRequestException {
        Exchange exchange;
        try {
            this.initialized.await(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        LOG.debug("Received a deliverSm {}", (Object)deliverSm);
        try {
            exchange = this.endpoint.createOnAcceptDeliverSmExchange(deliverSm);
        }
        catch (Exception e) {
            this.exceptionHandler.handleException("Cannot create exchange. This exception will be ignored.", (Throwable)e);
            return;
        }
        try {
            this.processor.process(exchange);
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
        }
        if (exchange.getException() != null) {
            ProcessRequestException pre = (ProcessRequestException)exchange.getException(ProcessRequestException.class);
            if (pre == null) {
                pre = new ProcessRequestException(exchange.getException().getMessage(), 255, (Throwable)exchange.getException());
            }
            throw pre;
        }
    }

    public DataSmResult onAcceptDataSm(DataSm dataSm, Session session) throws ProcessRequestException {
        try {
            this.initialized.await(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        LOG.debug("Received a dataSm {}", (Object)dataSm);
        MessageId newMessageId = this.messageIDGenerator.newMessageId();
        Exchange exchange = this.endpoint.createOnAcceptDataSm(dataSm, newMessageId.getValue());
        try {
            this.processor.process(exchange);
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
        }
        if (exchange.getException() != null) {
            ProcessRequestException pre = (ProcessRequestException)exchange.getException(ProcessRequestException.class);
            if (pre == null) {
                pre = new ProcessRequestException(exchange.getException().getMessage(), 255, (Throwable)exchange.getException());
            }
            throw pre;
        }
        return new DataSmResult(newMessageId, dataSm.getOptionalParameters());
    }

    public void setMessageIDGenerator(MessageIDGenerator messageIDGenerator) {
        this.messageIDGenerator = messageIDGenerator;
    }

    public Exchange createOnAcceptAlertNotificationExchange(AlertNotification alertNotification) {
        Exchange exchange = this.consumer.createExchange(false);
        exchange.setProperty("CamelBinding", (Object)this.endpoint.getBinding());
        exchange.setIn((Message)this.endpoint.getBinding().createSmppMessage(this.endpoint.getCamelContext(), alertNotification));
        return exchange;
    }
}

