/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.solr;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.activation.MimetypesFileTypeMap;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.WrappedFile;
import org.apache.camel.component.solr.SolrConfiguration;
import org.apache.camel.component.solr.SolrEndpoint;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.beans.DocumentObjectBinder;
import org.apache.solr.client.solrj.request.AbstractUpdateRequest;
import org.apache.solr.client.solrj.request.ContentStreamUpdateRequest;
import org.apache.solr.client.solrj.request.DirectXmlRequest;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;

public class SolrProducer
extends DefaultProducer {
    public SolrProducer(SolrEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public void process(Exchange exchange) throws Exception {
        UpdateRequest updateRequest;
        String operation = (String)exchange.getIn().getHeader("SolrOperation");
        if (operation == null) {
            throw new IllegalArgumentException("SolrOperation header is missing");
        }
        SolrConfiguration solrConfiguration = this.getEndpoint().getSolrConfiguration(operation);
        SolrClient solrClient = (SolrClient)exchange.getIn().getHeader("CamelSolrClient", SolrClient.class);
        if (solrClient == null) {
            solrClient = this.getEndpoint().getComponent().getSolrClient(this, solrConfiguration);
        }
        ModifiableSolrParams solrParams = new ModifiableSolrParams();
        for (Map.Entry entry : exchange.getIn().getHeaders().entrySet()) {
            if (!((String)entry.getKey()).startsWith("SolrParam.")) continue;
            String paramName = ((String)entry.getKey()).substring("SolrParam.".length());
            solrParams.add(paramName, new String[]{entry.getValue().toString()});
        }
        String solrCollection = (String)exchange.getIn().getHeader("CamelSolrCollection", String.class);
        if (operation.equalsIgnoreCase("INSERT")) {
            this.insert(exchange, solrClient, solrConfiguration, solrParams);
            if (solrConfiguration.isAutoCommit()) {
                this.commit(exchange, solrClient, solrConfiguration, solrParams);
            }
        } else if (operation.equalsIgnoreCase("INSERT_STREAMING")) {
            this.insert(exchange, solrClient, solrConfiguration, solrParams);
            if (solrConfiguration.isAutoCommit()) {
                this.commit(exchange, solrClient, solrConfiguration, solrParams);
            }
        } else if (operation.equalsIgnoreCase("DELETE_BY_ID")) {
            updateRequest = this.createUpdateRequest(solrConfiguration, solrParams);
            updateRequest.deleteById((String)exchange.getIn().getBody(String.class));
            updateRequest.process(solrClient, solrCollection);
            if (solrConfiguration.isAutoCommit()) {
                this.commit(exchange, solrClient, solrConfiguration, solrParams);
            }
        } else if (operation.equalsIgnoreCase("DELETE_BY_QUERY")) {
            updateRequest = this.createUpdateRequest(solrConfiguration, solrParams);
            updateRequest.deleteByQuery((String)exchange.getIn().getBody(String.class));
            updateRequest.process(solrClient, solrCollection);
            if (solrConfiguration.isAutoCommit()) {
                this.commit(exchange, solrClient, solrConfiguration, solrParams);
            }
        } else if (operation.equalsIgnoreCase("ADD_BEAN")) {
            updateRequest = this.createUpdateRequest(solrConfiguration, solrParams);
            updateRequest.add(solrClient.getBinder().toSolrInputDocument(exchange.getIn().getBody()));
            updateRequest.process(solrClient, solrCollection);
            if (solrConfiguration.isAutoCommit()) {
                this.commit(exchange, solrClient, solrConfiguration, solrParams);
            }
        } else if (operation.equalsIgnoreCase("ADD_BEANS")) {
            updateRequest = this.createUpdateRequest(solrConfiguration, solrParams);
            Collection body = (Collection)exchange.getIn().getBody(Collection.class);
            updateRequest.add((Collection)body.stream().map(arg_0 -> ((DocumentObjectBinder)solrClient.getBinder()).toSolrInputDocument(arg_0)).collect(Collectors.toList()));
            updateRequest.process(solrClient, solrCollection);
            if (solrConfiguration.isAutoCommit()) {
                this.commit(exchange, solrClient, solrConfiguration, solrParams);
            }
        } else if (operation.equalsIgnoreCase("COMMIT")) {
            this.commit(exchange, solrClient, solrConfiguration, solrParams);
        } else if (operation.equalsIgnoreCase("SOFT_COMMIT")) {
            this.commit(exchange, solrClient, solrConfiguration, solrParams, true);
        } else if (operation.equalsIgnoreCase("ROLLBACK")) {
            updateRequest = this.createUpdateRequest(solrConfiguration, solrParams);
            updateRequest.rollback();
            updateRequest.process(solrClient, solrCollection);
            if (solrConfiguration.isAutoCommit()) {
                this.commit(exchange, solrClient, solrConfiguration, solrParams);
            }
        } else if (operation.equalsIgnoreCase("OPTIMIZE")) {
            updateRequest = this.createUpdateRequest(solrConfiguration, solrParams);
            updateRequest.setAction(AbstractUpdateRequest.ACTION.OPTIMIZE, true, true, 1);
            updateRequest.process(solrClient, solrCollection);
            if (solrConfiguration.isAutoCommit()) {
                this.commit(exchange, solrClient, solrConfiguration, solrParams);
            }
        } else if (operation.equalsIgnoreCase("QUERY")) {
            this.query(exchange, solrClient, solrConfiguration, solrParams);
        } else {
            throw new IllegalArgumentException("SolrOperation header value '" + operation + "' is not supported");
        }
    }

    private void commit(Exchange exchange, SolrClient solrClient, SolrConfiguration solrConfiguration, ModifiableSolrParams solrParams) throws SolrServerException, IOException {
        this.commit(exchange, solrClient, solrConfiguration, solrParams, false);
    }

    private void commit(Exchange exchange, SolrClient solrClient, SolrConfiguration solrConfiguration, ModifiableSolrParams solrParams, boolean softCommit) throws SolrServerException, IOException {
        String solrCollection = (String)exchange.getIn().getHeader("CamelSolrCollection", String.class);
        UpdateRequest updateRequest = this.createUpdateRequest(solrConfiguration, solrParams);
        updateRequest.setAction(AbstractUpdateRequest.ACTION.COMMIT, solrParams.getBool("waitFlush", true), solrParams.getBool("waitSearcher", true), softCommit);
        updateRequest.process(solrClient, solrCollection);
    }

    private void query(Exchange exchange, SolrClient solrClient, SolrConfiguration solrConfiguration, ModifiableSolrParams solrParams) throws SolrServerException, IOException {
        String solrCollection = (String)exchange.getIn().getHeader("CamelSolrCollection", String.class);
        SolrQuery solrQuery = new SolrQuery();
        if (!ObjectHelper.isNotEmpty((Object)exchange.getMessage().getHeader("CamelSolrQueryString"))) {
            throw new IllegalArgumentException("Query String needs to be set as header while querying Solr");
        }
        solrQuery.setQuery((String)exchange.getMessage().getHeader("CamelSolrQueryString", String.class));
        solrQuery.add((SolrParams)solrParams);
        QueryRequest queryRequest = new QueryRequest((SolrParams)solrQuery);
        queryRequest.setBasicAuthCredentials(solrConfiguration.getUsername(), solrConfiguration.getPassword());
        QueryResponse p = (QueryResponse)queryRequest.process(solrClient, solrCollection);
        exchange.getMessage().setBody((Object)p.getResults());
    }

    private void insert(Exchange exchange, SolrClient solrClient, SolrConfiguration solrConfiguration, ModifiableSolrParams solrParams) throws Exception {
        String solrCollection = (String)exchange.getIn().getHeader("CamelSolrCollection", String.class);
        Object body = exchange.getIn().getBody();
        boolean invalid = false;
        if (body instanceof WrappedFile) {
            body = ((WrappedFile)body).getFile();
        }
        if (ObjectHelper.isNotEmpty((String)((String)exchange.getIn().getHeader("Content-Type", String.class)))) {
            String mimeType = (String)exchange.getIn().getHeader("Content-Type", String.class);
            ContentStreamUpdateRequest updateRequest = new ContentStreamUpdateRequest(this.getRequestHandler(solrConfiguration));
            updateRequest.setParams(solrParams);
            updateRequest.setBasicAuthCredentials(solrConfiguration.getUsername(), solrConfiguration.getPassword());
            updateRequest.addFile((File)body, mimeType);
            updateRequest.process(solrClient, solrCollection);
        } else if (body instanceof File) {
            MimetypesFileTypeMap mimeTypesMap = new MimetypesFileTypeMap();
            String mimeType = mimeTypesMap.getContentType((File)body);
            ContentStreamUpdateRequest updateRequest = new ContentStreamUpdateRequest(this.getRequestHandler(solrConfiguration));
            updateRequest.setParams(solrParams);
            updateRequest.setBasicAuthCredentials(solrConfiguration.getUsername(), solrConfiguration.getPassword());
            updateRequest.addFile((File)body, mimeType);
            updateRequest.process(solrClient, solrCollection);
        } else if (body instanceof SolrInputDocument) {
            UpdateRequest updateRequest = this.createUpdateRequest(solrConfiguration, solrParams);
            updateRequest.add((SolrInputDocument)body);
            updateRequest.process(solrClient, solrCollection);
        } else if (body instanceof List) {
            List list = (List)body;
            if (!list.isEmpty() && list.get(0) instanceof SolrInputDocument) {
                UpdateRequest updateRequest = this.createUpdateRequest(solrConfiguration, solrParams);
                updateRequest.add((Collection)list);
                updateRequest.process(solrClient, solrCollection);
            } else {
                invalid = true;
            }
        } else {
            SolrInputDocument doc;
            UpdateRequest updateRequest;
            boolean hasSolrHeaders = false;
            for (Map.Entry entry : exchange.getIn().getHeaders().entrySet()) {
                if (!((String)entry.getKey()).startsWith("SolrField.")) continue;
                hasSolrHeaders = true;
                break;
            }
            if (hasSolrHeaders) {
                updateRequest = this.createUpdateRequest(solrConfiguration, solrParams);
                doc = new SolrInputDocument(new String[0]);
                for (Map.Entry entry : exchange.getIn().getHeaders().entrySet()) {
                    if (!((String)entry.getKey()).startsWith("SolrField.")) continue;
                    String fieldName = ((String)entry.getKey()).substring("SolrField.".length());
                    doc.setField(fieldName, entry.getValue());
                }
                updateRequest.add(doc);
                updateRequest.process(solrClient, solrCollection);
            } else if (body instanceof String) {
                Object bodyAsString = (String)body;
                if (!((String)bodyAsString).startsWith("<add")) {
                    bodyAsString = "<add>" + (String)bodyAsString + "</add>";
                }
                DirectXmlRequest xmlRequest = new DirectXmlRequest(this.getRequestHandler(solrConfiguration), (String)bodyAsString);
                xmlRequest.setParams((SolrParams)solrParams);
                xmlRequest.setBasicAuthCredentials(solrConfiguration.getUsername(), solrConfiguration.getPassword());
                xmlRequest.process(solrClient, solrCollection);
            } else if (body instanceof Map) {
                updateRequest = this.createUpdateRequest(solrConfiguration, solrParams);
                doc = new SolrInputDocument(new String[0]);
                Map bodyMap = (Map)body;
                for (Map.Entry entry : bodyMap.entrySet()) {
                    doc.setField((String)entry.getKey(), entry.getValue());
                }
                updateRequest.add(doc);
                updateRequest.process(solrClient, solrCollection);
            } else {
                invalid = true;
            }
        }
        if (invalid) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "unable to find data in Exchange to update Solr");
        }
    }

    private String getRequestHandler(SolrConfiguration solrConfiguration) {
        String requestHandler = solrConfiguration.getRequestHandler();
        return requestHandler == null ? "/update" : requestHandler;
    }

    private UpdateRequest createUpdateRequest(SolrConfiguration solrConfiguration, ModifiableSolrParams solrParams) {
        UpdateRequest updateRequest = new UpdateRequest(this.getRequestHandler(solrConfiguration));
        updateRequest.setParams(solrParams);
        updateRequest.setBasicAuthCredentials(solrConfiguration.getUsername(), solrConfiguration.getPassword());
        return updateRequest;
    }

    public SolrEndpoint getEndpoint() {
        return (SolrEndpoint)super.getEndpoint();
    }

    protected void doShutdown() throws Exception {
        this.getEndpoint().onProducerShutdown(this);
    }
}

