/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.solr;

import java.util.List;
import java.util.Optional;
import org.apache.camel.component.solr.SolrClientHandler;
import org.apache.camel.component.solr.SolrConfiguration;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.impl.CloudSolrClient;

public class SolrClientHandlerCloud
extends SolrClientHandler {
    public SolrClientHandlerCloud(SolrConfiguration solrConfiguration) {
        super(solrConfiguration);
    }

    @Override
    protected SolrClient getSolrClient() {
        Optional<String> zkChrootOptional = Optional.ofNullable(this.solrConfiguration.getZkChroot());
        List<String> urlList = SolrClientHandlerCloud.getUrlListFrom(this.solrConfiguration);
        CloudSolrClient.Builder builder = new CloudSolrClient.Builder(urlList, zkChrootOptional);
        if (this.solrConfiguration.getConnectionTimeout() != null) {
            builder.withConnectionTimeout(this.solrConfiguration.getConnectionTimeout().intValue());
        }
        if (this.solrConfiguration.getSoTimeout() != null) {
            builder.withSocketTimeout(this.solrConfiguration.getSoTimeout().intValue());
        }
        if (this.solrConfiguration.getHttpClient() != null) {
            builder.withHttpClient(this.solrConfiguration.getHttpClient());
        }
        CloudSolrClient cloudSolrClient = builder.build();
        if (this.solrConfiguration.getCollection() != null && !this.solrConfiguration.getCollection().isEmpty()) {
            cloudSolrClient.setDefaultCollection(this.solrConfiguration.getCollection());
        }
        return cloudSolrClient;
    }
}

