/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.solr;

import org.apache.camel.component.solr.SolrClientHandler;
import org.apache.camel.component.solr.SolrConfiguration;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.impl.ConcurrentUpdateSolrClient;

public class SolrClientHandlerConcurrentUpdate
extends SolrClientHandler {
    public SolrClientHandlerConcurrentUpdate(SolrConfiguration solrConfiguration) {
        super(solrConfiguration);
    }

    @Override
    protected SolrClient getSolrClient() {
        ConcurrentUpdateSolrClient.Builder builder = new ConcurrentUpdateSolrClient.Builder(this.getFirstUrlFromList());
        if (this.solrConfiguration.getConnectionTimeout() != null) {
            builder.withConnectionTimeout(this.solrConfiguration.getConnectionTimeout().intValue());
        }
        if (this.solrConfiguration.getSoTimeout() != null) {
            builder.withSocketTimeout(this.solrConfiguration.getSoTimeout().intValue());
        }
        if (this.solrConfiguration.getHttpClient() != null) {
            builder.withHttpClient(this.solrConfiguration.getHttpClient());
        }
        builder.withQueueSize(this.solrConfiguration.getStreamingQueueSize());
        builder.withThreadCount(this.solrConfiguration.getStreamingThreadCount());
        return builder.build();
    }
}

