/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.solr;

import java.io.Closeable;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.apache.camel.CamelContext;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.solr.SolrComponent;
import org.apache.camel.component.solr.SolrConfiguration;
import org.apache.camel.component.solr.SolrConstants;
import org.apache.camel.component.solr.SolrProducer;
import org.apache.camel.spi.EndpointServiceLocation;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.support.ResourceHelper;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.impl.HttpJdkSolrClient;
import org.apache.solr.client.solrj.impl.HttpSolrClientBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(firstVersion="4.8.0", scheme="solr", title="Solr", syntax="solr:host:port/basePath", producerOnly=true, category={Category.SEARCH, Category.MONITORING}, headersClass=SolrConstants.class)
public class SolrEndpoint
extends DefaultEndpoint
implements EndpointServiceLocation {
    private static final Logger LOG = LoggerFactory.getLogger(SolrEndpoint.class);
    @UriParam
    private final SolrConfiguration configuration;
    private SolrClient solrClient;

    public SolrEndpoint(String uri, SolrComponent component, SolrConfiguration configuration) {
        super(uri, (Component)component);
        this.configuration = configuration;
    }

    public SolrConfiguration getConfiguration() {
        return this.configuration;
    }

    public Producer createProducer() {
        return new SolrProducer(this, this.configuration);
    }

    public Consumer createConsumer(Processor processor) {
        throw new UnsupportedOperationException("Cannot consume from a Solr endpoint: " + this.getEndpointUri());
    }

    public String getServiceUrl() {
        return this.configuration.getSolrBaseUrl();
    }

    public String getServiceProtocol() {
        return "solr";
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.solrClient == null && this.configuration.getSolrClient() == null) {
            this.solrClient = this.createSolrClient();
            LOG.info("Starting SolrClient: {}", (Object)SolrEndpoint.getSolrClientInfoString(this.solrClient, SolrEndpoint.isProcessAsync(this.solrClient, this.configuration), this.getEndpointUri()));
        }
    }

    protected void doShutdown() throws Exception {
        if (this.solrClient != null) {
            LOG.info("Stopping SolrClient: {}", (Object)SolrEndpoint.getSolrClientInfoString(this.solrClient, SolrEndpoint.isProcessAsync(this.solrClient, this.configuration), this.getEndpointUri()));
            IOHelper.close((Closeable)this.solrClient);
            this.solrClient = null;
        }
    }

    public SolrClient getSolrClient() {
        if (this.configuration.getSolrClient() != null) {
            return this.configuration.getSolrClient();
        }
        return this.solrClient;
    }

    public static String getSolrClientInfoString(SolrClient solrClient, boolean async, String endpointUri) {
        Object object;
        Object[] objectArray = new Object[4];
        objectArray[0] = solrClient.getClass().getSimpleName();
        if (solrClient instanceof HttpJdkSolrClient) {
            HttpJdkSolrClient httpJdkSolrClient = (HttpJdkSolrClient)solrClient;
            object = "@ " + httpJdkSolrClient.getBaseURL();
        } else {
            object = "";
        }
        objectArray[1] = object;
        objectArray[2] = async;
        objectArray[3] = URISupport.sanitizeUri((String)endpointUri);
        return String.format("%s %s (async=%s; endpoint=%s)", objectArray);
    }

    public SolrClient createSolrClient() {
        HttpJdkSolrClient.Builder builder = new HttpJdkSolrClient.Builder(this.configuration.getSolrBaseUrl());
        builder.withConnectionTimeout(this.configuration.getConnectionTimeout().longValue(), TimeUnit.MILLISECONDS);
        builder.withRequestTimeout(this.configuration.getRequestTimeout().longValue(), TimeUnit.MILLISECONDS);
        if (ObjectHelper.isNotEmpty((String)this.configuration.getUsername()) && ObjectHelper.isNotEmpty((String)this.configuration.getPassword())) {
            builder.withBasicAuthCredentials(this.configuration.getUsername(), this.configuration.getPassword());
        }
        if (ObjectHelper.isNotEmpty((String)this.configuration.getCertificatePath())) {
            builder.withSSLContext(SolrEndpoint.createSslContextFromCa(this.getCamelContext(), this.configuration.getCertificatePath()));
        }
        if (this.configuration.getCollection() != null) {
            builder.withDefaultCollection(this.configuration.getCollection());
        }
        return builder.build();
    }

    protected static boolean isProcessAsync(SolrClient solrClient, SolrConfiguration configuration) {
        if (!(solrClient instanceof HttpSolrClientBase)) {
            return false;
        }
        return configuration.isAsync();
    }

    private static SSLContext createSslContextFromCa(CamelContext camelContext, String certificatePath) {
        try {
            CertificateFactory factory = CertificateFactory.getInstance("X.509");
            InputStream resolveMandatoryResourceAsInputStream = ResourceHelper.resolveMandatoryResourceAsInputStream((CamelContext)camelContext, (String)certificatePath);
            Certificate trustedCa = factory.generateCertificate(resolveMandatoryResourceAsInputStream);
            KeyStore trustStore = KeyStore.getInstance("pkcs12");
            trustStore.load(null, null);
            trustStore.setCertificateEntry("ca", trustedCa);
            SSLContext sslContext = SSLContext.getInstance("TLSv1.3");
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(trustStore);
            sslContext.init(null, trustManagerFactory.getTrustManagers(), null);
            return sslContext;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

