/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.solr;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.camel.ResolveEndpointFailedException;
import org.apache.camel.component.solr.SolrOperation;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.spi.UriPath;
import org.apache.camel.util.ObjectHelper;
import org.apache.solr.client.solrj.SolrClient;

@UriParams
public class SolrConfiguration {
    @UriPath
    @Metadata(required=true)
    private String host;
    @UriPath(defaultValue="8983")
    private int port = -1;
    @UriPath(defaultValue="/solr")
    private String basePath;
    @UriParam(label="security", secret=true)
    private String username;
    @UriParam(label="security", secret=true)
    private String password;
    @UriParam
    private SolrOperation operation;
    @UriParam
    private boolean autoCommit;
    @UriParam
    private Integer size;
    @UriParam
    private Integer from;
    @UriParam
    private String collection;
    @UriParam
    private String requestHandler;
    @UriParam(defaultValue="true")
    private boolean deleteByQuery = false;
    @UriParam(label="security")
    private boolean enableSSL;
    @UriParam(label="security")
    @Metadata(supportFileReference=true)
    private String certificatePath;
    @UriParam
    private Long requestTimeout;
    @UriParam
    private Long connectionTimeout;
    @UriParam(defaultValue="true")
    private boolean async = true;
    @UriParam
    @Metadata(label="advanced")
    private SolrClient solrClient;

    public void configure(String uriString) throws URISyntaxException {
        String remainingPath;
        URI uri = new URI(uriString);
        String value = uri.getHost();
        if (value != null) {
            if (!value.equalsIgnoreCase("default")) {
                this.setHost(value);
            }
        } else {
            throw new ResolveEndpointFailedException(uriString, "Solr instance host must be configured on the endpoint");
        }
        int uriPort = uri.getPort();
        if (uriPort > 0) {
            this.setPort(uriPort);
        } else if (this.port <= 0) {
            this.setPort(8983);
        }
        String userInfo = uri.getUserInfo();
        if (userInfo != null) {
            String[] parts = uri.getUserInfo().split(":");
            if (parts.length == 2) {
                this.setUsername(parts[0]);
                this.setPassword(parts[1]);
            } else {
                this.setUsername(userInfo);
            }
        }
        if (ObjectHelper.isNotEmpty((String)(remainingPath = uri.getPath())) && !remainingPath.equals("/solr")) {
            if (remainingPath.startsWith("/solr".concat("/"))) {
                String[] parts = remainingPath.substring("/solr".concat("/").length()).split("/");
                if (parts.length > 0) {
                    this.setCollection(parts[0]);
                }
                if (parts.length > 1) {
                    StringBuilder sb = new StringBuilder();
                    for (int i = 1; i < parts.length; ++i) {
                        sb.append("/").append(parts[i]);
                    }
                    this.setRequestHandler(sb.toString());
                }
            } else {
                this.setBasePath(remainingPath);
            }
        }
    }

    public String getSolrBaseUrl() {
        return SolrConfiguration.getSolrBaseUrl(this.isEnableSSL(), this.getHost(), this.getPort(), this.getBasePath());
    }

    public static String getSolrBaseUrl(boolean sslEnabled, String host, int port, String basePath) {
        return String.format("%s://%s:%d%s", sslEnabled ? "https" : "http", host == null ? "localhost" : host, port == -1 ? 8983 : port, basePath == null ? "/solr" : basePath);
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public SolrOperation getOperation() {
        return this.operation;
    }

    public void setOperation(SolrOperation operation) {
        this.operation = operation;
    }

    public boolean isAutoCommit() {
        return this.autoCommit;
    }

    public void setAutoCommit(boolean autoCommit) {
        this.autoCommit = autoCommit;
    }

    public Integer getFrom() {
        return this.from;
    }

    public void setFrom(Integer from) {
        this.from = from;
    }

    public Integer getSize() {
        return this.size;
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    public String getCollection() {
        return this.collection;
    }

    public void setCollection(String collection) {
        this.collection = collection;
    }

    public String getRequestHandler() {
        return this.requestHandler;
    }

    public void setRequestHandler(String requestHandler) {
        this.requestHandler = requestHandler;
    }

    public SolrClient getSolrClient() {
        return this.solrClient;
    }

    public void setSolrClient(SolrClient solrClient) {
        this.solrClient = solrClient;
    }

    public boolean isDeleteByQuery() {
        return this.deleteByQuery;
    }

    public void setDeleteByQuery(boolean deleteByQuery) {
        this.deleteByQuery = deleteByQuery;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isEnableSSL() {
        return this.enableSSL;
    }

    public void setEnableSSL(boolean enableSSL) {
        this.enableSSL = enableSSL;
    }

    public String getCertificatePath() {
        return this.certificatePath;
    }

    public void setCertificatePath(String certificatePath) {
        this.certificatePath = certificatePath;
    }

    public Long getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(Long connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public boolean isAsync() {
        return this.async;
    }

    public void setAsync(boolean async) {
        this.async = async;
    }

    public Long getRequestTimeout() {
        return this.requestTimeout;
    }

    public void setRequestTimeout(Long requestTimeout) {
        this.requestTimeout = requestTimeout;
    }
}

