/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.soroushbot.component;

import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.soroushbot.component.SoroushBotAbstractConsumer;
import org.apache.camel.component.soroushbot.component.SoroushBotEndpoint;
import org.apache.camel.component.soroushbot.models.SoroushMessage;
import org.apache.camel.component.soroushbot.utils.CongestionException;
import org.apache.camel.component.soroushbot.utils.MultiQueueWithTopicThreadPool;

public class SoroushBotMultiThreadConsumer
extends SoroushBotAbstractConsumer {
    MultiQueueWithTopicThreadPool threadPool;

    public SoroushBotMultiThreadConsumer(SoroushBotEndpoint endpoint, Processor processor) {
        super(endpoint, processor);
        this.threadPool = new MultiQueueWithTopicThreadPool(endpoint.getConcurrentConsumers(), endpoint.getQueueCapacityPerThread(), "Soroush Thread");
    }

    @Override
    protected void sendExchange(Exchange exchange) {
        try {
            this.threadPool.execute(((SoroushMessage)exchange.getIn().getBody(SoroushMessage.class)).getFrom(), () -> {
                try {
                    this.getProcessor().process(exchange);
                }
                catch (Exception e) {
                    exchange.setException((Throwable)e);
                }
                if (exchange.getException() != null) {
                    this.getExceptionHandler().handleException("Error processing exchange", exchange, (Throwable)exchange.getException());
                }
                this.releaseExchange(exchange, false);
            });
        }
        catch (IllegalStateException ex) {
            throw new CongestionException(ex, (SoroushMessage)exchange.getIn().getBody(SoroushMessage.class));
        }
    }
}

