/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.soroushbot.component;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.soroushbot.component.SoroushBotEndpoint;
import org.apache.camel.component.soroushbot.models.SoroushMessage;
import org.apache.camel.component.soroushbot.service.SoroushService;
import org.apache.camel.component.soroushbot.utils.MaximumConnectionRetryReachedException;
import org.apache.camel.component.soroushbot.utils.SoroushException;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.support.task.BlockingTask;
import org.apache.camel.support.task.Tasks;
import org.apache.camel.support.task.budget.Budgets;
import org.apache.camel.support.task.budget.IterationBudget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SoroushBotSendMessageProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(SoroushBotSendMessageProducer.class);
    SoroushBotEndpoint endpoint;
    ObjectMapper objectMapper = new ObjectMapper();

    public SoroushBotSendMessageProducer(SoroushBotEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
    }

    public void process(Exchange exchange) throws Exception {
        SoroushMessage message = (SoroushMessage)exchange.getIn().getBody(SoroushMessage.class);
        if (this.endpoint.isAutoDownload()) {
            this.endpoint.handleFileUpload(message);
        }
        this.sendMessage(message);
    }

    private boolean doSendMessage(SoroushMessagePayload payload) {
        try {
            Response response = this.endpoint.getSendMessageTarget().request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.entity((Object)this.objectMapper.writeValueAsString((Object)payload.message), (MediaType)MediaType.APPLICATION_JSON_TYPE));
            SoroushService.get().assertSuccessful(response, payload.message);
            return true;
        }
        catch (IOException | ProcessingException | SoroushException e) {
            LOG.warn("failed to send message: {}", (Object)payload.message, (Object)e);
            payload.exception = e;
            return false;
        }
    }

    private void sendMessage(SoroushMessage message) throws MaximumConnectionRetryReachedException {
        SoroushMessagePayload payload;
        BlockingTask task = (BlockingTask)Tasks.foregroundTask().withBudget((IterationBudget)Budgets.iterationBudget().withMaxIterations(this.endpoint.getMaxConnectionRetry() + 1).withBackOffStrategy(this.endpoint.getBackOffStrategyHelper()).build()).withName("send-message").build();
        if (!task.run(this::doSendMessage, (Object)(payload = new SoroushMessagePayload(message))) && payload.exception != null) {
            throw new MaximumConnectionRetryReachedException("Failed to send message. maximum retry limit reached. aborting... message: " + message, payload.exception, message);
        }
    }

    private static class SoroushMessagePayload {
        final SoroushMessage message;
        Exception exception;

        public SoroushMessagePayload(SoroushMessage message) {
            this.message = message;
        }
    }
}

