/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.soroushbot.utils;

import org.apache.camel.support.task.budget.backoff.BackOffStrategy;

public class ExponentialBackOffStrategy
implements BackOffStrategy {
    private final long baseRetryTimeOut;
    private final long coefficient;

    public ExponentialBackOffStrategy(Long baseRetryTimeOut, Long coefficient) {
        this.baseRetryTimeOut = baseRetryTimeOut;
        this.coefficient = coefficient;
    }

    public long calculateInterval(int iteration) {
        if (iteration > 2) {
            long interval = (long)((double)this.baseRetryTimeOut * Math.pow(this.coefficient, iteration - 2));
            return interval;
        }
        return 0L;
    }
}

