/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.spark;

import java.util.List;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.spark.DataFrameCallback;
import org.apache.camel.component.spark.SparkEndpoint;
import org.apache.camel.support.DefaultProducer;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;

public class DataFrameSparkProducer
extends DefaultProducer {
    public DataFrameSparkProducer(SparkEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public void process(Exchange exchange) throws Exception {
        Dataset<Row> dataFrame = this.resolveDataFrame(exchange);
        DataFrameCallback dataFrameCallback = this.resolveDataFrameCallback(exchange);
        Object body = exchange.getIn().getBody();
        Object result = body instanceof List ? dataFrameCallback.onDataFrame(dataFrame, ((List)body).toArray(new Object[0])) : dataFrameCallback.onDataFrame(dataFrame, body);
        this.collectResults(exchange, result);
    }

    public SparkEndpoint getEndpoint() {
        return (SparkEndpoint)super.getEndpoint();
    }

    protected void collectResults(Exchange exchange, Object result) {
        if (result instanceof JavaRDD) {
            JavaRDD rddResults = (JavaRDD)result;
            if (this.getEndpoint().isCollect()) {
                exchange.getIn().setBody((Object)rddResults.collect());
            } else {
                exchange.getIn().setBody(result);
                exchange.getIn().setHeader("CAMEL_SPARK_RDD", result);
            }
        } else {
            exchange.getIn().setBody(result);
        }
    }

    protected Dataset<Row> resolveDataFrame(Exchange exchange) {
        if (exchange.getIn().getHeader("CAMEL_SPARK_DATAFRAME") != null) {
            return (Dataset)exchange.getIn().getHeader("CAMEL_SPARK_DATAFRAME");
        }
        if (this.getEndpoint().getDataFrame() != null) {
            return this.getEndpoint().getDataFrame();
        }
        throw new IllegalStateException("No Data Frame defined.");
    }

    protected DataFrameCallback resolveDataFrameCallback(Exchange exchange) {
        if (exchange.getIn().getHeader("CAMEL_SPARK_DATAFRAME_CALLBACK") != null) {
            return (DataFrameCallback)exchange.getIn().getHeader("CAMEL_SPARK_DATAFRAME_CALLBACK");
        }
        if (this.getEndpoint().getDataFrameCallback() != null) {
            return this.getEndpoint().getDataFrameCallback();
        }
        throw new IllegalStateException("Cannot resolve Data Frame.");
    }
}

