/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.splunkhec;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.splunkhec.SplunkHECComponent;
import org.apache.camel.component.splunkhec.SplunkHECConfiguration;
import org.apache.camel.component.splunkhec.SplunkHECConstants;
import org.apache.camel.component.splunkhec.SplunkHECProducer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.commons.validator.routines.DomainValidator;
import org.apache.commons.validator.routines.InetAddressValidator;

@UriEndpoint(firstVersion="3.3.0", scheme="splunk-hec", title="Splunk HEC", producerOnly=true, syntax="splunk-hec:splunkURL/token", category={Category.MONITORING}, headersClass=SplunkHECConstants.class)
public class SplunkHECEndpoint
extends DefaultEndpoint {
    private static final Pattern URI_PARSER = Pattern.compile("splunk-hec\\:\\/?\\/?(.*?):(\\d+)/(\\w{8}-\\w{4}-\\w{4}-\\w{4}-\\w{12})\\??.*");
    @UriPath
    @Metadata(required=true)
    private String splunkURL;
    @UriPath(label="security")
    @Metadata(required=true)
    private String token;
    @UriParam
    private SplunkHECConfiguration configuration;

    public SplunkHECEndpoint() {
    }

    public SplunkHECEndpoint(String uri, SplunkHECComponent component, SplunkHECConfiguration configuration) {
        super(uri, (Component)component);
        this.configuration = configuration;
        Matcher match = URI_PARSER.matcher(uri);
        if (!match.matches()) {
            throw new IllegalArgumentException("Invalid URI: " + uri);
        }
        String hostname = match.group(1);
        int port = Integer.parseInt(match.group(2));
        if (!DomainValidator.getInstance((boolean)true).isValid(hostname) && !InetAddressValidator.getInstance().isValidInet4Address(hostname)) {
            throw new IllegalArgumentException("Invalid hostname: " + hostname);
        }
        if (port < 1 || port > 65535) {
            throw new IllegalArgumentException("Invalid port: " + port);
        }
        this.splunkURL = hostname + ":" + port;
        this.token = match.group(3);
    }

    public Producer createProducer() {
        return new SplunkHECProducer(this);
    }

    public Consumer createConsumer(Processor processor) {
        throw new UnsupportedOperationException();
    }

    public SplunkHECConfiguration getConfiguration() {
        return this.configuration;
    }

    public String getSplunkURL() {
        return this.splunkURL;
    }

    public void setSplunkURL(String splunkURL) {
        this.splunkURL = splunkURL;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }
}

